//--------------------------------------------------------------------------
// Copyright (C) 2019-2021 Cisco and/or its affiliates. All rights reserved.
//
// This file may contain proprietary rules that were created, tested and
// certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
// rules that were created by Sourcefire and other third parties and
// distributed under the GNU General Public License (the "GPL Rules").
// The VRT Certified Rules contained in this file are the property of
// Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
// The GPL Rules created by Sourcefire, Inc. are the property of
// Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
// Reserved. All other GPL Rules are owned and copyrighted by their
// respective owners (please see www.snort.org/contributors for a list
// of owners and their respective copyrights). In order to determine what
// rules are VRT Certified Rules or GPL Rules, please refer to the VRT
// Certified Rules License Agreement.
//--------------------------------------------------------------------------
// server-other_cve-2006-4509-novell.cc author Brandon Stultz <brastult@cisco.com>

#include "main/snort_types.h"
#include "framework/so_rule.h"
#include "framework/cursor.h"
#include "protocols/packet.h"

#if(BASE_API_VERSION >= 20)
#include "helpers/ber.h"
#else
#include "utils/util_ber.h"
#endif

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

using namespace snort;

static const char* rule_13510 = R"[Snort_SO_Rule](
alert tcp any any -> $HOME_NET 389 (
	msg:"SERVER-OTHER Novell eDirectory EventsRequest heap buffer overflow attempt";
	soid:13510;
	content:"|30|",depth 1;
	content:"2.16.840.1.113719.1.27.100.";
	pcre:"/2\x2e16\x2e840\x2e1\x2e113719\x2e1\x2e27\x2e100\x2e(84|79)/";
	ber_data:0x81;
	ber_data:0x30;
	so:eval;
	metadata:policy max-detect-ips drop;
	service:ldap;
	reference:bugtraq,20663;
	reference:cve,2006-4509;
	classtype:attempted-admin;
	gid:3; sid:13510; rev:5;
)
)[Snort_SO_Rule]";

static const unsigned rule_13510_len = 0;

static IpsOption::EvalStatus eval(void*, Cursor& c, Packet* p)
{
   const uint8_t *cursor_normal = c.start();

   BerReader ber(c);

   uint32_t event_count;

   if(!ber.extract(cursor_normal, event_count))
      return IpsOption::NO_MATCH;

   if(event_count > 0x10000000)
      return IpsOption::MATCH;

   return IpsOption::NO_MATCH;
}

static SoEvalFunc ctor(const char* /*so*/, void** pv)
{
    *pv = nullptr;
    return eval;
}

static const SoApi so_13510 =
{
    { // base api info
        PT_SO_RULE,
        sizeof(SoApi),
        SOAPI_VERSION,
        5, // version of this file
        API_RESERVED,
        API_OPTIONS,
        "13510", // name
        "SERVER-OTHER Novell eDirectory EventsRequest heap buffer overflow attempt", // help
        nullptr,  // mod_ctor
        nullptr   // mod_dtor
    },
    // so rule api info
    (uint8_t*)rule_13510,
    rule_13510_len,
    nullptr, // pinit
    nullptr, // pterm
    nullptr, // tinit
    nullptr, // tterm
    ctor, // ctor
    nullptr  // dtor
};

const BaseApi* pso_13510 = &so_13510.base;

