//--------------------------------------------------------------------------
// Copyright (C) 2019-2021 Cisco and/or its affiliates. All rights reserved.
//
// This file may contain proprietary rules that were created, tested and
// certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
// rules that were created by Sourcefire and other third parties and
// distributed under the GNU General Public License (the "GPL Rules").
// The VRT Certified Rules contained in this file are the property of
// Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
// The GPL Rules created by Sourcefire, Inc. are the property of
// Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
// Reserved. All other GPL Rules are owned and copyrighted by their
// respective owners (please see www.snort.org/contributors for a list
// of owners and their respective copyrights). In order to determine what
// rules are VRT Certified Rules or GPL Rules, please refer to the VRT
// Certified Rules License Agreement.
//--------------------------------------------------------------------------
// malware-cnc_locky-ver1.cc author Brandon Stultz <brastult@cisco.com>

#include "main/snort_types.h"
#include "framework/so_rule.h"
#include "framework/cursor.h"
#include "protocols/packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

#define DECODE_BUF_SIZE 24

static inline uint32_t rotl32(uint32_t val, unsigned int count) {
   return (val << (count & 31)) | (val >> (32 - (count & 31)));
}

static inline uint32_t rotr32(uint32_t val, unsigned int count) {
   return (val >> (count & 31)) | (val << (32 - (count & 31)));
}

using namespace snort;

static const char* rule_38834 = R"[Snort_SO_Rule](
alert http (
	msg:"MALWARE-CNC Win.Trojan.Locky variant outbound connection attempt";
	soid:38834;
	flow:to_server,established;
	http_uri;
	content:".php";
	http_client_body;
	so:eval;
	metadata:impact_flag red, policy max-detect-ips drop, policy security-ips drop;
	service:http;
	reference:url,www.virustotal.com/en/file/ee6abe4a9530b78e997d9c28394356216778eaf2d46aa3503999e7d6bfbefe90/analysis/;
	classtype:trojan-activity;
	gid:3; sid:38834; rev:1;
)
)[Snort_SO_Rule]";

static const unsigned rule_38834_len = 0;

static IpsOption::EvalStatus eval(void*, Cursor& c, Packet* p)
{
   const uint8_t *cursor_normal = c.start(),
                 *end_of_buffer = c.endo();

   unsigned char decode_buf[DECODE_BUF_SIZE];
   uint32_t t4, t0;
   int i;

   if(cursor_normal + DECODE_BUF_SIZE > end_of_buffer)
      return IpsOption::NO_MATCH;

   for(i=0, t0=0xCD43EF19; i < DECODE_BUF_SIZE; i++)
   {
      t4 = cursor_normal[i] ^ (rotr32(t0, 5) & 0xFF);

      decode_buf[i] = t4 & 0xFF;

      t0 = (rotr32(i, 0x17) + 0x53702F68) ^ (rotr32(t0, 1) + rotl32(t4, (i & 0x1F)));
   }

   if(decode_buf[16] == 'i' && decode_buf[17] == 'd' && decode_buf[18] == '=')
      return IpsOption::MATCH;
 
   return IpsOption::NO_MATCH;
}

static SoEvalFunc ctor(const char* /*so*/, void** pv)
{
    *pv = nullptr;
    return eval;
}

static const SoApi so_38834 =
{
    { // base api info
        PT_SO_RULE,
        sizeof(SoApi),
        SOAPI_VERSION,
        1, // version of this file
        API_RESERVED,
        API_OPTIONS,
        "38834", // name
        "MALWARE-CNC Win.Trojan.Locky variant outbound connection attempt", // help
        nullptr,  // mod_ctor
        nullptr   // mod_dtor
    },
    // so rule api info
    (uint8_t*)rule_38834,
    rule_38834_len,
    nullptr, // pinit
    nullptr, // pterm
    nullptr, // tinit
    nullptr, // tterm
    ctor,    // ctor
    nullptr  // dtor
};

const BaseApi* pso_38834 = &so_38834.base;

