/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

/* declare detection functions */
int rule15149eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule15149flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule15149option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15149flow0
    }
};
// content:"0", depth 1; 
static ContentInfo rule15149content1 = 
{
    (uint8_t *) "0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15149option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15149content1
    }
};

/* references for sid 15149 */
/* reference: bugtraq "30177"; */
static RuleReference rule15149ref1 = 
{
    "bugtraq", /* type */
    "30177" /* value */
};

/* reference: cve "2008-2595"; */
static RuleReference rule15149ref2 = 
{
    "cve", /* type */
    "2008-2595" /* value */
};

/* reference: url "www.oracle.com/technology/deploy/security/critical-patch-updates/cpujul2008.html"; */
static RuleReference rule15149ref3 = 
{
    "url", /* type */
    "www.oracle.com/technology/deploy/security/critical-patch-updates/cpujul2008.html" /* value */
};

static RuleReference *rule15149refs[] =
{
    &rule15149ref1,
    &rule15149ref2,
    &rule15149ref3,
    NULL
};

/* metadata for sid 15149 */
/* metadata:service ldap, policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule15149service1 = 
{
    "service ldap"
};
//
//
//static RuleMetaData rule15149policy1 = 
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule15149policy2 = 
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule15149policy3 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule15149metadata[] =
{
    &rule15149service1,
//    &rule15149policy1,
//    &rule15149policy2,
    &rule15149policy3,
    NULL
};

RuleOption *rule15149options[] =
{
    &rule15149option0,
    &rule15149option1,
    NULL
};

Rule rule15149 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "389", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       15149, /* sigid */
       6, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-ORACLE Oracle Internet Directory pre-auth ldap denial of service attempt",     /* message */
       rule15149refs /* ptr to references */
       ,rule15149metadata
   },
   rule15149options, /* ptr to rule options */
   &rule15149eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15149eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_payload;
    SFSnortPacket *sp = (SFSnortPacket *) p;

   int retval;
   BER_ELEMENT element;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if (checkFlow(p, rule15149options[0]->option_u.flowFlags) <= 0 ) {
        return RULE_NOMATCH;
    }

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // Universal Sequence
   if(ber_point_to_data(sp, &cursor_normal, 0x30) < 0)
      return RULE_NOMATCH;

   // message ID
   if(ber_skip_element(sp, &cursor_normal, 0x02) < 0)
      return RULE_NOMATCH;

   // find the bind request
   if(ber_point_to_data(sp, &cursor_normal, 0x60) < 0)
      return RULE_NOMATCH;

   /* bind requests are defined as:
      int version
      LDAPDN name
      auth authenticationChoice
      bug here is if the version element is specified as a cursor (0x30) vs. an int (0x02)
   */
   retval = ber_get_element(sp, cursor_normal, &element);

   if(retval == -1)
      return RULE_NOMATCH;

   if(element.type == 0x30)
      return RULE_MATCH;

    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15149,
    NULL
};
*/

