/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

!!! DOES *NOT* USE BUILT-IN DETECTION FUNCTIONS !!!

alert udp $EXTERNAL_NET any -> $HOME_NET 161 (msg:"DOS linux kernel snmp nat netfilter memory corruption attempt"; flow:to_server; content:"|30|"; depth:1; reference:bugtraq,18081; reference:cve,CVE-2006-2444; reference:url,kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.18; classtype:attempted-dos; sid:13773; rev:1;)

 */

//#define DEBUG
#ifdef DEBUG
#define DEBUG_WRAP(code) code
#else
#define DEBUG_WRAP(code)
#endif


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "so-util_ber.h"

/* declare detection functions */
int rule13773eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:to_server; */
static FlowFlags rule13773flow0 = 
{
    // only reassembled to have modicum protection against invalid reads
    // in the trap pdu caused by fragmentation causing false positives

    FLOW_TO_SERVER|FLOW_ONLY_REASSMBLED 
};

static RuleOption rule13773option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13773flow0
    }
};
// content:"0", depth 1; 
static ContentInfo rule13773content1 = 
{
    (uint8_t *) "0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13773option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13773content1
    }
};

/* references for sid 13773 */
/* reference: bugtraq "18081"; */
static RuleReference rule13773ref1 = 
{
    "bugtraq", /* type */
    "18081" /* value */
};

/* reference: cve "2006-2444"; */
static RuleReference rule13773ref2 = 
{
    "cve", /* type */
    "2006-2444" /* value */
};

/* reference: url "kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.18"; */
static RuleReference rule13773ref3 = 
{
    "url", /* type */
    "kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.18" /* value */
};

/* reference: cve "2008-1673"; */
static RuleReference rule13773ref4 =
{
    "cve", /* type */
    "2008-1673" /* value */
};

/* reference: url "kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.25.5"; */
static RuleReference rule13773ref5 =
{
    "url", /* type */
    "kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.25.5" /* value */
};

static RuleReference *rule13773refs[] =
{
    &rule13773ref1,
    &rule13773ref2,
    &rule13773ref3,
    &rule13773ref4,
    &rule13773ref5,
    NULL
};

/* metadata for sid 13773 */
/* metadata:; */
static RuleMetaData rule13773service1 =
{
    "service snmp"
};

static RuleMetaData rule13773policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule13773metadata[] =
{
    &rule13773service1,
    &rule13773policy1,
    NULL
};

RuleOption *rule13773options[] =
{
    &rule13773option0,
    &rule13773option1,
    NULL
};

Rule rule13773 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "161:162", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13773, /* sigid */
       8, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-LINUX linux kernel snmp nat netfilter memory corruption attempt",     /* message */
       rule13773refs /* ptr to references */
       ,rule13773metadata
   },
   rule13773options, /* ptr to rule options */
   &rule13773eval, /* DOES *NOT* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
/* process_v1_trap
 * Determines if the trap is malicious or not.  *ANY* read error within the trap-PDU
 * is flagged as malicous, including wrong type, out of data in packet, out of data
 * in sequence, etc.
 * 
 * returns <0 for error, 0 for not malicious, 1 for malicious
*/
int process_v1_trap(SFSnortPacket *sp, const uint8_t *cursor_normal, uint32_t trap_pdu_len) {
   int retval;
   BER_ELEMENT element;

   uint32_t actual_len = 0;  // Tracks how much data is specified within the pdu

   DEBUG_WRAP(printf("rule13773eval: process_v1_trap: start\n"));

   // We should now be at the start of the trap-PDU
   // It is an implicit sequence, meaning there is no 0x30 at the start.
   // Instead, the first element is...

   DEBUG_WRAP(printf("rule13773eval: process_v1_trap: testing enterprise object\n"));

   // enterprise Object Identifier
   retval = ber_get_element(sp, cursor_normal, &element);

   if((retval < 0) || (element.type != 0x06) || (element.data_len == 0)) 
      return 1;

   actual_len += element.total_len;
   if(actual_len >= trap_pdu_len)
      return 1;

   cursor_normal += element.total_len;
 
   DEBUG_WRAP(printf("rule13773eval: process_v1_trap: testing agent-addr\n"));

   // agent-addr
   retval = ber_get_element(sp, cursor_normal, &element);

   if((retval < 0) || (element.type != 0x40) ||
                      (element.data_len != 4)) { // 4-byte address
      return 1;
   }

   actual_len += element.total_len;
   if(actual_len >= trap_pdu_len)
      return 1;

   cursor_normal += element.total_len; 

   // For whatever reason, snmp_trap_decode() in ip_nat_snmp_basic.c parses
   // through to the timestamp of the trap, rather than just stopping at the
   // address.  So we need to jump two ints and find the timestamp, which
   // apparently is either a basic int or an application data type 3 (SNMP_TIT)

   // We can't just use ber_skip_element because we need to make sure we don't
   // overstep trap_pdu_len (but honestly, looking at the code I don't think
   // linux cares.  But it's an error so alert, anyway.

   DEBUG_WRAP(printf("rule13773eval: addr fine, checking generic-trap\n"));

   // generic-trap
   retval = ber_get_element(sp, cursor_normal, &element);
   if((retval < 0) || (element.type != 0x02))
      return 1;

   actual_len += element.total_len;
   if(actual_len >= trap_pdu_len)
      return 1;

   cursor_normal += element.total_len;

   DEBUG_WRAP(printf("rule13773eval: checking specific-trap\n"));

   // specific-trap
   retval = ber_get_element(sp, cursor_normal, &element);
   if((retval < 0) || (element.type != 0x02))
      return 1;

   actual_len += element.total_len;
   if(actual_len >= trap_pdu_len)
      return 1;

   cursor_normal += element.total_len;

   DEBUG_WRAP(printf("rule13773eval: checking timestamp\n"));

   // Here's where it gets fun.  Either it's a timestamp that's just a
   // straight int (type 0x02) or it's application data that is a
   // timestamp (type 0x43)
   retval = ber_get_element(sp, cursor_normal, &element);
   if((retval < 0) || ((element.type != 0x02) && (element.type != 0x43)))
      return 1;

   actual_len += element.total_len;
   if(actual_len >= trap_pdu_len)
      return 1;

   DEBUG_WRAP(printf("rule13773eval: timestamp fine.  we're done\n"));

   // And now, after looking through the code, this statement seems true...
   //
   // After this point, we're going to assume the decoder doesn't care
   // The whole point is that the kernel goes into the structure and
   // modifies the address (and stores the timestamp in a structure).

   // Why would they do anything but blindly copy the rest of the data
   // from this point forward?

   return 0;
}


int rule13773eval(void *p) {
   const uint8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   /*const uint8_t *end_of_payload; */

   int retval;
   uint32_t snmp_ver;
   uint32_t size_len, size;
   BER_ELEMENT element;

   DEBUG_WRAP(printf("rule13773eval: (linux netfilter snmp nat) begin\n"));

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:to_server; XXX bleh flow with UDP 
//   if(checkFlow(p, rule13773options[0]->option_u.flowFlags) <= 0 )
//      return RULE_NOMATCH;

   // content:"0", depth 1;
   if(contentMatch(p, rule13773options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   // Custom detection -- step through the structure to find the SNMP Trap and any anomalies
   // The content match puts us just past the universal sequence; we'll start from there --

   DEBUG_WRAP(printf("rule13773eval: start custom detection\n"));

   // Jump over the size of the message
   retval = ber_get_size(p, cursor_normal, &size_len, &size); 

   if(retval < 0)
      return(RULE_NOMATCH);

   cursor_normal += size_len;

   DEBUG_WRAP(printf("rule13773eval: checking SNMP version\n"));

   // SNMP version. Because we're going to check the version, we need to make sure
   // the full data is present
   retval = ber_get_element(p, cursor_normal, &element);

   if((retval < 0) || (element.type != 0x02) || (retval != element.data_len))
      return RULE_NOMATCH;

   // Get the value of the SNMP version
   retval = ber_extract_int_val(&element);
   if(retval < 0)
      return RULE_NOMATCH;

   snmp_ver = element.data.int_val;
   DEBUG_WRAP(printf("rule13773eval: snmp_ver=%d\n", snmp_ver));

   cursor_normal += element.total_len;

   DEBUG_WRAP(printf("rule13773eval: checking community string\n"));

   // Community string
   retval = ber_get_element(p, cursor_normal, &element);

   if((retval < 0) || (element.type != 0x04))
      return RULE_NOMATCH;

   cursor_normal += element.total_len;   

   DEBUG_WRAP(printf("rule13773eval: processing trap-pdu, snmp_ver=%d\n", snmp_ver));

   // Here's where the trap information is located
   if(snmp_ver <= 1) {  // PROTOS only does SNMPv1, but some other samples are using SNMPv2
      retval = ber_get_element(p, cursor_normal, &element);

      if(retval < 0) {
         DEBUG_WRAP(printf("rule13773eval: failed to read element\n"));
         return RULE_NOMATCH;
      }

      DEBUG_WRAP(printf("rule13773eval: element.type=%#x (want 0xA4)\n", element.type));
      cursor_normal = element.data.data_ptr;

      // Apparently, you can use V1 traps with SNMPv2.
      if(element.type == 0xA4) {
         if(process_v1_trap(sp, cursor_normal, element.data_len) > 0)
            return RULE_MATCH;
//      } else if(element.type == 0xA7) { // Schema for V2 trap in bug 42464 / RFC1905 if needed
//         if(process_v2_trap(sp, cursor_normal, element.data_len) > 0)
//            return RULE_MATCH;
      } else {
         return RULE_NOMATCH;
      }
   } 

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13773,
    NULL
};
*/

