/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule18063eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule18063flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule18063option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule18063flow0
    }
};
/* flowbits:isset "file.doc"; */
static FlowBitsInfo rule18063flowbits1 =
{
    "file.doc",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule18063option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule18063flowbits1
    }
};
// content:"|0F 00 03 F0|", depth 0; 
static ContentInfo rule18063content2 = 
{
    (uint8_t *) "|0F 00 03 F0|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18063option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18063content2
    }
};
// content:"|0F 00 04 F0|", depth 0, fast_pattern; 
static ContentInfo rule18063content3 = 
{
    (uint8_t *) "|0F 00 04 F0|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18063option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18063content3
    }
};
// content:"|02|", depth 0, relative; 
static ContentInfo rule18063content4 = 
{
    (uint8_t *) "|02|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18063option4 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18063content4
    }
};
// content:"|0A F0 08 00 00 00 00|", depth 0, relative; 
static ContentInfo rule18063content5 = 
{
    (uint8_t *) "|0A F0 08 00 00 00|", /* pattern (now in snort content format) */
    200, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|CONTENT_FAST_PATTERN, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18063option5 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18063content5
    }
};
// content:"|01 00 09 F0 10 00 00 00|", depth 0, relative; 
static ContentInfo rule18063content6 = 
{
    (uint8_t *) "|01 00 09 F0 10 00 00 00|", /* pattern (now in snort content format) */
    200, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18063option6 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18063content6
    }
};

/* references for sid 18063 */
/* reference: cve "2010-3334"; */
static RuleReference rule18063ref1 = 
{
    "cve", /* type */
    "2010-3334" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-087"; */
static RuleReference rule18063ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-087" /* value */
};

static RuleReference *rule18063refs[] =
{
    &rule18063ref1,
    &rule18063ref2,
    NULL
};
/* metadata for sid 18063 */
/* metadata:service http, policy balanced-ips drop, policy security-ips alert; */
static RuleMetaData rule18063service1 = 
{
    "service http"
};


//static RuleMetaData rule18063policy1 = 
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule18063policy2 = 
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule18063policy3 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule18063metadata[] =
{
    &rule18063service1,
//    &rule18063policy1,
//    &rule18063policy2,
    &rule18063policy3,
    NULL
};

RuleOption *rule18063options[] =
{
    &rule18063option0,
    &rule18063option1,
    &rule18063option2,
    &rule18063option3,
    &rule18063option4,
    &rule18063option5,
    &rule18063option6,
    NULL
};

Rule rule18063 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       18063, /* sigid */
       11, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-OFFICE Microsoft Office embedded Office Art drawings execution attempt",     /* message */
       rule18063refs /* ptr to references */
       ,rule18063metadata
   },
   rule18063options, /* ptr to rule options */
   &rule18063eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule18063eval(void *p) {
    const uint8_t *cursor_normal = 0, *OfficeArtSPContainer = 0, *OfficeArtSpgrContainer = 0, *OfficeArtFSP = 0, *OfficeArtFSPGR = 0;
    const uint8_t *beg_of_payload = 0, *end_of_payload = 0, *tmp_payload = 0;
    uint32_t OfficeArtSpgrContainer_size = 0, OfficeArtSPContainer_size = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule18063options[0]->option_u.flowFlags) <= 0 ) {
       return RULE_NOMATCH;
    }
    // flowbits:isset "file.doc";
    if (processFlowbits(p, rule18063options[1]->option_u.flowBit) <= 0) {
       return RULE_NOMATCH;
    }
    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0) {
      return RULE_NOMATCH;
    }

    // Start by finding inner container
    // content:"|0F 00 04 F0|", depth 0, fast_pattern;
    if (contentMatch(p, rule18063options[3]->option_u.content, &OfficeArtSPContainer) <= 0) {
       return RULE_NOMATCH;
    }

    DEBUG_SO(fprintf(stderr, "OfficeArtSPContainer found: %p\n", OfficeArtSPContainer);)
    
    // Find the outer container - This may or may not exist
    // content:"|0F 00 03 F0|", depth 0; 
    if(contentMatch(p, rule18063options[2]->option_u.content, &OfficeArtSpgrContainer) <= 0) {
        // If this fails, the pointer OfficeArtSpgrContainer will be NULL when we check it below
    }

    if(OfficeArtSpgrContainer != NULL) {
       DEBUG_SO(fprintf(stderr, "OfficeArtSpgrContainer found: %p\n", OfficeArtSpgrContainer));
    }

    // Get the size of the outer container and make sure we are not inside of it
    // This bug only occurs if the inner container is found outside of the outer container
    if(OfficeArtSpgrContainer != NULL) {

      // Read the size of the container for later use
      if((OfficeArtSpgrContainer + 4) > end_of_payload) {
         return RULE_NOMATCH;
      }
      OfficeArtSpgrContainer_size = read_little_32(OfficeArtSpgrContainer);
      DEBUG_SO(fprintf(stderr, "OfficeArtSpgrContainer_size: 0x%08x (%d)\n", OfficeArtSpgrContainer_size, OfficeArtSpgrContainer_size));

      // Make sure we have a size and it's in our payload
      tmp_payload = OfficeArtSpgrContainer + OfficeArtSpgrContainer_size;
      if((tmp_payload > end_of_payload) || (tmp_payload < OfficeArtSpgrContainer)) {
         return RULE_NOMATCH;
      }

      // Make sure the inner container isn't inside the outer container
      if((OfficeArtSpgrContainer < OfficeArtSPContainer) && (OfficeArtSpgrContainer_size != 0)) {
         if(OfficeArtSPContainer < tmp_payload) {
            DEBUG_SO(fprintf(stderr, "OfficeArtSPContainer found within OfficeArtSpgrContainer\n"));
            return RULE_NOMATCH;
         }
      }
    }

    // Now we need the size of the inner container
    if((OfficeArtSPContainer + 4) > end_of_payload) {
       return RULE_NOMATCH;
    }

    OfficeArtSPContainer_size = read_little_32(OfficeArtSPContainer);
    DEBUG_SO(fprintf(stderr, "OfficeArtSPContainer_size: 0x%08x (%d)\n", OfficeArtSPContainer_size, OfficeArtSPContainer_size));

    // Make sure we have a size and that it's in our payload
    tmp_payload = OfficeArtSPContainer + OfficeArtSPContainer_size;
    if((tmp_payload > end_of_payload) || (tmp_payload < OfficeArtSPContainer)) {
       return RULE_NOMATCH;
    }

    // Now we need to search this container for a OfficeArtFSP record
    // content:"|0A F0 08 00 00 00 00|", depth 0, relative;
    OfficeArtFSP = OfficeArtSPContainer + 4; // OfficeArtSPContainer currently points to the 4 byte size field of OfficeArtSPContainer
    OfficeArtFSPGR = OfficeArtSPContainer + 4; // This object will be within the same container

    // Limit the search to be only within this container
    if (contentMatch(p, rule18063options[5]->option_u.content, &OfficeArtFSP) <= 0) {
       DEBUG_SO(fprintf(stderr, "OfficeArtFSP was not found inside of OfficeArtSPContainer\n"));
       return RULE_NOMATCH;
    }

    DEBUG_SO(fprintf(stderr, "OfficeArtFSP found inside of OfficeArtSPContainer: %p\n", OfficeArtFSP));

    // Make sure it was found inside of our container
    if(OfficeArtFSP > tmp_payload) {
       return RULE_NOMATCH;
    }

    // Check the fGroup bit of OfficeArtFSP
    OfficeArtFSP += 4;
    if(OfficeArtFSP > end_of_payload) {
       return RULE_NOMATCH;
    }

    // We only care about the first bit of the first byte
    if((*OfficeArtFSP & 1) != 1) {
       DEBUG_SO(fprintf(stderr, "fGroup flag was not set: 0x%x\n", *OfficeArtFSP));
       return RULE_NOMATCH;
    }

    DEBUG_SO(fprintf(stderr, "fGroup flag was set: 0x%x\n", *OfficeArtFSP));

    // Finally, if there are any OfficeArtFSPGR structures before our OfficeArtFSP then we should exit
    // If OfficeArtFSPGR is not found we are finished and this is a match.
    // If it is found, we need to determine if it is before OfficeArtFSP
    // This may or may not exist.  The bug is caused by having OfficeArtFSP before any OfficeArtFSPGR
    if((contentMatch(p, rule18063options[6]->option_u.content, &OfficeArtFSPGR) <= 0) || (OfficeArtFSP < OfficeArtFSPGR)) {
       return RULE_MATCH;
    }
      
    return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule18063,
    NULL
};
*/
