/*
alert tcp $EXTERNAL_NET any -> $HOME_NET 25 (msg:"SMTP Exchange compressed RTF remote code execution attempt"; flow:to_server,established; content:"Content-Type: application/ms-tnef"; nocase; content:"Content-Transfer-Encoding: base64"; nocase; pcre:"/([AEIMQUYcgkosw048]\s*C\s*A\s*Q\s*k\s*Q\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AEIMQUYcgkosw048]\s*[A-L]\s*A\s*A\s*A\s*A\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[EUk0]\s*(x\s*a\s*R\s*n\s*[UVWX]|1\s*F\s*T\s*E\s*[EFGH])|[AQgw]\s*I\s*B\s*C\s*R\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AQgw]\s*[AEIMQUYcgkos]\s*A\s*A\s*A\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*T\s*(F\s*p\s*G\s*d|U\s*V\s*M\s*Q)\s*[QRSTUVWXYZabcdef]|A\s*g\s*E\s*J\s*E\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[ABC]\s*[AQgw]\s*A\s*A\s*A\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[BFJNRVZdhlptx159]\s*(M\s*W\s*k\s*Z\s*1|N\s*R\s*U\s*x\s*B))/sO"; metadata:service smtp, policy security-ips drop; reference:cve,2009-0098; reference:url,technet.microsoft.com/en-us/security/bulletin/MS09-003; classtype:attempted-admin; sid:15301; rev:1;)
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule15301eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule15301flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule15301option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15301flow0
    }
};
// content:"Content-Type|3A| application/ms-tnef", depth 0, nocase; 
static ContentInfo rule15301content1 = 
{
    (uint8_t *) "Content-Type|3A| application/ms-tnef", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED|CONTENT_FAST_PATTERN, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15301option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15301content1
    }
};
// content:"Content-Transfer-Encoding|3A| base64", depth 0, nocase; 
static ContentInfo rule15301content2 = 
{
    (uint8_t *) "Content-Transfer-Encoding|3A| base64", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15301option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15301content2
    }
};
#ifndef SNORT_PCRE_OVERRIDE_MATCH_LIMIT
#define SNORT_PCRE_OVERRIDE_MATCH_LIMIT 0
#endif

// pcre:"([AEIMQUYcgkosw048]\s*C\s*A\s*Q\s*k\s*Q\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AEIMQUYcgkosw048]\s*[A-L]\s*A\s*A\s*A\s*A\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[EUk0]\s*(x\s*a\s*R\s*n\s*[UVWX]|1\s*F\s*T\s*E\s*[EFGH])|[AQgw]\s*I\s*B\s*C\s*R\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AQgw]\s*[AEIMQUYcgkos]\s*A\s*A\s*A\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*T\s*(F\s*p\s*G\s*d|U\s*V\s*M\s*Q)\s*[QRSTUVWXYZabcdef]|A\s*g\s*E\s*J\s*E\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[ABC]\s*[AQgw]\s*A\s*A\s*A\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[BFJNRVZdhlptx159]\s*(M\s*W\s*k\s*Z\s*1|N\s*R\s*U\s*x\s*B))", dotall, nolimit;
static PCREInfo rule15301pcre3 =
{
    "([AEIMQUYcgkosw048]\\s*C\\s*A\\s*Q\\s*k\\s*Q\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[AEIMQUYcgkosw048]\\s*[A-L]\\s*A\\s*A\\s*A\\s*A\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[EUk0]\\s*(x\\s*a\\s*R\\s*n\\s*[UVWX]|1\\s*F\\s*T\\s*E\\s*[EFGH])|[AQgw]\\s*I\\s*B\\s*C\\s*R\\s*[ABCD]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[AQgw]\\s*[AEIMQUYcgkos]\\s*A\\s*A\\s*A\\s*[ABCD]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*T\\s*(F\\s*p\\s*G\\s*d|U\\s*V\\s*M\\s*Q)\\s*[QRSTUVWXYZabcdef]|A\\s*g\\s*E\\s*J\\s*E\\s*[ABCDEFGHIJKLMNOP]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[ABC]\\s*[AQgw]\\s*A\\s*A\\s*A\\s*[ABCDEFGHIJKLMNOP]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[A-Za-z0-9+/]\\s*[BFJNRVZdhlptx159]\\s*(M\\s*W\\s*k\\s*Z\\s*1|N\\s*R\\s*U\\s*x\\s*B))", /* pattern */
    NULL,                               /* holder for compiled pattern */
    NULL,                               /* holder for compiled pattern flags */
    PCRE_DOTALL|SNORT_PCRE_OVERRIDE_MATCH_LIMIT,     /* compile flags */
    CONTENT_BUF_NORMALIZED     /* content flags */
};

static RuleOption rule15301option3 =
{
    OPTION_TYPE_PCRE,
    {
        &rule15301pcre3
    }
};

/* references for sid 15301 */
/* reference: cve "2009-0098"; */
static RuleReference rule15301ref1 = 
{
    "cve", /* type */
    "2009-0098" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS09-003"; */
static RuleReference rule15301ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-003" /* value */
};

static RuleReference *rule15301refs[] =
{
    &rule15301ref1,
    &rule15301ref2,
    NULL
};
/* metadata for sid 15301 */
/* metadata:service smtp, policy security-ips drop; */
static RuleMetaData rule15301service1 = 
{
    "service smtp"
};


//static RuleMetaData rule15301policy1 = 
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule15301policy2 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule15301metadata[] =
{
    &rule15301service1,
//    &rule15301policy1,
    &rule15301policy2,
    NULL
};
RuleOption *rule15301options[] =
{
    &rule15301option0,
    &rule15301option1,
    &rule15301option2,
    &rule15301option3,
    NULL
};

Rule rule15301 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "25", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       15301, /* sigid */
       5, /* revision */
   
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-MAIL Exchange compressed RTF remote code execution attempt",     /* message */
       rule15301refs /* ptr to references */
       ,rule15301metadata
   },
   rule15301options, /* ptr to rule options */
   NULL, // &rule15301eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15301eval(void *p) {
//    const uint8_t *cursor_uri = 0;
//    const uint8_t *cursor_raw = 0;
    const uint8_t *cursor_normal = 0;
//    const uint8_t *cursor_http_uri = 0;
//    const uint8_t *cursor_http_header = 0;
//    const uint8_t *cursor_http_client_body = 0;
//    const uint8_t *cursor_http_method = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if (checkFlow(p, rule15301options[0]->option_u.flowFlags) > 0 ) {
        // content:"Content-Type|3A| application/ms-tnef", depth 0, nocase;
        if (contentMatch(p, rule15301options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"Content-Transfer-Encoding|3A| base64", depth 0, nocase;
            if (contentMatch(p, rule15301options[2]->option_u.content, &cursor_normal) > 0) {
                // pcre:"([AEIMQUYcgkosw048]\s*C\s*A\s*Q\s*k\s*Q\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AEIMQUYcgkosw048]\s*[A-L]\s*A\s*A\s*A\s*A\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[EUk0]\s*(x\s*a\s*R\s*n\s*[UVWX]|1\s*F\s*T\s*E\s*[EFGH])|[AQgw]\s*I\s*B\s*C\s*R\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[AQgw]\s*[AEIMQUYcgkos]\s*A\s*A\s*A\s*[ABCD]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*T\s*(F\s*p\s*G\s*d|U\s*V\s*M\s*Q)\s*[QRSTUVWXYZabcdef]|A\s*g\s*E\s*J\s*E\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[ABC]\s*[AQgw]\s*A\s*A\s*A\s*[ABCDEFGHIJKLMNOP]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[A-Za-z0-9+/]\s*[BFJNRVZdhlptx159]\s*(M\s*W\s*k\s*Z\s*1|N\s*R\s*U\s*x\s*B))", dotall, nolimit;
                if (pcreMatch(p, rule15301options[3]->option_u.pcre, &cursor_normal)) {
                    return RULE_MATCH;
                }
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15301,
    NULL
};
*/
