/*

 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

#include <stdlib.h>
#include <string.h>

//#define DEBUG 1
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule20275eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule20275flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule20275option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule20275flow0
    }
};
/* flowbits:isset "dce.net_share_enum_all.request"; */
static FlowBitsInfo rule20275flowbits1 =
{
    "dce.net_share_enum_all.request",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule20275option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule20275flowbits1
    }
};
// content:"|FF|SMB%", offset 4, depth 5, fast_pattern; 
static ContentInfo rule20275content2 = 
{
    (uint8_t *) "|FF|SMB%", /* pattern (now in snort content format) */
    5, /* depth */
    4, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20275option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20275content2
    }
};
/* byte_test:size 1, value 128, operator &, offset 4, relative; */
static ByteData rule20275byte_test3 = 
{
    1, /* size */
    CHECK_AND, /* operator */
    128, /* value */
    4, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule20275option3 = 
{
    OPTION_TYPE_BYTE_TEST,
    {
        &rule20275byte_test3
    }
};

// content:"|05 00 02|", offset 51, depth 3, relative; 
static ContentInfo rule20275content4 = 
{
    (uint8_t *) "|05 00 02|", /* pattern (now in snort content format) */
    3, /* depth */
    51, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20275option4 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20275content4
    }
};
/* flowbits:unset "dce.net_share_enum_all.request"; */
static FlowBitsInfo rule20275flowbits5 =
{
    "dce.net_share_enum_all.request",
    FLOWBIT_UNSET,
    0,
};

static RuleOption rule20275option5 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule20275flowbits5
    }
};

// content:"|01 00 00 00 01 00 00 00|", offset 21, depth 8, fast_pattern; 
static ContentInfo rule20275content6 = 
{
    (uint8_t *) "|01 00 00 00 01 00 00 00|", /* pattern (now in snort content format) */
    8, /* depth */
    21, /* offset */
    CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20275option6 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20275content6
    }
};


/* references for sid 20275 */
/* reference: bugtraq "35206"; */
static RuleReference rule20275ref1 = 
{
    "bugtraq", /* type */
    "35206" /* value */
};

/* reference: cve "2009-0228"; */
static RuleReference rule20275ref2 = 
{
    "cve", /* type */
    "2009-0228" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS09-022"; */
static RuleReference rule20275ref3 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-022" /* value */
};

static RuleReference *rule20275refs[] =
{
    &rule20275ref1,
    &rule20275ref2,
    &rule20275ref3,
    NULL
};

/* metadata for sid 20275 */
/* metadata:policy max-detect-ips drop; */
static RuleMetaData rule20275policy1 = 
{
   "policy max-detect-ips drop"
};

static RuleMetaData *rule20275metadata[] =
{
    &rule20275policy1,
    NULL
};

RuleOption *rule20275options[] =
{
    &rule20275option0,
    &rule20275option1,
    &rule20275option2,
    &rule20275option3,
    &rule20275option4,
    &rule20275option5,
    &rule20275option6,
    NULL
};

Rule rule20275 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "[139,445]", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       20275, /* sigid */
       7, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "NETBIOS DCERPC NCACN-IP-TCP spoolss NetShareEnumAll response overflow attempt",     /* message */
       rule20275refs /* ptr to references */
       ,rule20275metadata
   },
   rule20275options, /* ptr to rule options */
   &rule20275eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
#define NUM_ARRAYS 20
int rule20275eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_payload = 0, *beg_of_payload = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;
    uint32_t arrays = 0, array_ctr = 0, data_size = 0;
    uint8_t check_array[NUM_ARRAYS];
    int j;
    const uint8_t *tmp_ptr;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule20275options[0]->option_u.flowFlags) <= 0 ) {
        return RULE_NOMATCH;
    }
        
    // flowbits:isset "dce.net_share_enum_all.request";
    if (processFlowbits(p, rule20275options[1]->option_u.flowBit) <= 0) {
        DEBUG_SO(fprintf(stderr, "Flowbit is not set\n"));
        return RULE_NOMATCH;
    }

    // content:"|FF|SMB%", offset 4, depth 5, fast_pattern;
    if (contentMatch(p, rule20275options[2]->option_u.content, &cursor_normal) <= 0) {
        DEBUG_SO(fprintf(stderr, "SMB header check failed\n"));
        return RULE_NOMATCH;
    }
    
    // byte_test:size 1, value 128, operator &, offset 4, relative;
    if (byteTest(p, rule20275options[3]->option_u.byte, cursor_normal) <= 0) {
        DEBUG_SO(fprintf(stderr, "SMB response flag checked failed\n"));
        return RULE_NOMATCH;
    }
                    
    // content:"|05 00 02|", offset 51, depth 3, relative;
    if (contentMatch(p, rule20275options[4]->option_u.content, &cursor_normal) <= 0) {
        DEBUG_SO(fprintf(stderr, "DCERPC header check failed\n"));
        return RULE_NOMATCH;
    }
                        
    // flowbits:unset "dce.net_share_enum_all.request";
    if (processFlowbits(p, rule20275options[5]->option_u.flowBit) <= 0) {
        return RULE_NOMATCH;
    }

    // content:"|01 00 00 00 01 00 00 00|", offset 21, depth 8, fast_pattern; 
    if (contentMatch(p, rule20275options[6]->option_u.content, &cursor_normal) <= 0) {
        DEBUG_SO(fprintf(stderr, "Information level or outer counter not equal to 1\n"));
        return RULE_NOMATCH;
    }

    // Save for later
    if(getBuffer(p, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0) {
        return RULE_NOMATCH;
    }
 
    // Should be at the beginning of the dcerpc header
    if ((cursor_normal + 16) > end_of_payload) {
        DEBUG_SO(fprintf(stderr, "Not enough data to read level\n"));
        return RULE_NOMATCH;
    }

    // Read in the number of arrays
    cursor_normal += 4;
    arrays = read_little_32(cursor_normal);
    cursor_normal += 12;
    
    // Make sure this value is somewhat sane
    if(arrays > NUM_ARRAYS) {
        DEBUG_SO(fprintf(stderr, "Too many returned entries to check\n"));
        return RULE_NOMATCH;
    }
    
    // Also make sure there is enough data to read all arrays (12 * arrays)
    if((cursor_normal + (arrays * 12)) > end_of_payload) {
        DEBUG_SO(fprintf(stderr, "Not enough data to read all entries in array\n"));
        return RULE_NOMATCH;
    }
    
    DEBUG_SO(fprintf(stderr, "Array entries: %d\n", arrays));
    
    // Check each structure in this array and mark the ones we need to check for later
    memset(check_array, 0, sizeof(check_array)); // Initialize all values to zero
    for(array_ctr = 0; array_ctr < arrays; array_ctr++) {
        if((read_little_32(cursor_normal + 4)) == 1) {
            check_array[array_ctr] = 1;
        }
        cursor_normal += 12;
    }
    
    // We should be sitting at the beginning of the actual data array entries
    for(array_ctr = 0; array_ctr < arrays; array_ctr++){
        for(j = 0; j < 2; j++) { // Same code to process the name then the comment   
            // Check to make sure we have enough data to read the header of this structure
            if(cursor_normal + 12 > end_of_payload) {
                DEBUG_SO(fprintf(stderr, "Not enough data to read the header of array entry %d\n", array_ctr));
                return RULE_NOMATCH;
            }
        
            // Check the device name actual count (unicode)
            data_size = read_little_32(cursor_normal + 8);

            // If data_size is odd it gets padded with two nulls (multiply by 2 because it's unicode)
            data_size += (data_size & 0x01); // make even length
            data_size <<= 1; // Multiply by 2
 
            DEBUG_SO(fprintf(stderr, "data_size (loop %d): %d\n", j, data_size));
            if(data_size > 519 && (check_array[array_ctr] == 1)) { // Alert string len > 519
               return RULE_MATCH;
            }

            // Move to next structure
            tmp_ptr = cursor_normal + data_size + 12;
            if(tmp_ptr < cursor_normal)
               return RULE_NOMATCH;

            cursor_normal = tmp_ptr;
        }
    }
    
    return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule20275,
    NULL
};
*/
