/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

DOES NOT USE BUILT-IN DETECTION FUNCTIONS!!


 */

#include <stdio.h>

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

/* declare detection functions */
static int rule13667eval(void *p);

typedef struct _DnsHash {
    uint32_t chksum;
    uint8_t count;
} DnsHash;

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:to_client; */
static FlowFlags rule13667flow0 = 
{
    FLOW_TO_CLIENT
};

static RuleOption rule13667option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13667flow0
    }
};
// content:"|85|", offset 2, depth 1; 
//static ContentInfo rule13667content1 = 
//{
//    (uint8_t *) "|85|", /* pattern (now in snort content format) */
//    1, /* depth */
//    2, /* offset */
//    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
//    NULL, /* holder for boyer/moore PTR */
//    NULL, /* more holder info - byteform */
//    0, /* byteform length */
//    0 /* increment length*/
//};
//
//static RuleOption rule13667option1 = 
//{
//    OPTION_TYPE_CONTENT,
//    {
//        &rule13667content1
//    }
//};
///* byte_test:size 2, value 0, operator >, offset 6; */
//static ByteData rule13667byte_test2 = 
//{
//    2, /* size */
//    CHECK_GT, /* operator */
//    0, /* value */
//    6, /* offset */
//    0, /*multiplier */
//    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
//};
//
//static RuleOption rule13667option2 = 
//{
//    OPTION_TYPE_BYTE_TEST,
//    {
//        &rule13667byte_test2
//    }
//};

/* references for sid 13667 */
/* reference: cve "2008-0087"; */
static RuleReference rule13667ref1 = 
{
    "cve", /* type */
    "2008-0087" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-020"; */
static RuleReference rule13667ref2 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-020" /* value */
};

static RuleReference rule13667ref3 =
{
    "cve", /* type */
    "2008-1447" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-020"; */
static RuleReference rule13667ref4 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-037" /* value */
};

static RuleReference rule13667ref5 =
{
    "cve",
    "1999-0024"
};

static RuleReference rule13667ref6 =
{
    "url",
    "www.kb.cert.org/vuls/id/800113"
};

static RuleReference rule13667ref7 =
{
    "cve", /* type */
    "2009-0233" /* value */
};

static RuleReference rule13667ref8 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-008" /* value */
};

static RuleReference rule13667ref9 =
{
    "cve", /* type */
    "2007-3898" /* value */
};

static RuleReference rule13667ref10 =
{
    "cve", /* type */
    "2009-0234" /* value */
};


static RuleReference *rule13667refs[] =
{
    &rule13667ref1,
    &rule13667ref2,
    &rule13667ref3,
    &rule13667ref4,
    &rule13667ref5,
    &rule13667ref6,
    &rule13667ref7,
    &rule13667ref8,
    &rule13667ref9,
    &rule13667ref10,
    NULL
};
/* metadata for sid 13667 */
/* metadata:; */

static RuleMetaData rule13667service1 =
{
    "service dns"
};

static RuleMetaData rule13667policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule13667metadata[] =
{
    &rule13667service1,
    &rule13667policy1,
    NULL
};

RuleOption *rule13667options[] =
{
    &rule13667option0,
//    &rule13667option1,
//    &rule13667option2,
    NULL
};

Rule rule13667 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "any", /* SRCIP     */
       "53", /* SRCPORT   */
       0, /* DIRECTION */
       "any", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13667, /* sigid */
       19, /* revision */
   
       "misc-attack", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "PROTOCOL-DNS dns cache poisoning attempt",     /* message */
       rule13667refs /* ptr to references */
       ,rule13667metadata
   },
   rule13667options, /* ptr to rule options */
   &rule13667eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};

/* taken from snort_stream5_session.c */
#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))
    
#define mix(a,b,c)  {  a -= c;  a ^= rot(c, 4);  c += b;  b -= a;  b ^= rot(a, 6);  a += c;  c -= b;  c ^= rot(b, 8);  b += a;  a -= c;  a ^= rot(c,16);  c += b;  b -= a;  b ^= rot(a,19);  a += c;  c -= b;  c ^= rot(b, 4);  b += a;  }
#define final(a,b,c)  {  c ^= b; c -= rot(b,14);  a ^= c; a -= rot(c,11);  b ^= a; b -= rot(a,25);  c ^= b; c -= rot(b,16);  a ^= c; a -= rot(c,4);   b ^= a; b -= rot(a,14);  c ^= b; c -= rot(b,24);  }

static uint32_t rule13667checksum(const uint8_t *buf, uint32_t len) {
    uint32_t a = 0, b = 0, c = 0, tmp = 0;
    unsigned int i,j,k,l;

    for (i=0,j=0;i<len;i+=4) {
        tmp = 0;
        k = len - i;
        if (k > 4)
            k=4;

        for (l=0;l<k;l++) {
            tmp |= *(buf + i + l) << l*8;
        }

        switch (j) {
            case 0:
                a += tmp;
                break;
            case 1:
                b += tmp;
                break;
            case 2:
                c += tmp;
                break;
        }
        j++;

        if (j == 3) {
            mix(a,b,c);
            j = 0;
        }
    }

    final(a,b,c);

    return c;
}

/* detection functions */
static int rule13667eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_payload, *beg_of_payload;
    uint32_t chksum;

    DnsHash *hash;

    SFSnortPacket *sp = (SFSnortPacket *) p;

//printf("rule13667eval enter\n"); 

    if((sp == NULL) || (sp->stream_session_ptr == NULL))
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;

    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
        return RULE_NOMATCH;
    
    // flow:to_client;
//    if (checkFlow(p, rule13667options[0]->option_u.flowFlags) > 0 ) {
        // content:"|85|", offset 2, depth 1;
//        if (contentMatch(p, rule13667options[1]->option_u.content, &cursor_normal) > 0) {
            // byte_test:size 2, value 0, operator >, offset 6;

    cursor_normal = beg_of_payload;

    if(cursor_normal + 3 > end_of_payload)
        return RULE_NOMATCH;

    if((cursor_normal[2] & 0xF9) != 0x81) // Response, Standard query, Recursion desired == (10000..1 binary)
        return RULE_NOMATCH;

//printf("packet is a response to a standard query with recursion desired.\n");

//  I guess we don't care if there are any answers?  Maybe we should check to see if either
//  answers or authoritative nameservers is > 0?  But then I think *all* responses will probably
//  hit that so it's a wasted check.
//
//            if (byteTest(p, rule13667options[1/*2*/]->option_u.byte, cursor_normal) > 0) {
//printf("byte_test worked\n");
#ifndef BEFORE_2091300
                getRuleData(sp, &(rule13667.info), (void*)(&hash), NULL);
#else
                hash = (DnsHash *)getRuleData(sp, (uint32_t)rule13667.info.sigID);
#endif

                if(!hash) {
                    hash = (DnsHash *)allocRuleData(sizeof(DnsHash));
                    if (hash == NULL)
                       return RULE_NOMATCH;

#ifndef BEFORE_2091300
                    if(storeRuleData(sp, &(rule13667.info), hash, NULL) < 0)
#else
                    if(storeRuleData(sp, hash, rule13667.info.sigID, &freeRuleData) < 0)
#endif
                    {
                       freeRuleData(hash);
                       return RULE_NOMATCH;
                    }
                }

//                if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
//                    return RULE_NOMATCH;

                cursor_normal = beg_of_payload;

                chksum = rule13667checksum(cursor_normal + 2, ((end_of_payload - cursor_normal) - 2));

                if (hash->chksum == chksum) {
                    hash->count++;
                    if (hash->count > 50) { 
                        /*
                         * ghetto thresholding, as thresholding isn't available 
                         * to SO rules 
                         */
                        hash->count = 0;
                        return RULE_MATCH;
                    }
                } else {
                    hash->chksum = chksum;
                    hash->count = 0;
                    return RULE_NOMATCH;
                }
//            }
//        }
//    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13667,
    NULL
};
*/
