/* !!! XXX DOES NOT USE BUILT-IN DETECTION FUNCTION XXX !!!
 * alert tcp $EXTERNAL_NET any -> $HOME_NET any (msg:"BAD-TRAFFIC small or zero-sized tcp window"; flow:to_server,established; reference:cve,2008-4609; reference:cve,2009-1926; reference:url,www.microsoft.com/technet/security/bulletin/MS09-048.mspx; classtype:attempted-dos; sid:15912;)
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


// This is for ignoring all possible reassembled packets, not just those covered by the
// FLOW_IGNORE_REASSEMBLED option to checkFlow.
#ifndef REASSEMBLED_PACKET_FLAGS
#define REASSEMBLED_PACKET_FLAGS (FLAG_REBUILT_STREAM|FLAG_SMB_SEG|FLAG_DCE_SEG|FLAG_DCE_FRAG|FLAG_SMB_TRANS)
#endif

/* declare detection functions */
int rule15912eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule15912flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule15912option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15912flow0
    }
};

static PreprocessorOption rule15912stream_size1 =
{
    "stream_size",
    "server,<=,2",
    0,
    NULL,
    NULL,
    NULL
};

static RuleOption rule15912option1 =
{
    OPTION_TYPE_PREPROCESSOR,
    {
        &rule15912stream_size1
    }
};


/* references for sid 15912 */
/* reference: cve "2008-4609"; */
static RuleReference rule15912ref1 = 
{
    "cve", /* type */
    "2008-4609" /* value */
};

/* reference: cve "2009-1926"; */
static RuleReference rule15912ref2 = 
{
    "cve", /* type */
    "2009-1926" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS09-048"; */
static RuleReference rule15912ref3 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-048" /* value */
};

static RuleReference *rule15912refs[] =
{
    &rule15912ref1,
    &rule15912ref2,
    &rule15912ref3,
    NULL
};
/* metadata for sid 15912 */
/* metadata:; */
//static RuleMetaData rule15912policy1 =
//{
//   "policy max-detect-ips drop"
//};


static RuleMetaData *rule15912metadata[] =
{
//    &rule15912policy1,
    NULL
};

RuleOption *rule15912options[] =
{
    &rule15912option0,
    &rule15912option1,
    NULL
};

Rule rule15912 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       15912, /* sigid */
       10, /* revision */
   
//       "attempted-dos; detection_filter: track by_src, count 200, seconds 30", /* classification */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS TCP window closed before receiving data",     /* message */
       rule15912refs /* ptr to references */
       ,rule15912metadata
   },
   rule15912options, /* ptr to rule options */
   &rule15912eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15912eval(void *p) {
    SFSnortPacket *sp = (SFSnortPacket *) p;
    const uint8_t *cursor_normal;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;

    if(sp->flags & REASSEMBLED_PACKET_FLAGS)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if(checkFlow(p, rule15912options[0]->option_u.flowFlags) > 0 ) {

    if(sp->tcp_header == NULL)
       return RULE_NOMATCH;

    // Ignore RST packets.  Zero window RSTs happen a lot
    // Not to mention that wouldn't work for the DoS
    if(sp->tcp_header->flags & TCPHEADER_RST)
        return RULE_NOMATCH;
    
    //printf("tcp window size = %d\n", ntohs(sp->tcp_header->window));
    if(ntohs(sp->tcp_header->window) <= 4)
        // We are testing for the server not having sent anything before the window gets slammed shut
        // stream_size:server,<=,2;
        if(preprocOptionEval(p, rule15912options[1]->option_u.preprocOpt, &cursor_normal) > 0) {
            return RULE_MATCH;
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15912,
    NULL
};
*/

