/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif


/* declare detection functions */
int rule24971eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule24971flow0 = 
{
   FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule24971option0 =
{
   OPTION_TYPE_FLOWFLAGS,
   {
      &rule24971flow0
   }
};

/* flowbits:isset "file.otf"; */
static FlowBitsInfo rule24971flowbits1 =
{
   "file.otf",
   FLOWBIT_ISSET,
   0,
};

static RuleOption rule24971option1 =
{
   OPTION_TYPE_FLOWBIT,
   {
      &rule24971flowbits1
   }
};

// file_data;
static CursorInfo rule24971file_data2 =
{
   0, /* offset */
   CONTENT_BUF_NORMALIZED /* flags */
};

static RuleOption rule24971option2 =
{
#ifndef MISSINGFILEDATA
   OPTION_TYPE_FILE_DATA,
#else
   OPTION_TYPE_SET_CURSOR,
#endif
   {
      &rule24971file_data2
   }
};

// content:"OTTO", depth 4, fast_pattern; 
static ContentInfo rule24971content3 = 
{
   (uint8_t *) "OTTO", /* pattern (now in snort content format) */
   4, /* depth */
   0, /* offset */
   CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule24971option3 = 
{
   OPTION_TYPE_CONTENT,
   {
      &rule24971content3
   }
};

// content:"CFF ", depth 256, relative; 
static ContentInfo rule24971content4 = 
{
   (uint8_t *) "CFF ", /* pattern (now in snort content format) */
   256, /* depth */
   0, /* offset */
   CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule24971option4 = 
{
   OPTION_TYPE_CONTENT,
   {
      &rule24971content4
   }
};

/* byte_jump:size 4, offset 4, relative, from_beginning; */
static ByteData rule24971byte_jump5 = 
{
   4, /* size */
   0, /* operator, byte_jump doesn't use operator! */
   0, /* value, byte_jump doesn't use value! */
   4, /* offset */
   #ifdef MISSING_BYTE_JUMP_FIX
   1, /* XXX BUG 76359 */ /* multiplier */
#else
   0, /* multiplier */
#endif
   BYTE_BIG_ENDIAN|CONTENT_RELATIVE|JUMP_FROM_BEGINNING|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule24971option5 = 
{
   OPTION_TYPE_BYTE_JUMP,
   {
      &rule24971byte_jump5
   }
};

/* references for sid 24971 */
/* reference: cve "2012-2556"; */
static RuleReference rule24971ref1 = 
{
   "cve", /* type */
   "2012-2556" /* value */
};

/* reference: url "technet.microsoft.com/security/bulletin/MS12-078"; */
static RuleReference rule24971ref2 = 
{
   "url", /* type */
   "technet.microsoft.com/security/bulletin/MS12-078" /* value */
};

static RuleReference *rule24971refs[] =
{
   &rule24971ref1,
   &rule24971ref2,
   NULL
};

/* metadata for sid 24971 */
/* metadata:service http, service imap, service pop3, policy security-ips drop; */
static RuleMetaData rule24971service1 = 
{
   "service http"
};

static RuleMetaData rule24971service2 = 
{
   "service imap"
};

static RuleMetaData rule24971service3 = 
{
   "service pop3"
};

static RuleMetaData rule24971policy1 = 
{
   "policy security-ips drop"
};

static RuleMetaData *rule24971metadata[] =
{
   &rule24971service1,
   &rule24971service2,
   &rule24971service3,
   &rule24971policy1,
   NULL
};

RuleOption *rule24971options[] =
{
   &rule24971option0,
   &rule24971option1,
   &rule24971option2,
   &rule24971option3,
   &rule24971option4,
   &rule24971option5,
   NULL
};

Rule rule24971 = {
   /* rule header, akin to => tcp any any -> any any */
   {
      IPPROTO_TCP, /* proto */
      "$EXTERNAL_NET", /* SRCIP     */
      "$FILE_DATA_PORTS", /* SRCPORT   */
      0, /* DIRECTION */
      "$HOME_NET", /* DSTIP     */
      "any", /* DSTPORT   */
   },
   /* metadata */
   { 
      3,  /* genid */
      24971, /* sigid */
      3, /* revision */
      "attempted-dos", /* classification */
      0,  /* hardcoded priority */
      "FILE-OTHER Microsoft Windows ATMFD Adobe font driver reserved command denial of service attempt",     /* message */
      rule24971refs, /* ptr to references */
      rule24971metadata /* ptr to metadata */
   },
   rule24971options, /* ptr to rule options */
   &rule24971eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */

uint16_t last_offset(const uint8_t *c,const uint8_t *e, uint16_t count, uint8_t size) {
// this takes the cursor position, end of buffer, number of offset and offset size
// returns the value of the last offset DOES NOT MOVE THE CURSOR
// this works when the cursor is in front of the offset size byte
// c = cursor
// e = end_of_buffer
// count = number of offsets
// size = size of offsets
   
   uint16_t last_off = RULE_NOMATCH;
   DEBUG_SO(fprintf(stderr,"last_offset function\n");)
 
   switch(size) {
      case 1:
         // jump to last offset
         c += 1 + (size * count);

         if (c + 1 <= e)
            last_off = *c + (size * (count + 1));

         break;
    
      case 2:
         // jump to last offset
         c += 1 + (size * (count));

         if (c + 2 <= e)
            last_off = read_big_16(c);

         break;
   }

   DEBUG_SO(fprintf(stderr,"last_off = %d\n",last_off);)

   return last_off;   
}

int rule24971eval(void *p) {
   const uint8_t *cursor_normal = 0;
   const uint8_t *beg_of_buffer = 0;
   const uint8_t *end_of_buffer = 0;
   const uint8_t *cursor_detect = 0;
   const uint8_t *cffData  = 0;
   const uint8_t *end_of_charStrings = 0;
   const uint8_t *end_of_dictINDEX = 0;
   uint8_t hdrSize = 0;
   uint16_t count = 0;
   uint8_t offSize = 0;
   uint16_t last_data = 0;
   uint8_t byte = 0;
   uint8_t first_byte = 0;
   uint8_t second_byte = 0;
   uint16_t charString_offset = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;
   
   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if(checkFlow(p, rule24971options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   // flowbits:isset "file.otf";
   if(processFlowbits(p, rule24971options[1]->option_u.flowBit) <= 0)
      return RULE_NOMATCH;

   // file_data;
   #ifndef MISSINGFILEDATA
   if(fileData(p, rule24971options[2]->option_u.cursor, &cursor_normal) <= 0)
      return RULE_NOMATCH;
   #else
   if(setCursor(p, rule24971options[2]->option_u.cursor, &cursor_normal) <= 0)
      return RULE_NOMATCH;
   #endif
   
   // content:"OTTO", depth 4, fast_pattern;
   if(contentMatch(p, rule24971options[3]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   // content:"CFF ", depth 256, relative;
   if(contentMatch(p, rule24971options[4]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   // byte_jump:size 4, offset 4, relative, from_beginning;
   if(byteJump(p, rule24971options[5]->option_u.byte, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   cursor_detect = cursor_normal;

   // we need the offset of the beginning of CFFData for later
   cffData = cursor_detect;

   // Get our buffer data
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_buffer, &end_of_buffer) <= 0)
      return RULE_NOMATCH;

   if (cursor_detect + 3 > end_of_buffer)
      return RULE_NOMATCH;

   hdrSize = *(cursor_detect + 2);
   DEBUG_SO(fprintf(stderr, "hdrSize: %d\n", hdrSize));

   // hdrSize needs to be at least 4 bytes
   if (hdrSize < 4)
      return RULE_NOMATCH;

   // jump over CFFData header hdrSize
   cursor_detect += hdrSize;

   // read the offsize and count from Name_Index
   if((cursor_detect < cursor_normal) || (cursor_detect + 3 > end_of_buffer)) {
      return RULE_NOMATCH;
   }

   count = read_big_16(cursor_detect);
   cursor_detect += 2;
   offSize = *cursor_detect;
   DEBUG_SO(fprintf(stderr, "count: %d\n", count));
   DEBUG_SO(fprintf(stderr, "offSize: %d\n", offSize));

   if (offSize != 1 && offSize != 2) // offSize must be 1 or 2
      return RULE_NOMATCH;

   // find last_data for Name_INDEX and jump over it
   cursor_detect += last_offset(cursor_detect,end_of_buffer,count,offSize);

   if((cursor_detect < cursor_normal) || (cursor_detect > end_of_buffer)) {
      return RULE_NOMATCH;
   }

   // we need the offset to CharStrings, this is operand 0x11
   // find 11, back up 2 bytes and read the offset
   // find last_data for Top_DICT_INDEX
   // read the offsize and count from Top_DICT_INDEX
   if (cursor_detect + 3 > end_of_buffer)
     return RULE_NOMATCH;

   count = read_big_16(cursor_detect);
   offSize = *(cursor_detect + 2);
   DEBUG_SO(fprintf(stderr, "count: %d\n", count));
   DEBUG_SO(fprintf(stderr, "offSize: %d\n", offSize));

   if (offSize != 1 && offSize != 2) // offSize must be 1 or 2
      return RULE_NOMATCH;

   // find the last_data for Top_DICT_INDEX
   last_data = last_offset(cursor_detect + 2,end_of_buffer,count,offSize);

   // jump over the offset array
   cursor_detect += (count*offSize) + 2;
   end_of_dictINDEX = cursor_detect + last_data;

   // Make sure we are still good
   if((cursor_detect < cursor_normal) || (cursor_detect > end_of_buffer)) {
      return RULE_NOMATCH;
   }
   if((end_of_dictINDEX < cursor_normal) || (end_of_dictINDEX > end_of_buffer)) {
      return RULE_NOMATCH;
   }

    // find 0x11 in the Top_DICT_INDEX data
   // 0x11 is the CharSrtrings operator DICTEntry
   while ( cursor_detect < end_of_dictINDEX) {

      // find the operator  we want (0x11) and back up 2 bytes
      // the two previous bytes are the offset to char_strings_index
      if(*(cursor_detect + 2) == 0x11) {
         first_byte = *cursor_detect;
         DEBUG_SO(fprintf(stderr, "first_byte: 0x%02x\n", first_byte));
         break;
      }
      cursor_detect += 3; // if it's not 0x11 increment and keep looking
   }
  
   // Bail if we didn't find 0x11
   if(first_byte == 0) {
      return RULE_NOMATCH;
   }

   // this is a charString encoded number
   // byte between 32 and 246
   // value = byte - 139
   //
   // byte between 247 and 250
   // value = (byte-247)*256 + nextByte + 108
   
   // this byte needs to be in between 247 and 250
   if ((first_byte < 247 ) || ( first_byte > 250))
      return RULE_NOMATCH;
  
   // calculate the offset
   // v is first byte, w is second byte
   // (v-247) * 256 + w + 108
   cursor_detect++;

   if (cursor_detect + 1 > end_of_buffer)
      return RULE_NOMATCH;

   second_byte = *cursor_detect;

   DEBUG_SO(fprintf(stderr,"second byte = 0x%02x\n",second_byte);)
   charString_offset = (first_byte - 247) * 256 + second_byte + 108;

   // jump to the charString structure charString_offset + cffData
   cursor_detect = cffData + charString_offset;

   // read the count and offSize
   if ((cursor_detect < cursor_normal) || (cursor_detect + 3 > end_of_buffer)) {
      return RULE_NOMATCH;
   }

   count = read_big_16(cursor_detect);
   cursor_detect += 2;
   offSize = *cursor_detect;
   DEBUG_SO(fprintf(stderr, "count: %d\n", count));
   DEBUG_SO(fprintf(stderr, "offSize: %d\n", offSize));

   if (offSize != 1 && offSize != 2) // offSize must be 1 or 2
      return RULE_NOMATCH;

   // find the last_data for Top_DICT_INDEX
   last_data = last_offset(cursor_detect,end_of_buffer,count,offSize);

   // jump over offSize
   cursor_detect++;

   // jump over all the CharString offset array
   cursor_detect += (count+1)*offSize;
   end_of_charStrings = cursor_detect + last_data;
   
   if((end_of_charStrings < cursor_normal) || (cursor_detect < cursor_normal)) {
      return RULE_NOMATCH;
   }
   if(end_of_charStrings > end_of_buffer) {
      end_of_charStrings = end_of_buffer;
   }

   // find 0x0D in the CharStrings
   while ( cursor_detect < ( end_of_charStrings )) {
      if (*cursor_detect == 0x0D) {
         if(*(cursor_detect - 1) < 247) { // back up 2 more and check if operator (00 - 1f)
            if (*(cursor_detect - 3) > 0x1f){ // if this byte is not 0x00-0x1F then it is a third operand to 0x0D
               return RULE_MATCH;
            }
         }
      }

      cursor_detect++;
   }

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule24971,
    NULL
};
*/
