/* 
 * Use at your own risk. 
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

   DOES NOT USE THE BUILT-IN DETECTION FUNCTIONS!  THIS IS JUST A BASE!

alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"Microsoft GDI emf metafile buffer overflow attempt"; flow:to_client,established; flowbits:isset,file.emf; content:"|79 00 00 00|"; metadata:policy security-ips drop; reference:cve,2008-1087; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-021; classtype:attempted-user; sid:13676; rev:1;)

 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule13676eval(void *p);
int rule40130eval(void *p);
static int DetectGdiEmfOverflow(SFSnortPacket *sp);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_client; */
static FlowFlags rule13676flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule13676option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13676flow0
    }
};

/* flow:established, to_server; */
static FlowFlags rule40130flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule40130option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule40130flow0
    }
};

/* flowbits:isset "file.emf"; */
static FlowBitsInfo rule_DetectGdiEmfOverflow_flowbits1 =
{
    "file.emf",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule_DetectGdiEmfOverflow_option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule_DetectGdiEmfOverflow_flowbits1
    }
};

// file_data;
static CursorInfo rule_DetectGdiEmfOverflow_file_data2 =
{
   0, /* offset */
   CONTENT_BUF_NORMALIZED /* flags */
};

static RuleOption rule_DetectGdiEmfOverflow_option2 =
{
#ifndef MISSINGFILEDATA
   OPTION_TYPE_FILE_DATA,
#else
   OPTION_TYPE_SET_CURSOR,
#endif
   {
      &rule_DetectGdiEmfOverflow_file_data2
   }
};

// content:"y|00 00 00|"; 
static ContentInfo rule_DetectGdiEmfOverflow_content3 = 
{
    (uint8_t *) "y|00 00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule_DetectGdiEmfOverflow_option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule_DetectGdiEmfOverflow_content3
    }
};

/* references for sid 13676 */
/* reference: cve "2008-1087"; */
static RuleReference rule_DetectGdiEmfOverflow_ref1 = 
{
    "cve", /* type */
    "2008-1087" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-021"; */
static RuleReference rule_DetectGdiEmfOverflow_ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-021" /* value */
};

static RuleReference *rule_DetectGdiEmfOverflow_refs[] =
{
    &rule_DetectGdiEmfOverflow_ref1,
    &rule_DetectGdiEmfOverflow_ref2,
    NULL
};

/* metadata */

/* metadata for sid 13676 */
static RuleMetaData rule13676service1 =
{
   "service ftp-data"
};

static RuleMetaData rule13676service2 =
{
   "service http"
};

static RuleMetaData rule13676service3 =
{
   "service imap"
};

static RuleMetaData rule13676service4 =
{
   "service pop3"
};

static RuleMetaData rule13676policy1 =
{
   "policy max-detect-ips drop"
};

static RuleMetaData *rule13676metadata[] =
{
   &rule13676service1,
   &rule13676service2,
   &rule13676service3,
   &rule13676service4,
   &rule13676policy1,
   NULL
};

static RuleMetaData rule40130policy1 =
{
   "policy max-detect-ips drop"
};

/* metadata for sid 40130 */
static RuleMetaData rule40130service1 =
{
   "service smtp"
};

static RuleMetaData *rule40130metadata[] =
{
   &rule40130service1,
   &rule40130policy1,
   NULL
};

RuleOption *rule13676options[] =
{
   &rule13676option0,
   &rule_DetectGdiEmfOverflow_option1,
   &rule_DetectGdiEmfOverflow_option2,
   &rule_DetectGdiEmfOverflow_option3,
   NULL
};

Rule rule13676 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$FILE_DATA_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13676, /* sigid */
       10, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Windows GDI emf filename buffer overflow attempt",     /* message */
       rule_DetectGdiEmfOverflow_refs, /* ptr to references */
       rule13676metadata
   },
   rule13676options, /* ptr to rule options */
   &rule13676eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};

RuleOption *rule40130options[] =
{
   &rule40130option0,
   &rule_DetectGdiEmfOverflow_option1,
   &rule_DetectGdiEmfOverflow_option2,
   &rule_DetectGdiEmfOverflow_option3,
   NULL
};

Rule rule40130 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$SMTP_SERVERS", /* DSTIP     */
       "25", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       40130, /* sigid */
       2, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Windows GDI emf filename buffer overflow attempt",     /* message */
       rule_DetectGdiEmfOverflow_refs, /* ptr to references */
       rule40130metadata
   },
   rule40130options, /* ptr to rule options */
   &rule40130eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};

/* detection functions */
int rule13676eval(void *p) {
   SFSnortPacket *sp = (SFSnortPacket *) p;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if(checkFlow(p, rule13676options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   return DetectGdiEmfOverflow(sp);
}

int rule40130eval(void *p) {
   SFSnortPacket *sp = (SFSnortPacket *) p;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_server;
   if(checkFlow(p, rule40130options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   return DetectGdiEmfOverflow(sp);
}

int DetectGdiEmfOverflow(SFSnortPacket *sp) {
    const uint8_t *cursor_normal, *beg_of_payload, *end_of_payload;
    int i;

    // flowbits:isset "file.emf";
    if(processFlowbits(sp, rule13676options[1]->option_u.flowBit) <= 0)
       return RULE_NOMATCH;

    // file_data;
    #ifndef MISSINGFILEDATA
    if(fileData(sp, rule13676options[2]->option_u.cursor, &cursor_normal) <= 0)
       return RULE_NOMATCH;
    #else
    if(setCursor(sp, rule13676options[2]->option_u.cursor, &cursor_normal) <= 0)
       return RULE_NOMATCH;
    #endif

    // content:"y|00 00 00|";
    if (contentMatch(sp, rule13676options[3]->option_u.content, &cursor_normal) > 0) {

        if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
            return RULE_NOMATCH;

       /* Begin actual detection -- cursor is after the header.  Now we skip 5 DWORDs
          and check for a unicode null (0x0000) within 260 unicode characters.  If
          no unicode null is found, alert. 
       */             

       cursor_normal += 20;  // 5 * 4 DWORDs

       for(i=0; i<260; i++) {  // 260 unicode chars
          if((cursor_normal + 1) < end_of_payload) { // need room for unicode char
             if(*((uint16_t*)cursor_normal) == 0x0000) { // if we get a unicode null
                // Doing the typedef ignores endianness, but since we're looking for
                // a double NULL byte order doesn't matter.
                return RULE_NOMATCH;
             }
          } else {  // not enough data
             return RULE_NOMATCH;
          }
          cursor_normal += 2;
       }
 
       // If we got through all 260 chars without a null, match
       return RULE_MATCH;
    }

    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13676,
    &rule40130,
    NULL
};
*/

