--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "Perl Jam"
version: 6
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Zoho SalesIQ Chat' => 'Live chat software for website visitors and for customer support.',
          'Office 365' => 'Traffic generated by MS Office 365 applications and web services.',
          'Zoho Docs' => 'Online document management software that lets you manage and store all your files on the cloud.',
          'GoToMeeting' => 'Online meeting and desktop sharing service.',
          'Zoho Social' => 'A social media management tool.',
          'Zoho Assist' => 'A remote support and remote access software.',
          'Nintendo' => 'Content delivery and web traffic from Nintendo, a Japanese company.',
          'Zoho Connect' => 'A team collaboration software.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_perl_jam",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--detectorType(0-> Web, 1->Client),  AppId, SSLPattern
gSSLHostPatternList = {

    -- Office 365
    { 0, 2812, 'nexus.officeapps.live.com' },
    { 0, 2812, 'officehome.msocdn.com' },
    { 0, 2812, 'scuofficehome.msocdn.com' },
    { 0, 2812, 'eusofficehome.msocdn.com' },
    { 0, 2812, 'seaofficehome.msocdn.com' },
    { 0, 2812, 'msauth.net' },
    { 0, 2812, 'msauthimages.net' },
    { 0, 2812, 'msftauth.net' },
    { 0, 2812, 'msftauthimages.net' },
    { 0, 2812, 'officecdn.microsoft.com.edgesuite.net' },
    { 0, 2812, 'staffhub.ms' },
    { 0, 2812, 'mem.gfx.ms' },
    { 0, 2812, 'assets.onestore.ms' },
    { 0, 2812, 'o365weve.com' },
    { 0, 2812, 'msappproxy.net' },
    { 0, 2812, 'officeppe.com' },
    -- GoToMeeting
    { 0, 187, 'gotomeet.at' },
    { 0, 187, 'goto-rtc.com' },
    { 0, 187, 'gotomeet.me' },
    { 0, 187, 'gotomeeting.com' },
    { 0, 187, 'gotomeet.com' },
    { 0, 187, 'joingotomeeting.com' },
    -- Nintendo
    { 0, 4130, 'nintendo.com' },
    { 0, 4130, 'nintendo.net' },
    { 0, 4130, 'nintendoofamericainc.demdex.net' },
    { 0, 4130, 'nintendoofamerica.tt.omtrdc.net' },
    { 0, 4130, 'nintendo.co.jp' },
    { 0, 4130, 'nintendo.co.kr' },
    { 0, 4130, 'nintendo.tw' },
    { 0, 4130, 'nintendo.co.nz' },
    { 0, 4130, 'nintendo.at' },
    { 0, 4130, 'nintendo.be' },
    { 0, 4130, 'nintendods.cz' },
    { 0, 4130, 'nintendo.dk' },
    { 0, 4130, 'nintendo.de' },
    { 0, 4130, 'nintendo.es' },
    { 0, 4130, 'nintendo.fi' },
    { 0, 4130, 'nintendo.fe' },
    { 0, 4130, 'nintendo.gr' },
    { 0, 4130, 'nintendo.hu' },
    { 0, 4130, 'nintendo.it' },
    { 0, 4130, 'nintendo.nl' },
    { 0, 4130, 'nintendo.no' },
    { 0, 4130, 'nintendo.pl' },
    { 0, 4130, 'nintendo.pt' },
    { 0, 4130, 'nintendo.ru' },
    { 0, 4130, 'nintendo.co.za' },
    { 0, 4130, 'nintendo.se' },
    { 0, 4130, 'nintendo.ch' },
    { 0, 4130, 'nintendo.co.uk' },
    { 0, 4130, 'nintendo-europe.com' },
    -- Zoho SalesIQ Chat
    { 0, 4546, 'salesiq.zoho.com' },
    { 0, 4546, 'salesiq.zohopublic.com' },
    -- Zoho Social
    { 0, 4547, 'social.zoho.com' },
    { 0, 4547, 'social.zohopublic.com' },
    -- Zoho Connect
    { 0, 4548, 'connect.zoho.com' },
    { 0, 4548, 'connect.zohopublic.com' },
    -- Zoho Docs
    { 0, 4549, 'docs.zoho.com' },
    { 0, 4549, 'docs.zohopublic.com' },
    { 0, 4549, 'upload.zoho.com' },
    { 0, 4549, 'apidocs.zoho.com' },
    { 0, 4549, 'drive.zoho.com' },
    -- Zoho Assist
    { 0, 4550, 'assist.zoho.com' },
    { 0, 4546, 'assist.zohopublic.com' },
    { 0, 4550, 'assistus-dal.zoho.com' },
    { 0, 4550, 'gwassistus-dal.zoho.com' },
    { 0, 4550, 'sites.zoho.com' },

}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end
