--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group Full "coldplay"
version: 22
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Hola' => 'An open source VPN.',
          'CCP Games' => 'Video game developer and publisher.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'Yahoo!' => 'Yahoo! and it\'s online services.',
          'Marketo' => 'Ad site.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Myspace Videos' => 'Videos sharing service by Myspace.',
          'Twitter' => 'Social networking and microblogging site.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_full_coldplay",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gSSLHostPatternList = {
	--WeChat
	{ 0, 2618, 'weixin.qq.com' },
	{ 0, 2618, 'qbwup.imtt.qq.com' },
	--Livemeeting (Deprecated)
	--{ 0, 265, 'livemeeting.com' },
	--Sharepoint Online
	{ 0, 2813, 'sharepoint.microsoft.com' },
	{ 0, 2813, 'sharepoint.com' },
	{ 0, 2813, 'sharepointonline.com' },
	{ 0, 2813, 'ajax.aspnetcdn.com' },
	{ 0, 2813, 'spoprod-a.akamaihd.net' },
	{ 0, 2813, 'onenote.com' },
	{ 0, 2813, 'wns.windows.com' },
	{ 0, 2813, 'officeclient.microsoft.com' },
	{ 0, 2813, 'oneclient.sfx.ms' },
	--{ 0, 2813, 'sharepointmktgv6.microsoft.com' },
	--Myspace Videos
	{ 0, 2883, 'a1-videos.myspacecdn.com' },
	{ 0, 2883, 'a2-videos.myspacecdn.com' },
	{ 0, 2883, 'a3-videos.myspacecdn.com' },
	{ 0, 2883, 'a4-videos.myspacecdn.com' },
	{ 0, 2883, 'l-videos.myspacecdn.com' },
	{ 0, 2883, 'l1-videos.myspacecdn.com' },
	{ 0, 2883, 'l2-videos.myspacecdn.com' },
	{ 0, 2883, 'l3-videos.myspacecdn.com' },
	{ 0, 2883, 'l4-videos.myspacecdn.com' },
	--DeNA Comm (Deprecated)
	--{ 0, 2945, 'ssl.co-mm.com' },
	--GG
	{ 0, 3706, 'gadu-gadu.pl' },
	--Marketo
	{ 0, 3940, 'marketo.net' },
	--CCP Games
	{ 0, 4005, 'ccpgamescdn.com' },
	--Hola
	{ 0, 4041, 'www-holanetworksltd.netdna-ssl.com' },
	{ 0, 4041, 'client1-holanetworksltd.netdna-ssl.com' },
	{ 0, 4041, 'client2-holanetworksltd.netdna-ssl.com' },
	{ 0, 4041, 'client3-holanetworksltd.netdna-ssl.com' },
	{ 0, 4041, 'h-cdn.com' },
	{ 0, 4041, 'h-infra.com' },
	{ 0, 4041, 'h-local.org' },
	{ 0, 4041, 'h-vpn.org' },
	{ 0, 4041, 'hola-vpn.com' },
	{ 0, 4041, 'holacdn.com' },
	{ 0, 4041, 'holaspark.com' },
	{ 0, 4041, 'holavpn.net' },
	{ 0, 4041, 'hypernet.net' },
	{ 0, 4041, 'l-cdn.com' },
	{ 0, 4041, 'lum-api.io' },
	{ 0, 4041, 'lum-bext.com' },
	{ 0, 4041, 'lum-cn.co' },
	{ 0, 4041, 'lum-cn.io' },
	{ 0, 4041, 'lum-ext.io' },
	{ 0, 4041, 'lum-infra.com' },
	{ 0, 4041, 'lum-int.io' },
	{ 0, 4041, 'lum-lpm.com' },
	{ 0, 4041, 'lum-sdk.io' },
	{ 0, 4041, 'lum-superproxy.io' },
	{ 0, 4041, 'luminati-china-mail.co' },
	{ 0, 4041, 'luminati-china.biz' },
	{ 0, 4041, 'luminati-china.co' },
	{ 0, 4041, 'luminati-china.io' },
	{ 0, 4041, 'luminati-cn.com' },
	{ 0, 4041, 'luminati-gsuit.org' },
	{ 0, 4041, 'luminati-io-china.com' },
	{ 0, 4041, 'luminati-io-cn.com' },
	{ 0, 4041, 'luminatinet.com' },
	{ 0, 4041, 'lumtest.com' },
	{ 0, 4041, 'scd-cdn.com' },
	{ 0, 4041, 'smv-cdn.com' },
	{ 0, 4041, 'sparkweb.co' },
	{ 0, 4041, 'sparkweb.org' },
	{ 0, 4041, 'svd-cdn.com' },
	{ 0, 4041, 'testmyproxy.com' },
	{ 0, 4041, 'thecodeil.com' },
	{ 0, 4041, 'topvpn.io' },
	{ 0, 4041, 'whatismyippro.com' },
	{ 0, 4041, 'zon-networks.com' },
	--Yahoo!
	{ 0, 524, 'yimg.com' },
	--Citrix Online
	{ 0, 87, 'citrixonline.com' },
	{ 0, 87, 'citrixonlinecdn.com' },
	{ 0, 87, 'expertcity.com' },
	--Twitter
	{ 0, 882, 'ads-twitter.com' },
	{ 0, 882, 'twttr.com' },
}
function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3])
        end
    end
    return gDetector
end

function DetectorClean()
end
