--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group Full "Belvedere"
version: 66
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'AOL' => 'American company develops, grows and invests in brands and web sites.',
          'The Guardian' => 'Online news portal.',
          'Shutterfly' => 'Share, prints and personalize the cards, album, mugs and other Home decor items with your photos.',
          'American Express' => 'Financial services company.',
          'Google Remote Desktop' => 'Online desktop sharing service.',
          'Symantec System Center' => 'Anti-virus software management.',
          'E*TRADE' => 'Financial services company with a focus on online stock brokerage.',
          'PayPal' => 'E-commerce website for handling online transactions.',
          'Google' => 'Traffic generated by the Google search engine or one of the other many Internet services provided by Google Inc.',
          'Citi' => 'Financial services company.',
          'Facebook' => 'Facebook is a social networking service.',
          'Geewa' => 'Browser and Facebook-based gaming.',
          'Gmail' => 'Google online email.',
          'Cisco Secure Endpoint' => 'Cloud-based real time antivirus protection. (AMP for Endpoints).',
          'Snapchat' => 'Online photo sharing.',
          'Spotify' => 'Social Music Player.',
          'Apple Developer' => 'Web portal for Apple Developer.',
          'Discover' => 'Financial services company.',
          'Comcast' => 'Web Portal.',
          'LivingSocial' => 'Deals website.',
          'Akamai' => 'Internet content delivery network and SSL certificate provider.',
          'USPS' => 'US Postal Service website.',
          'Yandex' => 'Russian search engine.',
          'Instagram' => 'Mobile phone photo sharing.',
          'Jingdong (360buy.com)' => 'Chinese e-commerce site.',
          'Square Inc.' => 'Electronic payment service through mobile phones.',
          'Bank of America' => 'Global financial services company.',
          'King.com' => 'Web-based gaming.',
          'BioDigital Human' => 'A web-based medical imaging app.',
          'CSDN' => 'Chinese IT community/forum for Software related issues.',
          'Amazon Web Services' => 'Online cloud computing service.',
          'U.S.Bank' => 'Online banking web portal for U.S Bank.',
          'Siri' => 'Voice interactive agent for Apple\'s iOS.',
          'HSBC' => 'Global banking and financial services company.',
          'iTunes' => 'Apple\'s media player and online store.',
          'Zynga' => 'Social network game developer.',
          'Exchange Online' => 'Traffic associated with Exchange Online, such as visiting outlook.com.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_full_belvedere",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gSSLHostPatternList = {
	--PayPal
	{ 0, 1134, 't.paypal.com' },
	{ 0, 1134, 'www.paypalobjects.com' },
	{ 0, 1134, 'paypal-search.com' },
	{ 0, 1134, 'personal.paypal.com' },
	{ 0, 1134, 'paypal.dl.sc.omtrdc.net' },
	--Spotify
	{ 0, 1158, 'scdn.co' },
	{ 0, 1158, 'spotify.edgekey.net' },
	--Instagram
	{ 1, 1233, 'instagram.fsxr3-1.fna.fbcdn.net' },
	--Car Town (Deprecated)
	--{ 0, 1242, 'secure.cartown.com' },
	--{ 0, 1242, 'cartown.com' },
	--Fruit Ninja Frenzy (Deprecated)
	--{ 0, 1246, 'www.fruitninjafrenzygame.info' },
	--schoolFeed (Deprecated)
	--{ 0, 1249, 'your.schoolfeed.com' },
	--{ 0, 1249, 'schoolfeed.com' },
	--Empires and Allies (Deprecated)
	--{ 0, 1255, 'fb-zc.empire.zynga.com' },
	--{ 0, 1255, 'empire.zynga.com' },
	--Foursquare (Deprecated)
	--{ 0, 1350, 'foursquare.com' },
	--{ 0, 1350, '4sqi.net' },
	--Comcast
	{ 0, 1365, 'comcast.net' },
	--Amazon Web Services
	{ 0, 1392, 's3.amazonaws.com' },
	{ 0, 1392, 'aws.amazon.com' },
	{ 0, 1392, 'images-na.ssl-images-amazon.com' },
	{ 0, 1392, 'awsstatic.com' },
	{ 0, 1392, 'amazonwebservicesinc.tt.omtrdc.net' },
	--AOL
	{ 0, 1419, 'aolcdn.com' },
	{ 0, 1419, 'aol.de' },
	{ 0, 1419, 'aol.fr' },
	{ 0, 1419, 'aol.ca' },
	{ 0, 1419, 'aol.it' },
	{ 0, 1419, 'aol.jp' },
	--LivingSocial
	{ 0, 1495, 'lscdn.net' },
	--U.S.Bank
	{ 0, 1500, 'usbank.com' },
	--Shutterfly
	{ 0, 1543, 'staticsfly.com' },
	--Square Inc.
	{ 0, 1568, 'square.com' },
	--BioDigital Human
	{ 0, 1595, 'biodigital.com' },
	--Apple Developer
	{ 0, 1596, 'devimages.apple.com' },
	{ 0, 1596, 'devimages.apple.com.edgekey.net' },
	--Geewa
	{ 0, 1597, 'geewa-apps.com' },
	{ 0, 1597, 'geewa.com' },
	--King.com
	{ 0, 1599, 'midasplayer.com' },
	{ 0, 1599, 'king.com' },
	--Ubuntu One (Deprecated)
	--{ 0, 1600, 'fs-1.one.ubuntu.com' },
	--{ 0, 1600, 'one.ubuntu.com' },
	--USPS
	{ 0, 1601, 'www.uspspostalone.com' },
	--Siri
	{ 0, 1603, 'daryl.apple.com' },
	{ 0, 1603, 'smoot.apple.com' },
	--Yandex
	{ 0, 1616, 'yandex.kz' },
	{ 0, 1616, 'yandex.ru' },
	{ 0, 1616, 'yandex.st' },
	{ 0, 1616, 'yandex.com' },
	{ 0, 1616, 'yandex.ua' },
	{ 0, 1616, 'yandex.com.tr' },
	--The Guardian
	{ 0, 1618, 'guim.co.uk' },
	--Jingdong (360buy.com)
	{ 0, 1627, 'jd.com' },
	--CSDN
	{ 0, 1646, 'passport.pongo.cn' },
	--Snapchat
	{ 1, 1653, 'feelinsonice-hrd.appspot.com' },
	{ 1, 1653, 'snapchat.com' },
	--Akamai
	{ 0, 1659, 'akamai.net' },
	{ 0, 1659, 'akamai.com' },
	--Google Remote Desktop
	{ 1, 1665, 'chromoting-host.talkgadget.google.com' },
	{ 1, 1665, 'chromoting-client.talkgadget.google.com' },
	{ 1, 1665, 'remoting-pa.googleapis.com' },
	{ 1, 1665, 'talk.google.com' },
	--Google
	{ 0, 184, 'gstatic.com' },
	{ 0, 184, 'google.ac' },
	{ 0, 184, 'google.ad' },
	{ 0, 184, 'google.ae' },
	{ 0, 184, 'google.com.af' },
	{ 0, 184, 'google.com.ag' },
	{ 0, 184, 'google.com.ai' },
	{ 0, 184, 'google.al' },
	{ 0, 184, 'google.am' },
	{ 0, 184, 'google.co.ao' },
	{ 0, 184, 'google.com.ar' },
	{ 0, 184, 'google.as' },
	{ 0, 184, 'google.at' },
	{ 0, 184, 'google.com.au' },
	{ 0, 184, 'google.az' },
	{ 0, 184, 'google.ba' },
	{ 0, 184, 'google.com.bd' },
	{ 0, 184, 'google.be' },
	{ 0, 184, 'google.bf' },
	{ 0, 184, 'google.bg' },
	{ 0, 184, 'google.com.bh' },
	{ 0, 184, 'google.bi' },
	{ 0, 184, 'google.bj' },
	{ 0, 184, 'google.com.bn' },
	{ 0, 184, 'google.com.bo' },
	{ 0, 184, 'google.com.br' },
	{ 0, 184, 'google.bs' },
	{ 0, 184, 'google.bt' },
	{ 0, 184, 'google.co.bw' },
	{ 0, 184, 'google.by' },
	{ 0, 184, 'google.com.bz' },
	{ 0, 184, 'google.ca' },
	{ 0, 184, 'google.com.kh' },
	{ 0, 184, 'google.cc' },
	{ 0, 184, 'google.cd' },
	{ 0, 184, 'google.cf' },
	{ 0, 184, 'google.cat' },
	{ 0, 184, 'google.cg' },
	{ 0, 184, 'google.ch' },
	{ 0, 184, 'google.ci' },
	{ 0, 184, 'google.co.ck' },
	{ 0, 184, 'google.cl' },
	{ 0, 184, 'google.cm' },
	{ 0, 184, 'google.com.co' },
	{ 0, 184, 'google.co.cr' },
	{ 0, 184, 'google.com.cu' },
	{ 0, 184, 'google.cv' },
	{ 0, 184, 'google.com.cy' },
	{ 0, 184, 'google.cz' },
	{ 0, 184, 'google.de' },
	{ 0, 184, 'google.dj' },
	{ 0, 184, 'google.dk' },
	{ 0, 184, 'google.dm' },
	{ 0, 184, 'google.com.do' },
	{ 0, 184, 'google.dz' },
	{ 0, 184, 'google.com.ec' },
	{ 0, 184, 'google.ee' },
	{ 0, 184, 'google.com.eg' },
	{ 0, 184, 'google.es' },
	{ 0, 184, 'google.com.et' },
	{ 0, 184, 'google.fi' },
	{ 0, 184, 'google.com.fj' },
	{ 0, 184, 'google.fm' },
	{ 0, 184, 'google.fr' },
	{ 0, 184, 'google.ga' },
	{ 0, 184, 'google.ge' },
	{ 0, 184, 'google.gg' },
	{ 0, 184, 'google.com.gh' },
	{ 0, 184, 'google.com.gi' },
	{ 0, 184, 'google.gl' },
	{ 0, 184, 'google.gm' },
	{ 0, 184, 'google.gp' },
	{ 0, 184, 'google.gr' },
	{ 0, 184, 'google.com.gt' },
	{ 0, 184, 'google.gy' },
	{ 0, 184, 'google.com.hk' },
	{ 0, 184, 'google.hn' },
	{ 0, 184, 'google.hr' },
	{ 0, 184, 'google.ht' },
	{ 0, 184, 'google.hu' },
	{ 0, 184, 'google.co.id' },
	{ 0, 184, 'google.iq' },
	{ 0, 184, 'google.ie' },
	{ 0, 184, 'google.co.il' },
	{ 0, 184, 'google.im' },
	{ 0, 184, 'google.co.in' },
	{ 0, 184, 'google.is' },
	{ 0, 184, 'google.it' },
	{ 0, 184, 'google.je' },
	{ 0, 184, 'google.com.jm' },
	{ 0, 184, 'google.jo' },
	{ 0, 184, 'google.co.jp' },
	{ 0, 184, 'google.co.ke' },
	{ 0, 184, 'google.ki' },
	{ 0, 184, 'google.kg' },
	{ 0, 184, 'google.co.kr' },
	{ 0, 184, 'google.com.kw' },
	{ 0, 184, 'google.kz' },
	{ 0, 184, 'google.la' },
	{ 0, 184, 'google.com.lb' },
	{ 0, 184, 'google.li' },
	{ 0, 184, 'google.lk' },
	{ 0, 184, 'google.co.ls' },
	{ 0, 184, 'google.lt' },
	{ 0, 184, 'google.lu' },
	{ 0, 184, 'google.lv' },
	{ 0, 184, 'google.com.ly' },
	{ 0, 184, 'google.co.ma' },
	{ 0, 184, 'google.md' },
	{ 0, 184, 'google.me' },
	{ 0, 184, 'google.mg' },
	{ 0, 184, 'google.mk' },
	{ 0, 184, 'google.ml' },
	{ 0, 184, 'google.com.mm' },
	{ 0, 184, 'google.mn' },
	{ 0, 184, 'google.ms' },
	{ 0, 184, 'google.com.mt' },
	{ 0, 184, 'google.mu' },
	{ 0, 184, 'google.mv' },
	{ 0, 184, 'google.mw' },
	{ 0, 184, 'google.com.mx' },
	{ 0, 184, 'google.com.my' },
	{ 0, 184, 'google.co.mz' },
	{ 0, 184, 'google.com.na' },
	{ 0, 184, 'google.ne' },
	{ 0, 184, 'google.com.nf' },
	{ 0, 184, 'google.com.ng' },
	{ 0, 184, 'google.com.ni' },
	{ 0, 184, 'google.nl' },
	{ 0, 184, 'google.no' },
	{ 0, 184, 'google.com.np' },
	{ 0, 184, 'google.nr' },
	{ 0, 184, 'google.nu' },
	{ 0, 184, 'google.co.nz' },
	{ 0, 184, 'google.com.om' },
	{ 0, 184, 'google.com.pk' },
	{ 0, 184, 'google.com.pa' },
	{ 0, 184, 'google.com.pe' },
	{ 0, 184, 'google.com.ph' },
	{ 0, 184, 'google.pl' },
	{ 0, 184, 'google.com.pg' },
	{ 0, 184, 'google.pn' },
	{ 0, 184, 'google.com.pr' },
	{ 0, 184, 'google.ps' },
	{ 0, 184, 'google.pt' },
	{ 0, 184, 'google.com.py' },
	{ 0, 184, 'google.com.qa' },
	{ 0, 184, 'google.ro' },
	{ 0, 184, 'google.rs' },
	{ 0, 184, 'google.ru' },
	{ 0, 184, 'google.rw' },
	{ 0, 184, 'google.com.sa' },
	{ 0, 184, 'google.com.sb' },
	{ 0, 184, 'google.sc' },
	{ 0, 184, 'google.se' },
	{ 0, 184, 'google.com.sg' },
	{ 0, 184, 'google.sh' },
	{ 0, 184, 'google.si' },
	{ 0, 184, 'google.sk' },
	{ 0, 184, 'google.com.sl' },
	{ 0, 184, 'google.sn' },
	{ 0, 184, 'google.sm' },
	{ 0, 184, 'google.so' },
	{ 0, 184, 'google.st' },
	{ 0, 184, 'google.sr' },
	{ 0, 184, 'google.com.sv' },
	{ 0, 184, 'google.td' },
	{ 0, 184, 'google.tg' },
	{ 0, 184, 'google.co.th' },
	{ 0, 184, 'google.com.tj' },
	{ 0, 184, 'google.tk' },
	{ 0, 184, 'google.tl' },
	{ 0, 184, 'google.tm' },
	{ 0, 184, 'google.to' },
	{ 0, 184, 'google.tn' },
	{ 0, 184, 'google.com.tr' },
	{ 0, 184, 'google.tt' },
	{ 0, 184, 'google.com.tw' },
	{ 0, 184, 'google.co.tz' },
	{ 0, 184, 'google.com.ua' },
	{ 0, 184, 'google.co.ug' },
	{ 0, 184, 'google.co.uk' },
	{ 0, 184, 'google.com.uy' },
	{ 0, 184, 'google.co.uz' },
	{ 0, 184, 'google.com.vc' },
	{ 0, 184, 'google.co.ve' },
	{ 0, 184, 'google.vg' },
	{ 0, 184, 'google.co.vi' },
	{ 0, 184, 'google.com.vn' },
	{ 0, 184, 'google.vu' },
	{ 0, 184, 'google.ws' },
	{ 0, 184, 'google.co.za' },
	{ 0, 184, 'google.co.zm' },
	{ 0, 184, 'google.co.zw' },
	{ 0, 184, 'google.net' },
	{ 0, 184, 'about.google' },
	{ 0, 184, 'blog.google' },
	{ 0, 184, 'registry.google' },
	{ 0, 184, 'nic.google' },
	{ 0, 184, 'ai.google' },
	{ 0, 184, 'design.google' },
	{ 0, 184, 'environment.google' },
	{ 0, 184, 'pride.google' },
	{ 0, 184, 'health.google' },
	{ 0, 184, 'research.google' },
	{ 0, 184, 'crisisresponse.google' },
	{ 0, 184, 'grow.google' },
	{ 0, 184, 'diversity.google' },
	{ 0, 184, 'safety.google' },
	{ 0, 184, 'chromeenterprise.google' },
	{ 0, 184, 'teachfromanywhere.google' },
	{ 0, 184, 'teachfromhome.google' },
	{ 0, 184, 'domains.google' },
	{ 0, 184, 'opensource.google' },
	{ 0, 184, 'wellbeing.google' },
	{ 0, 184, 'sustainability.google' },
	{ 0, 184, 'covid19.google' },
	{ 0, 184, 'ggpht.com' },
	{ 0, 184, 'googleusercontent.com' },
	--Exchange Online
	{ 0, 2810, 'outlook.com' },
	{ 0, 2810, 'Outlook.com' },
	{ 0, 2810, 'pop3.live.com' },
	{ 0, 2810, 'outlook.office.com' },
	{ 0, 2810, 'r1.res.office365.com' },
	{ 0, 2810, 'r3.res.office365.com' },
	{ 0, 2810, 'r4.res.office365.com' },
	{ 0, 2810, 'hybridconfiguration.azurewebsites.net' },
	{ 0, 2810, 'outlook.office365.com' },
	{ 0, 2810, 'smtp.office365.com' },
	{ 0, 2810, 'domains.live.com' },
	{ 0, 2810, 'protection.outlook.com' },
	{ 0, 2810, 'attachments.office.net' },
	--Symantec System Center
	{ 0, 459, 'symanteccloud.com' },
	{ 0, 459, 'symantec.tt.omtrdc.net' },
	--Zynga
	{ 0, 533, 'zynga.com' },
	{ 0, 533, 'zynga1-a.akamaihd.net' },
	{ 0, 533, 'zynga2-a.akamaihd.net' },
	--American Express
	{ 0, 544, 'americanexpress.com' },
	--Bank of America
	{ 0, 560, 'bankofamerica.tt.omtrdc.net' },
	{ 0, 560, 'bac-assets.com' },
	--Citi
	{ 0, 590, 'citi.bridgetrack.com' },
	{ 0, 590, 'citi.com' },
	{ 0, 590, 'citicorpcreditservic.tt.omtrdc.net' },
	--Discover
	{ 0, 615, 'discovercard.com' },
	{ 0, 615, 'discover.tt.omtrdc.net' },
	--E*TRADE
	{ 0, 621, 'etrade.net' },
	{ 0, 621, 'etradefinancial.tt.omtrdc.net' },
	{ 0, 621, 'etrade.wsod.com' },
	{ 0, 621, 'etrade.122.2o7.net' },
	--Facebook
	{ 0, 629, 'fbcdn-photos-e-a.akamaihd.net' },
	{ 0, 629, 'fbcdn-photos-b-a.akamaihd.net' },
	{ 0, 629, 'facebook.com' },
	{ 0, 629, 'fbstatic-a.akamaihd.net' },
	{ 0, 629, 'fbexternal-a.akamaihd.net' },
	{ 0, 629, 'fbcdn-profile-a.akamaihd.net' },
	{ 0, 629, 'fbcdn-creative-a.akamaihd.net' },
	{ 0, 629, 'fbcdn-dragon-a.akamaihd.net' },
	{ 0, 629, 'contentcache-a.akamaihd.net' },
	{ 0, 629, 'facebook.net' },
	{ 0, 629, 'fbcdn.net' },
	--{ 0, 629, 'fbcdn-video-a.akamaihd.net' },
	--{ 0, 629, 'fbcdn-sphotos-e-a.akamaihd.net' },
	--{ 0, 629, 'fbcdn-sphotos-b-a.akamaihd.net' },
	--{ 0, 629, 'fbcdn-sphotos-f-a.akamaihd.net' },
	--Gmail
	{ 0, 655, 'gmail.com' },
	--HSBC
	{ 0, 675, 'member-hsbc-group.com' },
	--iTunes
	{ 0, 689, 'itunes.apple.com' },
	--Cisco Secure Endpoint
	{ 1, 934, 'amp.sourcefire.com' },
	--{ 0, 934, 'immunet.com' },
}
function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3])
        end
    end
    return gDetector
end

function DetectorClean()
end
