--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group Full "366"
version: 1
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'iCloud Mail' => 'iCloud Mail is an online email service included in Apple iCloud product.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_full_366",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- iCloud Mail
    {0, 7363, 'p02-mccgateway.icloud.com'},
    {0, 7363, 'p03-mccgateway.icloud.com'},
    {0, 7363, 'p04-mccgateway.icloud.com'},
    {0, 7363, 'p05-mccgateway.icloud.com'},
    {0, 7363, 'p06-mccgateway.icloud.com'},
    {0, 7363, 'p07-mccgateway.icloud.com'},
    {0, 7363, 'p08-mccgateway.icloud.com'},
    {0, 7363, 'p09-mccgateway.icloud.com'},
    {0, 7363, 'p10-mccgateway.icloud.com'},
    {0, 7363, 'p11-mccgateway.icloud.com'},
    {0, 7363, 'p12-mccgateway.icloud.com'},
    {0, 7363, 'p13-mccgateway.icloud.com'},
    {0, 7363, 'p14-mccgateway.icloud.com'},
    {0, 7363, 'p15-mccgateway.icloud.com'},
    {0, 7363, 'p16-mccgateway.icloud.com'},
    {0, 7363, 'p17-mccgateway.icloud.com'},
    {0, 7363, 'p18-mccgateway.icloud.com'},
    {0, 7363, 'p19-mccgateway.icloud.com'},
    {0, 7363, 'p20-mccgateway.icloud.com'},
    {0, 7363, 'p21-mccgateway.icloud.com'},
    {0, 7363, 'p22-mccgateway.icloud.com'},
    {0, 7363, 'p23-mccgateway.icloud.com'},
    {0, 7363, 'p24-mccgateway.icloud.com'},
    {0, 7363, 'p25-mccgateway.icloud.com'},
    {0, 7363, 'p26-mccgateway.icloud.com'},
    {0, 7363, 'p27-mccgateway.icloud.com'},
    {0, 7363, 'p28-mccgateway.icloud.com'},
    {0, 7363, 'p29-mccgateway.icloud.com'},
    {0, 7363, 'p30-mccgateway.icloud.com'},
    {0, 7363, 'p31-mccgateway.icloud.com'},
    {0, 7363, 'p32-mccgateway.icloud.com'},
    {0, 7363, 'p33-mccgateway.icloud.com'},
    {0, 7363, 'p34-mccgateway.icloud.com'},
    {0, 7363, 'p35-mccgateway.icloud.com'},
    {0, 7363, 'p36-mccgateway.icloud.com'},
    {0, 7363, 'p37-mccgateway.icloud.com'},
    {0, 7363, 'p38-mccgateway.icloud.com'},
    {0, 7363, 'p39-mccgateway.icloud.com'},
    {0, 7363, 'p40-mccgateway.icloud.com'},
    {0, 7363, 'p41-mccgateway.icloud.com'},
    {0, 7363, 'p42-mccgateway.icloud.com'},
    {0, 7363, 'p43-mccgateway.icloud.com'},
    {0, 7363, 'p44-mccgateway.icloud.com'},
    {0, 7363, 'p45-mccgateway.icloud.com'},
    {0, 7363, 'p46-mccgateway.icloud.com'},
    {0, 7363, 'p47-mccgateway.icloud.com'},
    {0, 7363, 'p48-mccgateway.icloud.com'},
    {0, 7363, 'p49-mccgateway.icloud.com'},
    {0, 7363, 'p50-mccgateway.icloud.com'},
    {0, 7363, 'p51-mccgateway.icloud.com'},
    {0, 7363, 'p52-mccgateway.icloud.com'},
    {0, 7363, 'p53-mccgateway.icloud.com'},
    {0, 7363, 'p54-mccgateway.icloud.com'},
    {0, 7363, 'p55-mccgateway.icloud.com'},
    {0, 7363, 'p56-mccgateway.icloud.com'},
    {0, 7363, 'p57-mccgateway.icloud.com'},
    {0, 7363, 'p58-mccgateway.icloud.com'},
    {0, 7363, 'p59-mccgateway.icloud.com'},
    {0, 7363, 'p60-mccgateway.icloud.com'},
    {0, 7363, 'p61-mccgateway.icloud.com'},
    {0, 7363, 'p62-mccgateway.icloud.com'},
    {0, 7363, 'p63-mccgateway.icloud.com'},
    {0, 7363, 'p64-mccgateway.icloud.com'},
    {0, 7363, 'p65-mccgateway.icloud.com'},
    {0, 7363, 'p66-mccgateway.icloud.com'},
    {0, 7363, 'p67-mccgateway.icloud.com'},
    {0, 7363, 'p68-mccgateway.icloud.com'},
    {0, 7363, 'p69-mccgateway.icloud.com'},
    {0, 7363, 'p70-mccgateway.icloud.com'},
    {0, 7363, 'p71-mccgateway.icloud.com'},
    {0, 7363, 'p72-mccgateway.icloud.com'},
    {0, 7363, 'p73-mccgateway.icloud.com'},
    {0, 7363, 'p74-mccgateway.icloud.com'},
    {0, 7363, 'p75-mccgateway.icloud.com'},
    {0, 7363, 'p76-mccgateway.icloud.com'},
    {0, 7363, 'p77-mccgateway.icloud.com'},
    {0, 7363, 'p78-mccgateway.icloud.com'},
    {0, 7363, 'p79-mccgateway.icloud.com'},
    {0, 7363, 'p80-mccgateway.icloud.com'},
    {0, 7363, 'p81-mccgateway.icloud.com'},
    {0, 7363, 'p82-mccgateway.icloud.com'},
    {0, 7363, 'p83-mccgateway.icloud.com'},
    {0, 7363, 'p84-mccgateway.icloud.com'},
    {0, 7363, 'p85-mccgateway.icloud.com'},
    {0, 7363, 'p86-mccgateway.icloud.com'},
    {0, 7363, 'p87-mccgateway.icloud.com'},
    {0, 7363, 'p88-mccgateway.icloud.com'},
    {0, 7363, 'p89-mccgateway.icloud.com'},
    {0, 7363, 'p90-mccgateway.icloud.com'},
    {0, 7363, 'p91-mccgateway.icloud.com'},
    {0, 7363, 'p92-mccgateway.icloud.com'},
    {0, 7363, 'p93-mccgateway.icloud.com'},
    {0, 7363, 'p94-mccgateway.icloud.com'},
    {0, 7363, 'p95-mccgateway.icloud.com'},
    {0, 7363, 'p96-mccgateway.icloud.com'},
    {0, 7363, 'p97-mccgateway.icloud.com'},
    {0, 7363, 'p98-mccgateway.icloud.com'},
    {0, 7363, 'p99-mccgateway.icloud.com'},
    {0, 7363, 'p100-mccgateway.icloud.com'},
    {0, 7363, 'p101-mccgateway.icloud.com'},
    {0, 7363, 'p102-mccgateway.icloud.com'},
    {0, 7363, 'p103-mccgateway.icloud.com'},
    {0, 7363, 'p104-mccgateway.icloud.com'},
    {0, 7363, 'p105-mccgateway.icloud.com'},
    {0, 7363, 'p106-mccgateway.icloud.com'},
    {0, 7363, 'p107-mccgateway.icloud.com'},
    {0, 7363, 'p108-mccgateway.icloud.com'},
    {0, 7363, 'p109-mccgateway.icloud.com'},
    {0, 7363, 'p110-mccgateway.icloud.com'},
    {0, 7363, 'p111-mccgateway.icloud.com'},
    {0, 7363, 'p112-mccgateway.icloud.com'},
    {0, 7363, 'p113-mccgateway.icloud.com'},
    {0, 7363, 'p114-mccgateway.icloud.com'},
    {0, 7363, 'p115-mccgateway.icloud.com'},
    {0, 7363, 'p116-mccgateway.icloud.com'},
    {0, 7363, 'p117-mccgateway.icloud.com'},
    {0, 7363, 'p118-mccgateway.icloud.com'},
    {0, 7363, 'p119-mccgateway.icloud.com'},
    {0, 7363, 'p120-mccgateway.icloud.com'},
    {0, 7363, 'p121-mccgateway.icloud.com'},
    {0, 7363, 'p122-mccgateway.icloud.com'},
    {0, 7363, 'p123-mccgateway.icloud.com'},
    {0, 7363, 'p124-mccgateway.icloud.com'},
    {0, 7363, 'p125-mccgateway.icloud.com'},
    {0, 7363, 'p126-mccgateway.icloud.com'},
    {0, 7363, 'p127-mccgateway.icloud.com'},
    {0, 7363, 'p128-mccgateway.icloud.com'},
    {0, 7363, 'p129-mccgateway.icloud.com'},
    {0, 7363, 'p130-mccgateway.icloud.com'},
    {0, 7363, 'p131-mccgateway.icloud.com'},
    {0, 7363, 'p132-mccgateway.icloud.com'},
    {0, 7363, 'p133-mccgateway.icloud.com'},
    {0, 7363, 'p134-mccgateway.icloud.com'},
    {0, 7363, 'p135-mccgateway.icloud.com'},
    {0, 7363, 'p136-mccgateway.icloud.com'},
    {0, 7363, 'p137-mccgateway.icloud.com'},
    {0, 7363, 'p138-mccgateway.icloud.com'},
    {0, 7363, 'p139-mccgateway.icloud.com'},
    {0, 7363, 'p140-mccgateway.icloud.com'},
    {0, 7363, 'p141-mccgateway.icloud.com'},
    {0, 7363, 'p142-mccgateway.icloud.com'},
    {0, 7363, 'p143-mccgateway.icloud.com'},
    {0, 7363, 'p144-mccgateway.icloud.com'},
    {0, 7363, 'p145-mccgateway.icloud.com'},
    {0, 7363, 'p146-mccgateway.icloud.com'},
    {0, 7363, 'p147-mccgateway.icloud.com'},
    {0, 7363, 'p148-mccgateway.icloud.com'},
    {0, 7363, 'p149-mccgateway.icloud.com'},
    {0, 7363, 'p150-mccgateway.icloud.com'},
    {0, 7363, 'p01-mcc.icloud.com'},
    {0, 7363, 'p02-mcc.icloud.com'},
    {0, 7363, 'p03-mcc.icloud.com'},
    {0, 7363, 'p04-mcc.icloud.com'},
    {0, 7363, 'p05-mcc.icloud.com'},
    {0, 7363, 'p06-mcc.icloud.com'},
    {0, 7363, 'p07-mcc.icloud.com'},
    {0, 7363, 'p08-mcc.icloud.com'},
    {0, 7363, 'p09-mcc.icloud.com'},
    {0, 7363, 'p10-mcc.icloud.com'},
    {0, 7363, 'p11-mcc.icloud.com'},
    {0, 7363, 'p12-mcc.icloud.com'},
    {0, 7363, 'p13-mcc.icloud.com'},
    {0, 7363, 'p14-mcc.icloud.com'},
    {0, 7363, 'p15-mcc.icloud.com'},
    {0, 7363, 'p16-mcc.icloud.com'},
    {0, 7363, 'p17-mcc.icloud.com'},
    {0, 7363, 'p18-mcc.icloud.com'},
    {0, 7363, 'p19-mcc.icloud.com'},
    {0, 7363, 'p20-mcc.icloud.com'},
    {0, 7363, 'p21-mcc.icloud.com'},
    {0, 7363, 'p22-mcc.icloud.com'},
    {0, 7363, 'p23-mcc.icloud.com'},
    {0, 7363, 'p24-mcc.icloud.com'},
    {0, 7363, 'p25-mcc.icloud.com'},
    {0, 7363, 'p26-mcc.icloud.com'},
    {0, 7363, 'p27-mcc.icloud.com'},
    {0, 7363, 'p28-mcc.icloud.com'},
    {0, 7363, 'p29-mcc.icloud.com'},
    {0, 7363, 'p30-mcc.icloud.com'},
    {0, 7363, 'p31-mcc.icloud.com'},
    {0, 7363, 'p32-mcc.icloud.com'},
    {0, 7363, 'p33-mcc.icloud.com'},
    {0, 7363, 'p34-mcc.icloud.com'},
    {0, 7363, 'p35-mcc.icloud.com'},
    {0, 7363, 'p36-mcc.icloud.com'},
    {0, 7363, 'p37-mcc.icloud.com'},
    {0, 7363, 'p38-mcc.icloud.com'},
    {0, 7363, 'p39-mcc.icloud.com'},
    {0, 7363, 'p40-mcc.icloud.com'},
    {0, 7363, 'p41-mcc.icloud.com'},
    {0, 7363, 'p42-mcc.icloud.com'},
    {0, 7363, 'p43-mcc.icloud.com'},
    {0, 7363, 'p44-mcc.icloud.com'},
    {0, 7363, 'p45-mcc.icloud.com'},
    {0, 7363, 'p46-mcc.icloud.com'},
    {0, 7363, 'p47-mcc.icloud.com'},
    {0, 7363, 'p48-mcc.icloud.com'},
    {0, 7363, 'p49-mcc.icloud.com'},
    {0, 7363, 'p50-mcc.icloud.com'},
    {0, 7363, 'p51-mcc.icloud.com'},
    {0, 7363, 'p52-mcc.icloud.com'},
    {0, 7363, 'p53-mcc.icloud.com'},
    {0, 7363, 'p54-mcc.icloud.com'},
    {0, 7363, 'p55-mcc.icloud.com'},
    {0, 7363, 'p56-mcc.icloud.com'},
    {0, 7363, 'p57-mcc.icloud.com'},
    {0, 7363, 'p58-mcc.icloud.com'},
    {0, 7363, 'p59-mcc.icloud.com'},
    {0, 7363, 'p60-mcc.icloud.com'},
    {0, 7363, 'p61-mcc.icloud.com'},
    {0, 7363, 'p62-mcc.icloud.com'},
    {0, 7363, 'p63-mcc.icloud.com'},
    {0, 7363, 'p64-mcc.icloud.com'},
    {0, 7363, 'p65-mcc.icloud.com'},
    {0, 7363, 'p66-mcc.icloud.com'},
    {0, 7363, 'p67-mcc.icloud.com'},
    {0, 7363, 'p68-mcc.icloud.com'},
    {0, 7363, 'p69-mcc.icloud.com'},
    {0, 7363, 'p70-mcc.icloud.com'},
    {0, 7363, 'p71-mcc.icloud.com'},
    {0, 7363, 'p72-mcc.icloud.com'},
    {0, 7363, 'p73-mcc.icloud.com'},
    {0, 7363, 'p74-mcc.icloud.com'},
    {0, 7363, 'p75-mcc.icloud.com'},
    {0, 7363, 'p76-mcc.icloud.com'},
    {0, 7363, 'p77-mcc.icloud.com'},
    {0, 7363, 'p78-mcc.icloud.com'},
    {0, 7363, 'p79-mcc.icloud.com'},
    {0, 7363, 'p80-mcc.icloud.com'},
    {0, 7363, 'p81-mcc.icloud.com'},
    {0, 7363, 'p82-mcc.icloud.com'},
    {0, 7363, 'p83-mcc.icloud.com'},
    {0, 7363, 'p84-mcc.icloud.com'},
    {0, 7363, 'p85-mcc.icloud.com'},
    {0, 7363, 'p86-mcc.icloud.com'},
    {0, 7363, 'p87-mcc.icloud.com'},
    {0, 7363, 'p88-mcc.icloud.com'},
    {0, 7363, 'p89-mcc.icloud.com'},
    {0, 7363, 'p90-mcc.icloud.com'},
    {0, 7363, 'p91-mcc.icloud.com'},
    {0, 7363, 'p92-mcc.icloud.com'},
    {0, 7363, 'p93-mcc.icloud.com'},
    {0, 7363, 'p94-mcc.icloud.com'},
    {0, 7363, 'p95-mcc.icloud.com'},
    {0, 7363, 'p96-mcc.icloud.com'},
    {0, 7363, 'p97-mcc.icloud.com'},
    {0, 7363, 'p98-mcc.icloud.com'},
    {0, 7363, 'p99-mcc.icloud.com'},
    {0, 7363, 'p100-mcc.icloud.com'},
    {0, 7363, 'p101-mcc.icloud.com'},
    {0, 7363, 'p102-mcc.icloud.com'},
    {0, 7363, 'p103-mcc.icloud.com'},
    {0, 7363, 'p104-mcc.icloud.com'},
    {0, 7363, 'p105-mcc.icloud.com'},
    {0, 7363, 'p106-mcc.icloud.com'},
    {0, 7363, 'p107-mcc.icloud.com'},
    {0, 7363, 'p108-mcc.icloud.com'},
    {0, 7363, 'p109-mcc.icloud.com'},
    {0, 7363, 'p110-mcc.icloud.com'},
    {0, 7363, 'p111-mcc.icloud.com'},
    {0, 7363, 'p112-mcc.icloud.com'},
    {0, 7363, 'p113-mcc.icloud.com'},
    {0, 7363, 'p114-mcc.icloud.com'},
    {0, 7363, 'p115-mcc.icloud.com'},
    {0, 7363, 'p116-mcc.icloud.com'},
    {0, 7363, 'p117-mcc.icloud.com'},
    {0, 7363, 'p118-mcc.icloud.com'},
    {0, 7363, 'p119-mcc.icloud.com'},
    {0, 7363, 'p120-mcc.icloud.com'},
    {0, 7363, 'p121-mcc.icloud.com'},
    {0, 7363, 'p122-mcc.icloud.com'},
    {0, 7363, 'p123-mcc.icloud.com'},
    {0, 7363, 'p124-mcc.icloud.com'},
    {0, 7363, 'p125-mcc.icloud.com'},
    {0, 7363, 'p126-mcc.icloud.com'},
    {0, 7363, 'p127-mcc.icloud.com'},
    {0, 7363, 'p128-mcc.icloud.com'},
    {0, 7363, 'p129-mcc.icloud.com'},
    {0, 7363, 'p130-mcc.icloud.com'},
    {0, 7363, 'p131-mcc.icloud.com'},
    {0, 7363, 'p132-mcc.icloud.com'},
    {0, 7363, 'p133-mcc.icloud.com'},
    {0, 7363, 'p134-mcc.icloud.com'},
    {0, 7363, 'p135-mcc.icloud.com'},
    {0, 7363, 'p136-mcc.icloud.com'},
    {0, 7363, 'p137-mcc.icloud.com'},
    {0, 7363, 'p138-mcc.icloud.com'},
    {0, 7363, 'p139-mcc.icloud.com'},
    {0, 7363, 'p140-mcc.icloud.com'},
    {0, 7363, 'p141-mcc.icloud.com'},
    {0, 7363, 'p142-mcc.icloud.com'},
    {0, 7363, 'p143-mcc.icloud.com'},
    {0, 7363, 'p144-mcc.icloud.com'},
    {0, 7363, 'p145-mcc.icloud.com'},
    {0, 7363, 'p146-mcc.icloud.com'},
    {0, 7363, 'p147-mcc.icloud.com'},
    {0, 7363, 'p148-mcc.icloud.com'},
    {0, 7363, 'p149-mcc.icloud.com'},
    {0, 7363, 'p150-mcc.icloud.com'},
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end
    gSSLHostPatternList = nil

    return gDetector;
end

function DetectorClean()
end
