--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group Full "1ders"
version: 51
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Google Hangouts' => 'Google cross-platform messenger application.',
          'Hotspot Shield' => 'Anonymizer and tunnel that encrypts communications.',
          'Engage BDR' => 'Advertisement site.',
          'Narratiive' => 'Advertisement site.',
          'Lokalisten' => 'German social network site focused on local events.',
          'Adtech' => 'Advertisement site.',
          'Adenin' => 'A web portal.',
          'Apple Store' => 'Official online retailer of Apple products.',
          'eBay' => 'An online auction and shopping website.',
          'MaxPoint Interactive' => 'Advertisement site.',
          'Naverisk' => 'Cloud-based remote monitoring and management software.',
          'Hideman Login' => 'Logging into Hideman internet anonymizer.',
          'Neustar Information Services' => 'Advertisement site.',
          'NBA' => 'Official website for the National Basketball League, an American sports organization.',
          'SlideShare' => 'A web-based slide show service.',
          'Delicious' => 'Social bookmarking website for storing, sharing, and finding web bookmarks.',
          'Mozilla' => 'Website for many open source software projects, including the Firefox browser.',
          'LINE' => 'Mobile and Desktop App for Instant Messaging.',
          'MediaV' => 'Advertisement site.',
          'Marca' => 'Primarily Spanish video streaming site.',
          'Microsoft Ads' => 'Web advertisement services.',
          'Salesforce.com' => 'Enterprise cloud computing company.',
          'iCloud' => 'Apple cloud storage service.',
          'EQ Ads' => 'Advertisement site.',
          'ImageShack' => 'Image hosting website.',
          'DeNA websites' => 'Traffic generated by browsing DeNA Comm website and some other sites that belong to DeNA.',
          'Sourceforge' => 'Site for sharing open source software projects.',
          'TechInline' => 'Website that offers remote desktop control.',
          'Six Apart' => 'Advertisement site.',
          'TowerData' => 'Formerly RapLeaf, an advertisement site.',
          'contnet' => 'Advertisement site.',
          'HP Home & Home Office Store' => 'HP\'s online store for computers and related products.',
          'Improve Digital' => 'European sell side online ad service.',
          'Motley Fool' => 'Financial and Investment community.',
          'Sears' => 'Department store retailer.',
          'RhythmOne' => 'Advertisement site.',
          'Online File Folder' => 'Cloud-based file storage.',
          'Samsung' => 'Electronics retail site.',
          'LogMeIn' => 'Remote access and PC desktop control.',
          'Mercado Livre' => 'Brazil online auction and shopping website.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_full_1ders",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gSSLHostPatternList = {
	--Hotspot Shield
	{ 0, 1140, 'esellerate.net' },
	{ 0, 1140, 'hsselite.com' },
	{ 0, 1140, 'hsselite.zendesk.com' },
	{ 0, 1140, 'anchorfree.us' },
	{ 0, 1140, 'anchorfree.net' },
	{ 0, 1140, 'anchorfree.com' },
	{ 0, 1140, 'hotspotshield.s3.amazonaws.com' },
	{ 0, 1140, 'a433.com' },
	{ 0, 1140, 'event.shelljacket.us' },
	--SlideShare
	{ 0, 1176, 'slideshare.net' },
	--Sourceforge
	{ 0, 1177, 'sf.net' },
	--iCloud
	{ 0, 1187, 'me.com' },
	{ 0, 1187, 'icloud-content.com' },
	{ 0, 1187, 'icloud.cdn-apple.com' },
	--Online File Folder
	{ 0, 1223, 'login.secureserver.net' },
	--Mozilla
	{ 0, 1261, 'mozilla.com' },
	--eBay
	{ 0, 132, 'ebay.co.uk' },
	{ 0, 132, 'ebay.ca' },
	{ 0, 132, 'ebay.com.au' },
	{ 0, 132, 'ebay.ie' },
	{ 0, 132, 'ebay.de' },
	{ 0, 132, 'ebay.in' },
	{ 0, 132, 'ebay.fr' },
	{ 0, 132, 'ebay.es' },
	{ 0, 132, 'ebay.it' },
	{ 0, 132, 'ebay.at' },
	{ 0, 132, 'ebay.be' },
	{ 0, 132, 'ebay.nl' },
	{ 0, 132, 'ebay.ch' },
	{ 0, 132, 'ebay.pl' },
	{ 0, 132, 'ebay.com.sg' },
	{ 0, 132, 'ebay.com.cn' },
	{ 0, 132, 'ebay.cn' },
	{ 0, 132, 'ebay.com.tw' },
	{ 0, 132, 'ebay.com.hk' },
	{ 0, 132, 'ebay.co.jp' },
	{ 0, 132, 'ebay.co.kr' },
	{ 0, 132, 'ebay.ph' },
	{ 0, 132, 'ebay.com.my' },
	{ 0, 132, 'ebay.vn' },
	{ 0, 132, 'ebay.co.th' },
	--Microsoft Ads
	{ 0, 1336, 'bingads.microsoft.com' },
	--Samsung
	{ 0, 1357, 'samsungapps.com' },
	--LINE
	{ 1, 1667, 'line-apps.com' },
	{ 1, 1667, 'line-scdn.net' },
	{ 1, 1667, 'line.naver.jp' },
	--NBA
	{ 0, 1939, 'nba.co.in' },
	{ 0, 1939, 'nba.ca' },
	--TechInline
	{ 0, 2351, 'fixme.it' },
	--Adenin
	{ 0, 2360, 'dynamicintranet.com' },
	--MUZU TV (Deprecated)
	--{ 0, 2375, 'muzu.tv' },
	--Naverisk
	{ 0, 2390, 'naveriskusa.com' },
	--Improve Digital
	{ 0, 2451, '360yield.com' },
	--Krux
	--{ 0, 2466, 'kruxdigital.com' },
	--Marca
	{ 0, 2486, 'marca.es' },
	--MediaV
	{ 0, 2501, 'mediav.cn' },
	{ 0, 2501, 'fenxi.com' },
	--Adtech
	{ 0, 2503, 'adtechaustralia.com' },
	{ 0, 2503, 'adtech-kyushu.com' },
	{ 0, 2503, 'ad-techlondon.co.uk' },
	{ 0, 2503, 'ad-tech.sg' },
	{ 0, 2503, 'adtechasean.com' },
	{ 0, 2503, 'ad-tech.co.nz' },
	--Narratiive
	{ 0, 2516, 'effectivemeasure.com' },
	--LiveRail (Deprecated)
	--{ 0, 2520, 'liverail.com' },
	--Neustar Information Services
	{ 0, 2537, 'neustar.biz' },
	{ 0, 2537, 'neustarlife.com' },
	{ 0, 2537, 'targusinfo.com' },
	{ 0, 2537, 'neustarlocaleze.biz' },
	{ 0, 2537, 'neustarlocaleze.com' },
	{ 0, 2537, 'ultradns.com' },
	{ 0, 2537, 'webmetrics.com' },
	{ 0, 2537, 'tcpacompliance.us' },
	{ 0, 2537, 'npac.com' },
	--EQ Ads
	{ 0, 2539, 'eqads.com' },
	{ 0, 2539, 'eqworks.com' },
	--TowerData
	{ 0, 2540, 'towerdata.com' },
	--Engage BDR
	{ 0, 2554, 'bnmla.com' },
	{ 0, 2554, 'first-impression.com' },
	--Six Apart
	{ 0, 2560, 'sixapart.jp' },
	{ 0, 2560, 'movabletype.com' },
	--MaxPoint Interactive
	{ 0, 2561, 'maxpointexpress.com' },
	--RhythmOne
	{ 0, 2564, 'radiumone.com' },
	--contnet
	{ 0, 2566, 'contnet.de' },
	--Telemetry (Deprecated)
	--{ 0, 2596, 'telemetry.com' },
	--Hideman Login
	{ 0, 2681, 'hideman.net' },
	--LogMeIn
	{ 0, 270, 'logme.in' },
	--Mafiawars (Deprecated)
	--{ 0, 272, 'mafiawars.com' },
	--{ 0, 272, 'mafiawars.zynga.com' },
	--{ 0, 272, 'apps.facebook.com/inthemafia' },
	--Mercado Livre
	{ 0, 2860, 'mercadolibre.com' },
	{ 0, 2860, 'mercadolivre.com.br' },
	{ 0, 2860, 'mercadolibre.com.ar' },
	{ 0, 2860, 'mercadolibre.com.co' },
	{ 0, 2860, 'mercadolibre.co.cr' },
	{ 0, 2860, 'mercadolibre.cl' },
	{ 0, 2860, 'mercadolibre.com.do' },
	{ 0, 2860, 'mercadolibre.com.ec' },
	{ 0, 2860, 'mercadolibre.com.mx' },
	{ 0, 2860, 'mercadolibre.com.pa' },
	{ 0, 2860, 'mercadolibre.com.pe' },
	{ 0, 2860, 'mercadolivre.pt' },
	{ 0, 2860, 'mercadolibre.com.uy' },
	{ 0, 2860, 'mercadolibre.com.ve' },
	{ 0, 2860, 'mercadopago.com' },
	{ 0, 2860, 'mercadopago.com.br' },
	{ 0, 2860, 'mercadoshops.com.br' },
	--Motley Fool
	{ 0, 2863, 'fool.ca' },
	{ 0, 2863, 'fool.co.uk' },
	{ 0, 2863, 'fool.com.au' },
	{ 0, 2863, 'fool.sg' },
	--Meta5 (Deprecated)
	--{ 0, 288, 'meta5.us' },
	--{ 0, 288, 'meta5.com' },
	--DeNA websites
	{ 0, 2946, 'mobage.cn' },
	{ 0, 2946, 'mbga.jp' },
	{ 0, 2946, 'daum-mobage.kr' },
	{ 0, 2946, 'dena.jp' },
	{ 0, 2946, 'dena-ec.com' },
	{ 0, 2946, 'aumall.jp' },
	{ 0, 2946, 'mbok.jp' },
	{ 0, 2946, 'netsea.jp' },
	{ 0, 2946, 'estar.jp' },
	{ 0, 2946, 'paygent.co.jp' },
	{ 0, 2946, 'mangabox.me' },
	{ 0, 2946, 'showroom-live.com' },
	{ 0, 2946, 'applizemi.com' },
	{ 0, 2946, 'chirashiru.jp' },
	{ 0, 2946, 'smcb.jp' },
	{ 0, 2946, 'skygate.co.jp' },
	{ 0, 2946, 'arukikata.com' },
	{ 0, 2946, 'sougouhoken.jp' },
	{ 0, 2946, 'gbooks.jp' },
	{ 0, 2946, 'mycode.jp' },
	--{ 0, 2946, 'ssl.co-mm.com' },
	--Google Hangouts
	{ 0, 2960, 'mtalk.google.com' },
	--OpenCandy (Deprecated)
	--{ 0, 3672, 'opencandy.com' },
	--Netfolder.in (Deprecated)
	--{ 0, 3814, 'netfolder.in' },
	--Apple Store
	{ 0, 551, 'store.storeimages.cdn-apple.com' },
	{ 0, 551, 'ppq.apple.com' },
	--Delicious
	{ 0, 605, 'icio.us' },
	--ImageShack
	{ 0, 682, 'imageshack.us' },
	--Limelight
	--{ 0, 711, 'kiptronic.com' },
	--Lokalisten
	{ 0, 718, 'lokalisten.at' },
	--RapidShare (Deprecated)
	--{ 0, 802, 'rapidshare.com' },
	--Sears
	{ 0, 821, 'sears.ca' },
	{ 0, 821, 'searspartsdirect.com' },
	{ 0, 821, 'searshomeservices.com' },
	{ 0, 821, 'searsoutlet.com' },
	{ 0, 821, 'searscommerceservices.com' },
	{ 0, 821, 'searsflowers.com' },
	{ 0, 821, 'searshomepro.com' },
	{ 0, 821, 'searsoptical.com' },
	{ 0, 821, 'searsdrivingschools.com' },
	{ 0, 821, 'searsvacations.com' },
	{ 0, 821, 'searscommercial.com' },
	--HP Home & Home Office Store
	{ 0, 827, 'shopping.hp.com' },
	--Docstoc (Deprecated)
	--{ 0, 940, 'docstoc.com' },
	--Salesforce.com
	{ 0, 950, 'mybuys.com' },
	{ 0, 950, 'evergage.com' },
}
function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3])
        end
    end
    return gDetector
end

function DetectorClean()
end
