--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "coldplay"
version: 21
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'Conviva' => 'Ad site.',
          'Siteimprove' => 'Ad site.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.',
          'TwitPic' => 'Site for posting and sharing photos and videos on twitter.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'Intralinks' => 'A secure collaboration site.',
          'Playstation Games' => 'Playstation game traffic.',
          'Demandbase' => 'Advertising and marketing site.',
          'CCP Games' => 'Video game developer and publisher.',
          'Hola' => 'An open source VPN.',
          'Net2Phone' => 'A VoIP service.',
          '050plus' => 'VoIP smartphone app.',
          'Plista' => 'Marketing analytics site.',
          'Yahoo!' => 'Yahoo! and it\'s online services.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'SugarCRM' => 'Customer relationship management software company.',
          'Battle.net site' => 'Website for Battle.net.',
          'Marketo' => 'Ad site.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Twitter' => 'Social networking and microblogging site.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_coldplay",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gSSLHostPatternList = {
	--TwitPic
	{ 0, 1063, 'twimg.com' },
	--F-Prot
	{ 0, 162, 'f-prot.com' },
	--050plus
	{ 0, 2325, '050plus.com' },
	--WeChat
	{ 0, 2618, 'wechat.com' },
	--Sharepoint Online
	{ 0, 2813, 'sharepoint.microsoftonline.com' },
	--SugarCRM
	{ 0, 2833, 'videos.myspacecdn.com' },
	--YiXin
	{ 0, 2914, 'yixin.im' },
	--GG
	{ 0, 3706, 'gg.pl' },
	--Battle.net site
	{ 0, 3749, 'battle.net' },
	--Playstation Games
	{ 0, 3795, 'playstation.net' },
	--Net2Phone
	{ 0, 3806, 'net2phone.com' },
	--Demandbase
	{ 0, 3890, 'demandbase.com' },
	--Intralinks
	{ 0, 3891, 'intralinks.com' },
	--Plista
	{ 0, 3897, 'plista.com' },
	--Conviva
	{ 0, 3931, 'conviva.com' },
	--Marketo
	{ 0, 3940, 'marketo.com' },
	--Siteimprove
	{ 0, 3943, 'siteimprove.com' },
	--CCP Games
	{ 0, 4005, 'ccpgames.com' },
	--Hola
	{ 0, 4041, 'hola.org' },
	--Yahoo!
	{ 0, 524, 'yahoo.com' },
	--Citrix Online
	{ 0, 87, 'citrix.com' },
	--Twitter
	{ 0, 882, 'twitter.com' },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3])
        end
    end

    return gDetector
end

function DetectorClean()
end
