--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "7mary3"
version: 5
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'WebEx' => 'Cisco\'s online meeting and web conferencing application.',
          'YouTube' => 'A video-sharing website on which users can upload, share, and view videos.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_7mary3",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {

    { 0, 905, 'webex.com' },
    { 0, 905, 'files-prod-us-east-2.webexcontent.com' },
    { 0, 905, 'avatar-prod-us-east-2.webexcontent.com' },
    -- YouTube
    { 0, 929, 'youtube.com' },
    { 0, 929, 'ytimg.com' },
    { 0, 929, 'googlevideo.com' },
    { 0, 929, 'youtu.be' },
    { 0, 929, 'youtubei.googleapis.com' },
    { 0, 929, 'yt3.ggpht.com' },
}

gSSLCnamePatternList = {
    -- YouTube
    { 0, 929, 'youtubei.googleapis.com', },
    { 0, 929, 'yt3.ggpht.com', },

}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end


    return gDetector;
end

function DetectorClean()
end

