--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "5forfighting"
version: 8
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Cisco Jabber' => 'Cisco\'s version of the Jabber XMPP client.',
          'Gmail attachment' => 'Downloading an attached file from Gmail.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_5forfighting",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {

    -- C2DM
    -- { 0, 1182, 'mtalk.google.com' },

    -- Cisco Jabber
    { 1, 3971, 'isj3cmx.webexconnect.com' },
    { 1, 3971, 'ucdemo.cisco.local' },
    { 0, 3971, 'identity.webex.com' },
    --{ 1, 3971, 'metrics-a.wbx2.com' },

    -- Gmail attachment
    { 0, 3885, 'mail-attachment.googleusercontent.com' },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

