--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "334"
version: 37
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'The Pirate Bay' => 'BitTorrent index and search engine.',
          'Sony' => 'Official website for Sony Corporation.',
          'MediaFire' => 'File and image hosting site.',
          'NetSarang' => 'Network connectivity and management tools package.',
          'AppNexus' => 'Real-time advertising services.',
          'Leboncoin' => 'Auction and classified seller website.',
          'Marco Polo' => 'Marco Polo is a Mobile Social Media platform.',
          'AOL' => 'American company develops, grows and invests in brands and web sites.',
          'Airbnb' => 'Online accommodation rental service.',
          'Motley Fool' => 'Financial and Investment community.',
          'Launchpad' => 'Web based bug tracking and project management tool.',
          'Paybill' => 'Online secure payment and billing service.',
          'Evernote' => 'Synched note taking and web bookmarking app.',
          'Kaixin001' => 'Chinese based social networking service.',
          'RealVNC' => 'A VNC package that supports client and server side, and also provides cloud-based services such as chat and file transfer.',
          'TechInline' => 'Website that offers remote desktop control.',
          'Zattoo' => 'Internet protocol television.',
          'Battle.net site' => 'Website for Battle.net.',
          'Adcash' => 'Advertising network.',
          'ContextWeb' => 'Advertisement site.',
          'Instapaper' => 'App to save wb pages for later use.',
          'Integral Ad Science' => 'Advertisement site.',
          'Windscribe' => 'VPN traffic generated by Windscribe.',
          'MelOn' => 'Korean music site.',
          'Info.com' => 'Search engine.',
          'Wordpress' => 'An online blogging community.',
          'Ivacy Login' => 'Logging into Ivacy VPN, a firewall-bypassing service.',
          'Ballina Beach Village' => 'Website for a vacation resort where you can book and plan your trip to them.',
          'QQ Pay' => 'Tencent online payment service.',
          'VEVO.com' => 'Website for music videos.',
          'Surikate' => 'Ad site.',
          'TED' => 'Conference and Talk show to share ideas.',
          'Envato' => 'Combined software education and marketplace site.',
          'Brilig' => 'Advertisement site.',
          'Garmin' => 'Offcial website for Garmin, GPS manufacturer.',
          'Fidelity' => 'Mutual fund and financial services company.',
          'GoodSync' => 'File transfer and synchronization service.',
          'Bloomberg' => 'Financial news and research.',
          'Pandora' => 'Audio streaming.',
          'Bitbucket' => 'Source code hosting site.',
          'Eset' => 'Eset Antivirus/Security software download and updates.',
          'SoftEther' => 'An open source VPN.',
          'Hola' => 'An open source VPN.',
          'HSBC' => 'Global banking and financial services company.',
          'Prezi' => 'Presentation tool.',
          'Backblaze' => 'Online backup tool for Windows and Mac users.',
          'Megaproxy' => 'Web VPN services through SSL traffic.',
          'Ado Tube' => 'Video advertising solution.',
          'Microsoft Update' => 'Microsoft software updates.',
          'Podio' => 'Project Management software.',
          'RevenueHits' => 'Ad site.',
          'Hushmail' => 'Web mail service providing encrypted and virus scanned e-mail.',
          'Guardster' => 'Anonymous proxy service.',
          'Intralinks' => 'A secure collaboration site.',
          'UpToDate' => 'Online clinical database for medical professionals.',
          'DuckDuckGo' => 'Search engine.',
          'EA Games' => 'Web portal for Electronics Arts, a video games distributor.',
          'Arizona Public Media' => 'Web portal by University of Arizona to connect people.',
          'Acrobat.com' => 'Adobe file transfer and PDF conversion site.',
          'Samsung' => 'Electronics retail site.',
          'Xanga' => 'A website that hosts weblogs, photoblogs, and social networking profiles.',
          'Demio' => 'Demio is a webinar platform.',
          'ALTools' => 'Software tools by ESTsoft.',
          'wikidot' => 'Site that provides wikis.',
          'Monster VPN' => 'Monster VPN is a free VPN proxy, to get connected quickly to unblock sites, WiFi hotspot secure and protect privacy.',
          'Apple Music' => 'Internet radio by Apple.',
          'Apple sites' => 'Apple corporate websites.',
          'Reddit' => 'Social news link site.',
          'Open Webmail' => 'Webmail service.',
          'Outbrain' => 'Online help for publishers and bloggers.',
          'TAFE NSW' => 'TAFE NSW is Australia\'s leading provider for education and training courses.',
          'Periscope' => 'Mobile app for live video streaming.',
          'Tencent Video' => 'Tencent streaming video.',
          'Office 365' => 'Traffic generated by MS Office 365 applications and web services.',
          'iBackup' => 'Cloud-based backup service.',
          '58 City' => 'Classified information about 58 cities in China.',
          'Chase' => 'Consumer and commercial banking company.',
          'WPS Office' => 'Mobile app for viewing and editing documents, spreadsheet and PPTs.',
          'Brightcove' => 'Video hosting platform.',
          'Woopra' => 'Real time customer service and solutions.',
          'Skimlinks' => 'Advertisement site.',
          'ZipCloud' => 'Cloud-based backup service.',
          'ESPN' => 'Online Sports news and show.',
          'Comcast Mail' => 'Email service provided by Comcast.',
          'Zbigz' => 'Online BitTorrent Client.',
          'Rackspace' => 'Virtual and physical server hosting providers.',
          'Infonline' => 'Malware-generated online advertisements.',
          'NBC News' => 'NBCUniversal\'s news website.',
          'Sourceforge' => 'Site for sharing open source software projects.',
          'HP Home & Home Office Store' => 'HP\'s online store for computers and related products.',
          'Campfire' => 'Business-focused group messaging and enterprise social networking.',
          'FedEx' => 'Courier delivery services.',
          'Lotame' => 'Online advertising and marketing research platform.',
          'Smartsheet' => 'Smartsheet is a platform for organizational achievement.',
          'DingDing' => 'Instant messaging & Collaboration software.',
          'OpenX' => 'Closed advertising platform.',
          'Foursquare' => 'Location-based social networking.',
          'MaxPoint Interactive' => 'Advertisement site.',
          'Cloudnymous Login' => 'Logins to Cloudynomous, a private VPN/anonymizer service.',
          'Rubicon Project' => 'Online advertising infrastructure company.',
          'SiteScout' => 'Company targetting powerful and easy-to-use tech for real-time ads.',
          'IBM' => 'Website for IBM.',
          'RealNetworks' => 'Websites for RealNetworks, the streaming media company.',
          'Zapier' => 'Automatically sync the web apps.',
          'Nest Thermostat' => 'Manufactures of sensor driven Thermostats which are self-learning and programmable.',
          'Metacafe' => 'Online video entertainment website.',
          'LivingSocial' => 'Deals website.',
          'Tagged' => 'Social networking site based in California.',
          'Connexity' => 'Advertisement site.',
          'Apple Store' => 'Official online retailer of Apple products.',
          'TikTok' => 'Video social networking application.',
          'Jango' => 'Internet radio and social networking service.',
          'Match.com' => 'Dating website.',
          'Bet365' => 'Online gambling website.',
          'Plex TV' => 'Allows users to stream their own media from one device to others over the Plex TV network.',
          'Office365 Admin portal' => 'Admin portal to manage Office 365 products.',
          'Eclipse' => 'Software Updates for Eclipse.',
          'Krux' => 'Cloud-based online marketing and monetization service.',
          'Telegram' => 'Telegram is a messaging app with a focus on speed and security.',
          'Avaya Live' => 'Cloud based VoIP service.',
          'Answers.com' => 'A site that provides original answers to questions.',
          'Motrixi' => 'Advertisement site.',
          'Zulily' => 'Online shopping aimed for Moms with childerns apparel and home decor items.',
          'Mint.com' => 'Web-based personal finance tool.',
          'Redbox' => 'Online movie rental and video streaming.',
          'Panda' => 'Panda Security Antivirus/Security software download and updates.',
          'Dailymotion' => 'A video sharing service website.',
          'Last.fm' => 'A social networking music streaming site.',
          'APNS' => 'Apple Push Notification Service.',
          'ICQ' => 'Internet chat client.',
          'Allegro.pl' => 'Polish auction website.',
          'Browsec' => 'A VPN app.',
          'Apple Developer' => 'Web portal for Apple Developer.',
          'eXelate' => 'Advertisement site.',
          'BoldChat' => 'Live Chat software for website.',
          'ezhelp' => 'Allows remote access.',
          '4shared' => 'File sharing and storage service.',
          'Wikipedia' => 'Collaborative, user-written online encyclopedia.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Yandex' => 'Russian search engine.',
          'Pubmatic' => 'Web advertisement services.',
          'Yahoo! Mobage' => 'Mobile gaming platform popular in Japan.',
          'Chartbeat' => 'Realtime Website data for Collection.',
          'AnyDesk' => 'Remote Desktop Access Software.',
          'Groupon' => 'Gift certificate website.',
          'EdgeCast' => 'Verizon Digital Media Services content delivery network.',
          'Sears' => 'Department store retailer.',
          'MovieTickets.com' => 'Webportal for advanced movie ticketing, reviews and celebrity interviews.',
          'Pinboard' => 'Social bookmarking portal.',
          'VPNReactor' => 'An anonymizer that obfuscates web usage.',
          'StatCounter' => 'Web traffic analyser.',
          'Rotten Tomatoes' => 'Online information and reviews about new films.',
          'Odnoklassniki' => 'Russian social networking service.',
          'Gravatar' => 'Profile picture management for comments and discussion forum.',
          'Piksel' => 'Video streaming service.',
          'Eventbrite' => 'Event organization and invite site.',
          'Funshion' => 'Chinese site for online games, videos, and shopping.',
          'JoinMe' => 'Video, Audio and Text Conferencing provider.',
          'FriendFinder' => 'Online friend finder and dating site.',
          'Rediff.com' => 'Online news, information and web portal.',
          'Red Hat' => 'Open-source software products.',
          'Lokalisten' => 'German social network site focused on local events.',
          'Tunnelbear Login' => 'Logins to Tunnelbear, a web browsing anonymizer service.',
          'contnet' => 'Advertisement site.',
          'KProxy' => 'Anonymous proxy service.',
          'Mop.com' => 'Chinese webportal acting as bulletin board for pop culture, games and other entertainments.',
          'Vibrant' => 'Advertisement site.',
          'Mathworks' => 'Producers of MATLAB and other tools for science and engineering.',
          'eRoom' => 'Collaborative software site.',
          'Photobucket' => 'An image hosting, video hosting, slideshow creation and photo sharing website.',
          'Basecamp' => 'Web based project management tool.',
          'Workday' => 'Software as Service solutions provider.',
          'Rsupport' => 'A remote management application for PC support.',
          'Presto' => 'Printable emails and photos.',
          'MLive' => 'News local to the American state of Michigan.',
          'GoToMyPC' => 'PC remote control software.',
          'Victoria\'s Secret' => 'Woman\'s wear, lingerie, and beauty product retailer.',
          'Microsoft Stream' => 'Enterprise video streaming and sharing software.',
          'AD-X Tracking' => 'Data analysis and monitor ad related traffic tarfette for mobile application.',
          'Spiegel Online' => 'Web portal for the Germans magazine Der Speigel.',
          'SpotXchange' => 'Advertisement site.',
          'H&R Block' => 'Tax service provider.',
          'MyPCBackup' => 'Cloud-based backup service.',
          'Zerodha' => 'Financial services company with a focus on online stock brokerage.',
          'Viddler' => 'Online Video hosting service.',
          'CBS Interactive' => 'Division of CBS Corporation which coordinates ad sales and television programs together.',
          'Admeld' => 'Ad delivery company servicing online publishers.',
          'Azure cloud portal' => 'Microsoft Azure cloud service portal.',
          'Evidon' => 'Advertisement site.',
          'Open Drive' => 'Cloud storage and online backup system.',
          'Twinkl' => 'Official website for Twinkl educational resources.',
          'Bloglovin' => 'Blog portal.',
          'AdRoll' => 'Online advertising and Retargetting website vistor.',
          'Marca' => 'Primarily Spanish video streaming site.',
          'Marketo' => 'Ad site.',
          'GNU Project' => 'Aggregates free software for Unix-compatible system.',
          'SuperNews' => 'A Usenet/newsgroup service provider.',
          'ClickBooth' => 'Advertisement site.',
          'Webtrends' => 'Advertisement site.',
          'Nintendo' => 'Content delivery and web traffic from Nintendo, a Japanese company.',
          'BitComet' => 'BitTorrent client.',
          'Mendeley' => 'A tool for sharing, storing, and organizing reference material such as PDFs.',
          'JustCloud' => 'Cloud-based backup service.',
          'IFTTT' => 'Service to connect channels.',
          'Sourcefire.com' => 'Company website for Network security and Intrusion Detection engine.',
          'McAfee' => 'McAfee Antivirus/Security software download and updates.',
          'Game Center' => 'Social gaming app for iOS.',
          'ADMETA' => 'Advertisement site.',
          'NBC' => 'Official website for NBC\'s Television network.',
          'Geewa' => 'Browser and Facebook-based gaming.',
          'Yammer' => 'Enterprise social networking site.',
          'Coursera' => 'Educational site connecting people, offer online courses from top universities.',
          'comScore' => 'Digital business analytics.',
          'DepartApp' => 'Platform for measurement, collection, analysis and reporting of web data.',
          'Mention' => 'Site that will generate alerts and updates regarding topics you are interested in.',
          'LeadBolt' => 'Advertisement site.',
          'Hideman Login' => 'Logging into Hideman internet anonymizer.',
          'SVN' => 'Managing Subversion servers.',
          'StumbleUpon' => 'A web browser plugin that allows users to discover and rate webpages, photos, videos and news articles.',
          'Softonic' => 'Software download site.',
          'SBS' => 'Korean Online TV shows and Movies.',
          'Rambler' => 'Russian search engine.',
          'Bank of America' => 'Global financial services company.',
          'Hangame' => 'Korean online game portal.',
          'Weborama' => 'Video ad site.',
          'Hotspot Shield' => 'Anonymizer and tunnel that encrypts communications.',
          'Starbucks' => 'Mobile application for a ubiquitous chain of coffee shops.',
          'Sky.com' => 'Web portal for news.',
          'Twitter' => 'Social networking and microblogging site.',
          'Siri' => 'Voice interactive agent for Apple\'s iOS.',
          'Microsoft CRM Dynamics' => 'Microsoft product for sales, marketing and service sector.',
          'Naverisk' => 'Cloud-based remote monitoring and management software.',
          'SOS Online Backup' => 'Cloud-based backup service.',
          'Demandbase' => 'Advertising and marketing site.',
          'NHL.com' => 'The National Hockey League official website.',
          'Shareman' => 'Traffic generated from chat and file transfer service by Shareman client.',
          'Sogou' => 'Chinese web portal.',
          'Google News' => 'Automated news aggregator.',
          'Synology DSM' => 'Synology is a Network Attached Storage (NAS) appliances running Synology\'s DSM Software.',
          'Pushover' => 'Push notification services.',
          'CyberGhost VPN' => 'An anonymizer that obfuscates web usage.',
          'Sports Illustrated' => 'Web portal for sports news and updates.',
          'PNC Bank' => 'Banking and Financial services.',
          'Airtime' => 'Video chat.',
          'TwitchTV' => 'Justin.tv gaming specific livestreaming platform.',
          'Square Inc.' => 'Electronic payment service through mobile phones.',
          'TechCrunch' => 'IT related news and research site.',
          'Zmags' => 'Digital publisher for branded products to customer.',
          'Bomgar' => 'Remote desktop control and file transfer software.',
          'cXense' => 'Advertisement site.',
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'JSTOR' => 'Digital library for academic journals and books.',
          'Nuance' => 'Airline services and travel planner.',
          '17173.com' => 'Chinese social networking site.',
          'Amazon' => 'Online retailer of books and most other goods.',
          'Bing Maps' => 'Microsoft online mapping and directions service.',
          'Stitcher' => 'Internet radio for news and talk shows.',
          'Web.de' => 'German free email and cloud storage service.',
          'E*TRADE' => 'Financial services company with a focus on online stock brokerage.',
          'Zanox' => 'Advertising and analytics site.',
          'Twiddla' => 'Web based collaboration tool.',
          'Yahoo! Box' => 'Yahoo! Japan cloud storage service.',
          'VoiceFive' => 'Advertisement site.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'LA Times' => 'News site for the west coast newspaper.',
          'DataLogicx' => 'Advertisement site.',
          'Audible.com' => 'Digital audio version for books, magazines, information and other entertainments.',
          'The Telegraph' => 'Online news portal.',
          'Freewheel' => 'Advertisement site.',
          'Fluxiom' => 'Cloud storage, collaboration, and file management.',
          'Constant Contact' => 'Online marketing service.',
          'QQ Games' => 'Multi-Player online game by QQ.',
          'Channel 4' => 'British based streaming television.',
          'ESPNcricinfo' => 'ESPN site focused on the game of Cricket.',
          'Websense' => 'Company which produces Cyber security related products.',
          'Disney' => 'Official Disney website.',
          'Apple TV Plus' => 'Video streaming service from Apple Inc.',
          'Gmail' => 'Google online email.',
          'The Washington Post' => 'American daily newspaper.',
          'Silverpop' => 'Email marketing service.',
          'Sway' => 'Microsoft collaboration tool.',
          'Wells Fargo' => 'Global financial services company.',
          'QualysGuard' => 'Cloud security and compliance solutions.',
          'Xaxis' => 'Advertisement site.',
          'Wired.com' => 'Online magazine.',
          'IGN' => 'News/reviews website focused primarily on video games.',
          'Fifth Third Bank' => 'A bank.',
          'Online File Folder' => 'Cloud-based file storage.',
          'USPS' => 'US Postal Service website.',
          'ShowMyPC' => 'Cloud-based remote support and desktop sharing.',
          'Smart AdServer' => 'Advertisement site.',
          'CloudFlare' => 'Advertisement site.',
          'Astraweb' => 'A Usenet/newsgroup service provider.',
          'Amazon Web Services' => 'Online cloud computing service.',
          'NrData' => 'Category B ISP.',
          'Nielsen' => 'Global information and measurement company.',
          'Media6Degrees' => 'Advertisement site.',
          'Casale' => 'Advertisement site.',
          'DepositFiles' => 'International file hosting and sharing service.',
          'Java Update' => 'Java update software service.',
          'Showbox' => 'Mobile application providing streaming video content.',
          'Tencent' => 'Chinese portal for Internet service.',
          'AOL Mail' => 'AOL\'s email client and webmail.',
          'GitHub' => 'Code management portal for open Source projects.',
          'QQ Mail' => 'Tencent email service.',
          'Zynga' => 'Social network game developer.',
          'Blackbox' => 'Network hardware and software vendor.',
          'eBay' => 'An online auction and shopping website.',
          'Power BI' => 'Power BI is a business analytics service by Microsoft which aims to provide interactive visualizations and business intelligence capabilities.',
          'KakaoTalk' => 'Mobile messaging for smartphones.',
          'Malwarebytes' => 'Antimalware software.',
          'XiTi' => 'Advertising and analytics site.',
          'NAI' => 'Network Advertising Initiative - association comprises of 3rd party ad companies and educate consumers with online advertising.',
          'Cisco Secure Endpoint' => 'Cloud-based real time antivirus protection. (AMP for Endpoints).',
          'imo.im' => 'Instant messenger service for various instant messaging protocols.',
          'SugarSync' => 'Cloud-based backup service.',
          'State Farm' => 'Insurance company.',
          'Ando Media' => 'Metrics and analytics for Internet radio.',
          'Habbo' => 'Social networking site aimed at teenagers.',
          'Office Mobile' => 'Microsoft productivty apps for use on Android devices.',
          'HIKE' => 'Mobile App for Instant Messaging.',
          'Aliyun' => 'Chinese web portal.',
          'HBO' => 'Offical website for HBO shows.',
          'Connextra' => 'Advertisement site.',
          'Cisco' => 'Official website for Cisco.',
          'GOMTV.com' => 'Korean sports-related website.',
          'U.S.Bank' => 'Online banking web portal for U.S Bank.',
          'LinkedIn Contacts' => 'LinkedIn application for networking with contacts.',
          'LogMeIn' => 'Remote access and PC desktop control.',
          'PDBox' => 'Korean file-sharing site.',
          'Pivotal Tracker' => 'Project management and collaborative software.',
          '1000mercis' => 'Advertising and analytics site.',
          'Microsoft Visual Studio' => 'Microsoft Integrated Developer Environment and toolchain designed to make it easier to develop software for Microsoft platforms.',
          'Tumblr' => 'A combined social network and microblogging platform.',
          'Hide My Ass!' => 'Web surfing anonymizer.',
          'Polldaddy' => 'Advertisement site.',
          'Indiegogo' => 'Online Fund raiser for new ideas/products.',
          'Weebly' => 'Free, online website creation tool.',
          'SendSpace' => 'File sharing and hosting.',
          'OverBlog' => 'Platform to create blogs.',
          'Webex Teams' => 'Webex Teams is a collaboration tool with various clients (Windows, OS X, Android, Windows Mobile, iPad, iPhone, Web) for messages, calls, meetings, etc.',
          'Symantec System Center' => 'Anti-virus software management.',
          'Nvidia' => 'Video chipset manufacturer.',
          'Zalmos' => 'Web proxy/anonymizer.',
          'Mercado Livre' => 'Brazil online auction and shopping website.',
          'Neustar Information Services' => 'Advertisement site.',
          'Google' => 'Traffic generated by the Google search engine or one of the other many Internet services provided by Google Inc.',
          'Glympse' => 'Mobile App to share the location with others.',
          'Mail.Ru' => 'Runet\'s free e-mail service.',
          'NBA' => 'Official website for the National Basketball League, an American sports organization.',
          'Box' => 'File storage and transfer site.',
          'CSDN' => 'Chinese IT community/forum for Software related issues.',
          'Siteimprove' => 'Ad site.',
          'AdGear' => 'Advertisement site.',
          'GoBank' => 'A bank that focuses on mobile banking.',
          'New Relic' => 'Web metrics site.',
          'Exchange Online' => 'Traffic associated with Exchange Online, such as visiting outlook.com.',
          'Avast' => 'Anti-virus software for Windows PCs.',
          'GMX Mail' => 'German based webmail service.',
          '500px' => 'Online photo sharing.',
          'AdXpose' => 'Advertisement site.',
          'Jingdong (360buy.com)' => 'Chinese e-commerce site.',
          'Criteo' => 'Advertisement site.',
          'ClickTale' => 'Advertisement site.',
          'Google ads' => 'Google targeted advertising.',
          'Fancy' => 'Social media to share and buy items.',
          'Citi' => 'Financial services company.',
          'SLI Systems' => 'Advertisement site.',
          'Etsy' => 'E-commerce website for homemade or vintage items.',
          'Creative Commons' => 'Non-profit organization to share your creativity legally without losing the credits.',
          'Spotify' => 'Social Music Player.',
          'Pinger' => 'Allows SMS text messaging via a data connection.',
          'Ooyala' => 'Solution providers for Video analytics.',
          'The Internet Archive' => 'Internet content provider.',
          'Shutterfly' => 'Share, prints and personalize the cards, album, mugs and other Home decor items with your photos.',
          'Doubleclick' => 'Web advertisement services.',
          'Netflix' => 'Rental and on-demand internet television and movie streaming website.',
          'iStock' => 'Online royalty-free stock images.',
          'Bild.de' => 'Online edition of German tabloid.',
          'EA Download Manager' => 'Electronic Arts Download manager is a digital distribution for EA games.',
          'OneDrive' => 'Microsoft cloud storage offering, successor to SkyDrive.',
          'GNOME' => 'Official website for GNOME, a desktop environment and graphical UI.',
          'Minecraft' => 'Online game.',
          'Tus Files' => 'File upload/download site.',
          'Rakuten' => 'Japanese e-commerce site.',
          'Webs' => 'Photo, video, and file sharing, and online marketplace.',
          'TIME.com' => 'Webportal for TIME Magazine.',
          'Tango' => 'Mobile social networking app that provides voice, chat, and gaming services.',
          'Concur' => 'Business travel site.',
          'Kickass Torrents' => 'Torrent site.',
          'Elephant Drive' => 'Cloud storage service used primarily as an online backup tool.',
          'BBB' => 'Better Business Bureau - non-profit organization providing reliable business review.',
          'Adobe Fonts' => 'Adobe Fonts is an online service which offers a subscription library of high-quality fonts.',
          'Compuware' => 'Advertisement site.',
          'goo.ne.jp' => 'Japanese web portal.',
          'Pinterest' => 'Social photo sharing website.',
          'Parallels' => 'Cloud services enablement and virtual access.',
          'Disney Plus' => 'Disney+ is a video on-demand streaming subscription.',
          'OpenDNS' => 'DNS service for reliability and security for internet surfers.',
          'Uploading.com' => 'File transfer website.',
          'LinkedIn' => 'Career oriented social networking.',
          'Break.com' => 'Web portal for sharing funny videos and pictures.',
          'Scorecard Research' => 'Online marketing research community.',
          'Loyalty Innovations' => 'Reward programs and solutions for both online and offline.',
          'Okurin' => 'Japanese file upload site.',
          'DeNA websites' => 'Traffic generated by browsing DeNA Comm website and some other sites that belong to DeNA.',
          'Flipboard' => 'News aggregator Mobile application.',
          'Verizon Wireless' => 'Telecom and Internet provider.',
          'Aliexpress' => 'Online shopping portal.',
          'The Guardian' => 'Online news portal.',
          'Microsoft Ads' => 'Web advertisement services.',
          'MailChimp' => 'Email service provider.',
          'ServiceNow' => 'Cloud storage provider.',
          'T-Online' => 'German free email and cloud storage service.',
          'Venmo' => 'A free digital wallet that lets you make and share payments with friends.',
          'Freelancer' => 'Site for job listings for temporary work.',
          'Carbonite' => 'Cloud-based backup service.',
          'Tencent Cloud' => 'Tencent cloud services.',
          'Xiami.com' => 'Chinese online music website.',
          'Pocket' => 'App to save web pages.',
          'LeapFILE' => 'Managed file transfer site.',
          'Apple Maps' => 'Apple maps and navigation.',
          'Shutterstock' => 'Online collection of Stock photographs and illustrations.',
          'TomTom' => 'Gadget which provides traffic related details.',
          'Quora' => 'Online discussion forums on a wide variety of topics.',
          'Improve Digital' => 'European sell side online ad service.',
          'Commvault' => 'Enterprise data backup and storage management software.',
          'Neobux' => 'A site that pays users to view ads and recruit their friends.',
          'lynda.com' => 'Online education site focusing on aspects of web design.',
          'Trend Micro' => 'Security software company.',
          'DSW' => 'Designer Shoe Warehouse - branded footwear.',
          'Walmart' => 'Discount department store.',
          'Vine' => 'Mobile App for sharing photos and videos clips.',
          'bitly' => 'Web portal for bookmarking and sharing links.',
          'Amp' => 'AMP is a web component framework and a website publishing technology.',
          'Brighttalk' => 'Online webinar and video provider.',
          'Prime Video' => 'Amazon video streaming site.',
          'Progressive' => 'Insurance company.',
          'Imgur' => 'Image hosting website.',
          'Ask.com' => 'Search engine.',
          'Stanford University' => 'Official website for Stanford University, Educational Institute.',
          'ESTsoft' => 'Provides software tools and online games.',
          'Fotki' => 'Photo sharing site.',
          'SHOUTCast Radio' => 'Streaming media software.',
          'Allstate' => 'Insurance company.',
          'ADrive' => 'Online file storage and backup.',
          'NASA' => 'Web portal for NASA.',
          'Outlook' => 'Microsoft email service.',
          'Bing' => 'Microsoft\'s internet search engine.',
          'MediaV' => 'Advertisement site.',
          'RichRelevance' => 'Targeted advertising platform.',
          'BlueKai' => 'Data-driven online marketing.',
          'Backupgrid' => 'Reseller of cloud backup / storage solutions.',
          'Geico' => 'Insurance company.',
          'Lycos' => 'Search engine also offers email, web hosting and social networking.',
          'Bandcamp' => 'Explore online music posted by independendent artist.',
          'Adtegrity' => 'Advertisement site.',
          'Akamai' => 'Internet content delivery network and SSL certificate provider.',
          'Onehub' => 'A cloud storage provider.',
          'EQ Ads' => 'Advertisement site.',
          'Helpshift' => 'Customer service platform.',
          'Alibaba' => 'International trade site.',
          'Quantcast' => 'Site for buying and selling target audiences.',
          'Kickstarter' => 'Platform for creative projects with funding goal and deadline.',
          'TextNow' => 'Instant text and voice services.',
          'Narratiive' => 'Advertisement site.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'AT&T' => 'Telecom and Internet provider.',
          'QQ Music' => 'Tencent streaming music.',
          'CCP Games' => 'Video game developer and publisher.',
          'Office 365 Planner' => 'Microsoft online calendar.',
          'phpBB' => 'PHP based open source bulletin board software.',
          'OpenSUSE' => 'Official website for OpenSUSE, Linux based OS.',
          'Adenin' => 'A web portal.',
          'Blogger' => 'A blog publishing service owned by Google, formerly known as blogspot.',
          'TISTORY' => 'Korean Blog publishing service.',
          'J.P. Morgan' => 'Financial services arm of J.P. Morgan Chase & Co.',
          'TOR' => 'The Onion Router. A client which allows a user to send and relay internet traffic anonymously.',
          'Slack' => 'Chat and messaging app.',
          'Ubuntu' => 'Official website of Ubuntu.',
          'Apple News' => 'Apple News is an app the brings news and magazines, all in one place.',
          'TweetDeck' => 'Dashboard application to manage both Twitter and Facebook.',
          'Booking.com' => 'Online travel reservation site.',
          'BioDigital Human' => 'A web-based medical imaging app.',
          'Dwolla' => 'Online Payment service.',
          'Flickr' => 'An image hosting and video hosting website, web services suite, and online community.',
          'Conduit' => 'Online website to create community toolbar.',
          'Atlassian' => 'Project Control and Management Software.',
          'ImageShack' => 'Image hosting website.',
          'United Airlines' => 'Online Flight reservation from United Airlines.',
          'Shopkick' => 'Mobile app for shopping.',
          'Discover' => 'Financial services company.',
          'MyLife' => 'Social Networking.',
          'UOL' => 'Brazilian web portal for news and entertainment.',
          'SlideShare' => 'A web-based slide show service.',
          'Webshots' => 'Service for uploading and sharing photos and videos.',
          'NovaBACKUP' => 'NovaStor develops and markets data protection and availability software. NovaBACKUP offers support for multi-OS environments and is capable of handling thousands of servers and petabytes of information.',
          'WeTransfer' => 'Online file transferring platform.',
          'Dell' => 'Computer and related technologies retailer.',
          'Newegg' => 'Computer hardware and software retailer.',
          'WebEx' => 'Cisco\'s online meeting and web conferencing application.',
          'Apple iForgot' => 'Password reset portal for Apple.',
          'CBS' => 'CBS news website.',
          'Net2Phone' => 'A VoIP service.',
          'Capital One' => 'U.S. based bank holding company.',
          'PayPal' => 'E-commerce website for handling online transactions.',
          'The New York Times' => 'Newspaper website.',
          'Telly' => 'Video sharing and streaming site.',
          'Skype' => 'A software application that allows users to chat, make voice/video calls, and transfer files over the Internet.',
          'Craigslist' => 'Popular online classifieds.',
          'Salesforce.com' => 'Enterprise cloud computing company.',
          'Flightradar24' => 'Real-time aircraft flight tracking web service.',
          'Conviva' => 'Ad site.',
          'Six Apart' => 'Advertisement site.',
          'Bluehost' => 'Web hosting portal.',
          'WorldCat' => 'Library catalogue aggregator.',
          'American Airlines' => 'Airline services and travel planner.',
          'Microsoft Teams' => 'Microsoft Teams is a unified communication and collaboration platform for workplace communication exchange.',
          'Target' => 'Discount retailer.',
          'SurveyMonkey' => 'A site for distributing surveys.',
          'Microsoft Azure' => 'Cloud computing by Microsoft.',
          'Engage BDR' => 'Advertisement site.',
          'eFax' => 'Internet fax service.',
          'Hotels.com' => 'Webportal for finding hotel deals and booking it online.',
          'Classmates' => 'Social networking site that allows schoolmates to connect via yearbook photograph.',
          'Ngrok' => 'Multiplatform tunnelling, reverse proxy software.',
          'Wooga' => 'Browser and social network based games company.',
          'Slotomania' => 'Facebook slots game.',
          'Atlas Advertiser Suite' => 'Tools for online advertising.',
          'VyprVPN Login' => 'Logins to VyprVPN, a personal VPN service.',
          'Oracle sites' => 'The website for Oracle.',
          'Barnes and Noble' => 'Online retailer of books and other goods.',
          'ShareThis' => 'Social advertising widgets.',
          'Adtech' => 'Advertisement site.',
          'ZEDO' => 'Web advertisement services.',
          'ZenMate' => 'Proxy and security add-on to browser.',
          'WhatsApp' => 'A cross-platform mobile messaging app which serves as a free alternative to SMS messages.',
          'Urban Airship' => 'Mobile app developer.',
          'Sophos Live Protection' => 'Anti-Malware software.',
          'Ning' => 'Social Networking.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_334",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- Disney Plus
    {0, 4617, 'disney-plus.net', },
    {0, 4617, 'disneyplus.com', },
    {0, 4617, 'disneyplus.com.ssl.sc.omtrdc.net', },
    {0, 4617, 'dssott.com', },
    {0, 4617, 'dssott.com.akamaized.net', },
    {0, 4617, 'disneyplus.bn5x.net', },
    {0, 4617, 'cdn.registerdisney.go.com', },
    {0, 4617, 'disney-portal.my.onetrust.com', },
    {0, 4617, 'bamgrid.com', },
    -- Apple TV Plus
    {0, 4619, 'tv.apple.com', },
    -- Apple News
    {0, 4623, 'apple.news', },
    {0, 4623, 'news-events.apple.com', },
    {0, 4623, 'news-edge.apple.com', },
    -- Monster VPN
    {0, 4618, 'monstervpn.tech', },
    -- Demio
    {0, 4620, 'demio.com', },
    -- Smartsheet
    {0, 4621, 'smartsheet.com', },
    {0, 4621, 'app.10000ft.com', },
    -- Marco Polo
    {0, 4622, 'marcopolo.me', },
}

gSSLCnamePatternList = {

    -- Webshots
    { 0, 1021, 'www.sosbinario.com.br', },
    -- TwitchTV
    { 0, 1051, 'twitch.map.fastly.net' },
    -- DepositFiles
    { 0, 1054, 'depositfiles.com' },
    -- Tagged
    { 0, 1065, 'tagged.com' },
    -- Odnoklassniki
    { 0, 1070, 'ok.ru' },
    -- PayPal
    { 0, 1134, 'paypal.com' },
    -- The Pirate Bay
    { 0, 1136, 'ukpiratebay.site' },
    -- Hotspot Shield
    { 0, 1140, 'anchorfree.com' },
    { 0, 1140, 'esellerate.net' },
    { 0, 1140, 'event.shelljacket.us' },
    { 0, 1140, 'hotspotshield.com' },
    { 0, 1140, 'hsselite.com' },
    { 0, 1140, 'hsselite.zendesk.com' },
    -- WhatsApp
    { 0, 1143, 'whatsapp.net' },
    -- Pinger
    { 0, 1148, 'pinger.com' },
    -- Spotify
    { 0, 1158, 'spotify.com' },
    -- Answers.com
    { 0, 1168, 'answers.com' },
    -- Classmates
    { 0, 1169, 'classmates.com' },
    -- IBM
    { 0, 1173, 'ibm.com' },
    -- Open Webmail
    { 0, 1175, 'openwebmail.org' },
    -- SlideShare
    { 0, 1176, 'www.slideshare.net' },
    -- Sourceforge
    { 0, 1177, 'sourceforge.net' },
    -- SurveyMonkey
    { 0, 1178, 'surveymonkey.com' },
    -- Weebly
    { 0, 1181, 'weebly.com' },
    -- APNS
    { 0, 1184, 'courier.push.apple.com' },
    -- Apple sites
    { 0, 1185, 'www.apple.com' },
    -- Apple News
    {0, 4623, 'apple.news', },
    -- NBC News
    { 0, 1192, 'nbcnews.com' },
    { 0, 1192, 'today.com' },
    -- Mint.com
    { 0, 1193, 'mint.com' },
    -- Bild.de
    { 0, 1196, 'bild.de' },
    -- Bing Maps
    { 0, 1197, 'www.virtualearth.org' },
    --Bet365
    { 0, 1209, 'bet365.com' },
    -- Brighttalk
    { 0, 1211, 'brighttalk.com' },
    -- Envato
    { 0, 1213, 'envato.com' },
    -- goo.ne.jp
    { 0, 1216, 'goo.ne.jp' },
    { 0, 1216, 'www.xgoo.jp' },
    -- Leboncoin
    { 0, 1219, 'leboncoin.fr' },
    -- Online File Folder
    { 0, 1223, 'onlinefilefolder.com' },
    -- Webs
    { 0, 1228, 'websimages.com' },
    -- DoubleDownCasino
    --{ 0, 1234, 'doubledowncasino.com' },
    -- Mesmo Games
    --{ 0, 1240, 'mesmo.tv' },
    -- Slotomania
    { 0, 1243, 'slotomania.com' },
    -- Dropbox
    --{ 0, 125, 'dropbox.com' },
    -- Bloomberg
    { 0, 1259, 'bloomberg.com' },
    -- Avast
    { 0, 1264, 'avast.com' },
    -- Evernote
    { 0, 1267, 'evernote.com' },
    -- Wooga
    { 0, 1298, 'wooga.com' },
    -- The New York Times
    { 0, 1299, 'nytimes.com' },
    -- DoubleClick
    { 0, 1313, 'doubleclick.net' },
    -- Pubmatic
    { 0, 1315, 'pubmatic.com' },
    -- eBay
    { 0, 132, 'www.ebay.com' },
    -- Acrobat.com
    { 0, 1322, 'acrobat.com' },
    -- Box
    { 0, 1326, 'box.com' },
    { 0, 1326, 'box.net' },
    { 0, 1326, 'boxcloud.com' },
    -- CBS
    { 0, 1332, 'cbsnews.com' },
    { 0, 1332, 'tampa.cbslocal.com' },
    -- Microsoft Ads
    { 0, 1336, 'ads.microsoft.com' },
    -- Samsung
    { 0, 1357, 'samsung.com' },
    -- TweetDeck Dashboard app to manage Twitter and Facebook
    { 0, 1360, 'tweetdeck.com' },
    -- ZEDO
    { 0, 1362, 'target.zedo.com' },
    -- ESPN Online sports update
    { 0, 1364, 'redirect.espn.com' },
    -- Outbrain Online help for bloggers and publishers
    { 0, 1369, 'outbrain.com' },
    -- Ask.com Search engine
    { 0, 1371, 'cdncert.askmediagroup.com' },
    -- Etsy E-commerce for homemade items
    { 0, 1374, 'etsy.com' },
    -- Conduit Web portal
    { 0, 1375, 'como.com' },
    -- ATT
    { 0, 1380, 'att.com' },
    -- Verizon Wireless
    { 0, 1388, 'verizonwireless.com' },
    -- AWS
    { 0, 1392, 'amazonaws.com' },
    { 0, 1392, 'aws.amazon.com' },
    -- Sourcefire
    { 0, 1398, 'sourcefire.com' },
    -- TED
    { 0, 1403, 'ted.com' },
    -- Eclipse
    { 0, 1413, 'eclipse.org' },
    -- NASA
    { 0, 1417, 'nasa.gov' },
    -- AOL
    { 0, 1419, 'aol.it' },
    -- Eset
    { 0, 143, 'www.eset.com' },
    -- Sports Illustrated
    { 0, 1456, 'saymedia2.map.fastly.net' },
    -- Chartbeat
    { 0, 1460, 'chartbeat.com' },
    -- LivingSocial
    { 0, 1495, 'livingsocial.com' },
    -- US Bank
    { 0, 1500, 'supplierpreferpay.com' },
    -- Disney
    { 0, 1515, 'static.matterhorn.disney.io' },
    { 0, 1521, 'us-dallas.statcounter.com' },
    -- Shutterfly
    { 0, 1543, 'shutterfly.com' },
    -- Mail.ru
    { 0, 1551, 'mail.ru' },
    -- Square Inc.
    { 0, 1568, 'square.com' },
    -- flickr
    { 0, 159, 'flickr.com' },
    -- biodigitalhuman
    { 0, 1595, 'biodigitalhuman.com' },
    -- Apple Developer
    { 0, 1596, 'developer.apple.com' },
    -- Geewa
    { 0, 1597, 'geewa.com' },
    -- GoToMyPC
    { 0, 1598, 'www.gotomypc.com' },
    -- usps
    { 0, 1601, 'usps.com' },
    -- Siri
    { 0, 1603, 'guzzoni.apple.com' },
    -- Shutterstock
    { 0, 1614, 'shutterstock.com' },
    -- Yandex
    { 0, 1616, 'static.yandex.net' },
    -- Adcash
    { 0, 1617, 'adcash.com' },
    -- The Guardian
    { 0, 1618, 'guardian.map.fastly.net' },
    -- F-Prot
    { 0, 162, 'cyren.com' },
    -- The Telegraph
    { 0, 1620, 'telegraph.co.uk' },
    -- Rediff.com
    { 0, 1624, 'rediff.com' },
    -- Spiegel Online
    { 0, 1625, 'spiegel.de' },
    -- UOL
    { 0, 1626, 'uol.com.br' },
    -- Jingdong
    { 0, 1627, 'jd.com' },
    -- ShowMyPC
    { 0, 1630, 'showmypc.com' },
    -- Airtime
    { 0, 1645, 'airtime.com' },
    -- CSDN
    { 0, 1646, 'csdn.net' },
    -- Aliexpress
    { 0, 1648, 'aliexpress.com' },
    -- 58 City
    { 0, 1649, '58.com' },
    -- Rakuten
    { 0, 1652, 'rakuten.co.jp' },
    -- Airbnb
    { 0, 1655, 'airbnb.com' },
    -- Urban Airship
    { 0, 1657, 'urbanairship.com' },
    -- Akamai
    { 0, 1659, 'akamai.com' },
    -- Loyalty Innovations
    { 0, 1660, 'www.loyaltyinnovations.com' },
    -- Dwolla
    { 0, 1664, 'dwolla.com' },
    -- Fancy
    { 0, 1668, 'fancy.com' },
    -- GitHub
    { 0, 1670, 'github.com' },
    -- Trend Micro
    { 0, 1671, 'trendmicro.com' },
    { 0, 1671, 'antivirus.com' },
    -- QualysGuard
    { 0, 1675, 'www.qualys.com' },
    -- ADrive
    { 0, 17, 'adrive.com' },
    -- Vine
    { 0, 1700, 'vine.co' },
    -- MyLife
    { 0, 1702, 'www.mylife.com' },
    -- Ning
    { 0, 1703, 'ning.com' },
    -- Gravatar
    { 0, 1704, 'gravatar.com' },
    -- Kickstarter
    { 0, 1705, 'b3.shared.global.fastly.net' },
    -- The Washington Post
    { 0, 1709, 'washingtonpost.com' },
    -- H&R Block
    { 0, 1792, 'www.hrblock.com' },
    -- Constant Contact
    { 0, 1793, 'constantcontact.com' },
    -- Pivotal tracker
    { 0, 1794, 'pivotaltracker.com' },
    -- Podio
    { 0, 1796, 'podio.com' },
    -- Minecraft
    { 0, 1802, 'minecraft.net' },
    -- Rotten Tomatoes
    { 0, 1803, 'rottentomatoes.com' },
    -- Backupgrid
    { 0, 1812, 'backupgrid.net' },
    -- Carbonite
    { 0, 1813, 'carbonite.com' },
    -- iBackup
    { 0, 1814, 'ibackup.com' },
    -- JustCloud
    { 0, 1815, 'justcloud.com' },
    -- MyPCBackup
    { 0, 1817, 'mypcbackup.com' },
    -- SOS Online Backup
    { 0, 1818, 'sosonlinebackup.com' },
    -- SugarSync
    { 0, 1819, 'sugarsync.com' },
    -- ZipCloud
    { 0, 1820, 'zipcloud.com' },
    -- Redbox
    { 0, 1830, 'redbox.com' },
    -- Google
    { 0, 184, 'googleusercontent.com' },
    -- NBA
    { 0, 1939, 'nba.com' },
    -- NBC
    { 0, 1988, 'www.nbc.com' },
    -- Zmags
    { 0, 1994, '5764017373052928-fe3.pantheonsite.io' },
    -- GNOME
    { 0, 1995, 'gnome.org' },
    -- ESTsoft
    { 0, 1996, 'estgames.com' },
    --ALTools
    { 0, 1998, 'altools.com' },
    -- Ubuntu
    { 0, 2003, 'ubuntu.com' },
    -- Wired.com
    { 0, 2005, 'condenast.com' },
    -- NHL
    { 0, 2007, 'nhlnetwork.viewerlink.tv' },
    -- Presto
    { 0, 2008, 'presto.com' },
    -- Brightcove
    { 0, 2019, 'brightcove.com' },
    -- Atlassian
    { 0, 2038, 'atlassian.com' },
    -- Prezi
    { 0, 2040, 'prezi.com' },
    -- IFTTT
    { 0, 2041, 'ifttt.com' },
    -- Apple iForgot
    { 0, 2045, 'iforgot.apple.com' },
    -- OpenSuse
    { 0, 2056, 'opensuse.org' },
    -- DSW
    { 0, 2059, 'designerbrands.com' },
    -- BoldChat
    { 0, 2067, 'boldchat.com' },
    -- Woopra
    { 0, 2069, 'woopra.com' },
    -- Ooyala
    { 0, 2072, 'ooyala.com' },
    -- lynda.com
    { 0, 2086, 'lynda.com' },
    -- FriendFinder
    { 0, 2093, 'friendfinder.com' },
    -- Audible.com
    { 0, 2094, 'audible.com' },
    -- Microsoft Azure
    { 0, 2111, 'azure.com' },
    -- Eventbrite
    { 0, 2139, 'eventbrite.com' },
    -- J.P. Morgan
    { 0, 2140, 'jpmm.com' },
    -- GoBank
    { 0, 2141, 'gobank.com' },
    -- Nvidia
    { 0, 2150, 'nvidia.com' },
    -- Progressive
    { 0, 2152, 'progressive.com' },
    -- State Farm
    { 0, 2153, 'statefarm.com' },
    -- Allstate
    { 0, 2154, 'allstate.com' },
    -- Geico
    { 0, 2155, 'geico.com' },
    -- PNC Bank
    { 0, 2172, 'pnc.com' },
    -- Red Hat
    { 0, 2173, 'redhat.com' },
    -- Unite Airlines
    { 0, 2174, 'united.com' },
    -- TextNow
    { 0, 2176, 'textnow.com' },
    -- FedEx
    { 0, 2177, 'fedex.com' },
    -- American Airlines
    { 0, 2178, 'usairways.com' },
    -- Nuance
    { 0, 2179, 'netmng.com' },
    { 0, 2179, 'nuance.com' },
    -- MLive
    { 0, 2182, 'star4.arcpublishing.com' },
    -- Bitbucket
    { 0, 2185, 'bitbucket.org' },
    -- Yammer
    { 0, 2198, 'yammer.com' },
    -- Zapier
    { 0, 2206, 'zapier.com' },
    -- Sony
    { 0, 2234, 'sony.com' },
    -- WeTransfer
    { 0, 2236, 'wetransfer.com' },
    -- Sorify
    --{ 0, 2237, 'storify.com' },
    -- Oracle sites
    { 0, 2245, 'oracle.com' },
    -- Fifth Third Bank
    { 0, 2257, 'www.53.com' },
    -- Campfire
    { 0, 2270, 'campfirenow.com' },
    -- TechInline
    { 0, 2351, 'fixme.it' },
    { 0, 2351, 'techinline.com' },
    -- wikidot
    { 0, 2352, 'wikidot.com' },
    -- CBS Interactive
    { 0, 2354, 'cbspressexpress.com' },
    -- Foursquare
    { 0, 2357, 'foursquare.com' },
    -- The Internet Archive
    { 0, 2358, 'archive.org' },
    -- Adenin / Dynamic Intranet
    { 0, 2360, 'adenin.com' },
    -- Groupon
    { 0, 2361, 'groupon.com' },
    -- Match.com
    { 0, 2363, 'match.com' },
    -- Uploading.com
    { 0, 2366, 'api.uploading.com' },
    -- Tango
    { 0, 2379, 'tango.me' },
    -- Apple Maps
    { 0, 2381, 'maps.apple.com' },
    -- SendSpace
    { 0, 2382, 'sendspace.com' },
    -- Sogou
    { 0, 2383, 'sogou.com' },
    -- 17173.com
    { 0, 2385, '17173.com' },
    -- Alibaba
    { 0, 2386, 'alibaba.com' },
    -- Aliyun
    { 0, 2389, 'aliyun.com' },
    -- Naverisk
    { 0, 2390, 'naverisk.com' },
    -- Funshion
    { 0, 2391, 'funshion.com' },
    -- amazon
    --{ 0, 24, 'images-na.ssl-images-amazon.com' },
    { 0, 24, 'jobs.amazon.co.uk' },
    -- Google ads
    { 0, 2403, 'googleadservices.com' },
    -- RichRelevance
    { 0, 2404, 'richrelevance.com' },
    -- Quantcast
    { 0, 2405, 'quantcast.com' },
    -- Scorecard Research
    { 0, 2408, 'scorecardresearch.com' },
    -- AppNexus
    { 0, 2413, 'appnexus.com' },
    -- OpenX
    { 0, 2415, 'openx.com' },
    -- Rubicon Project
    { 0, 2417, 'rubiconproject.com' },
    -- Pinboard
    { 0, 2437, 'pinboard.in' },
    -- Improve Digital
    { 0, 2451, '360yield.com' },
    { 0, 2451, 'improvedigital.com' },
    -- BlueKai
    { 0, 2452, 'bluekai.com' },
    -- Admeld
    { 0, 2454, 'misc.google.com' },
    -- Atlas Advertiser Suite
    { 0, 2456, 'atlassolutions.com' },
    -- Silverpop
    { 0, 2460, 'silverpop.com' },
    -- Infonline
    { 0, 2461, 'infonline.de' },
    -- comScore
    { 0, 2462, 'comscore.com' },
    -- Lotame
    { 0, 2465, 'lotame.com' },
    -- Krux
    { 0, 2466, 'logtails.stark-mesa-1789.herokuspace.com' },
    -- Nielsen
    { 0, 2468, 'careers.nielsen.com' },
    -- PDBox
    { 0, 2471, 'filecity.co.kr' },
    -- Freelancer
    { 0, 2483, 'freelancer.com' },
    -- Marca
    { 0, 2486, 'marca.com' },
    -- Telly
    { 0, 2487, 'telly.com' },
    -- SLI Systems
    { 0, 2494, 'sli-systems.com' },
    -- AdGear
    { 0, 2500, 'adgear.com' },
    -- MediaV
    { 0, 2501, 'mediav.com' },
    -- ClickTale
    { 0, 2502, 'clicktale.com' },
    -- Adtech
    { 0, 2503, 'ad-tech.sg' },
    { 0, 2503, 'adtechaustralia.com' },
    -- LeadBolt
    { 0, 2505, 'leadbolt.com' },
    -- Evidon
    { 0, 2510, 'evidon.com' },
    -- Brilig
    { 0, 2511, 'bcbs3-cos-lb02.novalocal' },
    -- Casale
    { 0, 2512, 'indexexchange.com' },
    -- Criteo
    { 0, 2514, 'criteo.com' },
    -- Narratiive
    { 0, 2516, 'narratiive.com' },
    -- eXelate
    { 0, 2517, 'exelator.com' },
    -- Vibrant
    { 0, 2519, 'vibrantmedia.com' },
    -- Media6Degrees
    { 0, 2522, 'dstillery.com' },
    -- Motrixi
    { 0, 2525, 'motrixi.com' },
    -- Connextra
    { 0, 2529, 'betgenius.com' },
    -- Integral Ad Science
    { 0, 2532, 'integralads.com' },
    -- CloudFlare
    { 0, 2535, 'cloudflare.com' },
    -- Neustar Information Services
    { 0, 2537, 'neustar.biz' },
    -- AdXpose
    { 0, 2538, 'adxpose.com' },
    -- EQ Ads
    { 0, 2539, 'EQWorks.com' },
    -- Xaxis
    { 0, 2541, 'xaxis.com' },
    -- DataLogicx
    { 0, 2542, 'www-legacy.oracle.com' },
    -- Aggregate Knowledge
    --{ 0, 2547, 'neustar.biz' },
    -- SpotXchange
    { 0, 2548, 'spotxchange.com' },
    -- Engage BDR
    { 0, 2554, 'first-impression.com' },
    { 0, 2554, 'engagebdr.com' },
    -- Connexity
    { 0, 2555, 'www.connexity.com' },
    -- Six Apart
    { 0, 2560, 'movabletype.com' },
    { 0, 2560, 'sixapart.jp' },
    -- MaxPoint Interactive
    { 0, 2561, 'valassisdigital.com' },
    { 0, 2561, 'valassis.com' },
    -- contnet
    { 0, 2566, 'your-server.de' },
    -- Smart AdServer
    { 0, 2568, 'smartadserver.com' },
    -- ADMETA
    { 0, 2569, 'admeta.com' },
    -- ContextWeb
    { 0, 2571, 'contextweb.com' },
    -- cXense
    { 0, 2572, 'cxense.com' },
    -- Freewheel
    { 0, 2574, 'freewheel.com' },
    { 0, 2574, 'freewheel.tv' },
    -- Adtegrity
    { 0, 2577, 'adtegrity.com' },
    -- Compuware
    { 0, 2579, 'compuware.com' },
    -- Polldaddy
    { 0, 2582, 'polldaddy.com' },
    -- VoiceFive
    { 0, 2584, 'voicefive.com' },
    -- ClickBooth
    { 0, 2585, 'clickbooth.com' },
    -- Webtrends
    { 0, 2587, 'webtrends.com' },
    -- Skimlinks
    { 0, 2590, 'skimlinks.com' },
    -- Softonic
    { 0, 2599, 'softonic.com' },
    -- Booking.com
    { 0, 2600, 'booking.com' },
    { 0, 2600, 'workingatbooking.com' },
    -- Concur
    { 0, 2601, 'concur.com' },
    -- Rambler
    { 0, 2603, 'rambler.ru' },
    -- Boxcar.io
    --{ 0, 2605, 'boxcar.io' },
    -- TechCrunch
    { 0, 2607, 'techcrunch.com' },
    -- LA Times
    { 0, 2609, 'latimes.com' },
    -- Last.fm
    { 0, 261, 'last.fm' },
    -- WeChat
    { 0, 2618, 'map.qq.com' },
    -- ShareThis
    { 0, 2635, 'sharethis.com' },
    { 0, 2640, 'gomtv.com' },
    -- VyprVPN Login
    { 0, 2644, 'api.goldenfrog.com' },
    -- Tunnelbear
    { 0, 2645, 'tunnelbear.com' },
    -- Ivacy Login
    { 0, 2646, 'ivacy.com' },
    -- Hide My Ass!
    { 0, 2648, 'hidemyass.com' },
    -- VEVO.com
    { 0, 2650, 'vevo.map.fastly.net' },
    -- HBO
    { 0, 2652, 'hbo.com' },
    -- Stitcher
    { 0, 2653, 'stitcher.com' },
    -- Panoramio
--    { 0, 2654, 'panoramio.com' },
    -- Cisco
    { 0, 2655, 'www.cisco.com' },
    -- Hotels.com
    { 0, 2659, 'hotels.com' },
    -- JSTOR
    { 0, 2660, 'jstor.org' },
    -- Xiami.com
    { 0, 2661, 'xiami.com' },
    -- Ando Media
    { 0, 2665, 'andomedia.com' },
    -- Break.com
    { 0, 2666, 'break.com' },
    -- Apple Music
    { 0, 2669, 'music.apple.com' },
    -- Hideman
    { 0, 2681, 'hideman.net' },
    -- Cloudnymous Login
    { 0, 2682, 'cloudnymous.com' },
    -- mathworks
    { 0, 2687, 'mathworks.com' },
    -- GoodSync
    { 0, 2688, 'goodsync.com' },
    -- UpToDate
    { 0, 2689, 'uptodate.com' },
    -- new relic
    { 0, 2690, 'newrelic.com' },
    -- WorldCat
    { 0, 2691, 'worldcat.org' },
    -- Sky.com
    { 0, 2699, 'sky.com' },
    -- LogMeIn
    { 0, 270, 'logmein.com' },
    -- Arizona Public Media
    { 0, 2700, 'azpm.org' },
    -- EA Games
    { 0, 2701, 'origin.com' },
    -- TomTom
    { 0, 2703, 'tomtom.com' },
    -- OpenDNS
    { 0, 2704, 'www.opendns.com' },
    -- Sophos Live Protection
    { 0, 2707, 'sophos.com' },
    -- RealNetworks
    { 0, 2726, 'real.com' },
    -- Garmin
    { 0, 2729, 'garmin.com' },
    -- Dropcam
--    { 0, 2739, 'dropcam.com' },
    -- nest
    { 0, 2749, 'www.nest.com' },
    -- Indiegogo
    { 0, 2752, 'indiegogo.com' },
    -- MailChimp
    { 0, 2754, 'mailchimp.com' },
    -- MovieTickets.com
    { 0, 2755, 'www.movietickets.com' },
    -- Comcast Mail
    { 0, 2756, 'login.comcast.net' },
    -- Coursera
    { 0, 2757, 'coursera.org' },
    -- Bandcamp
    { 0, 2762, 'bandcamp.com' },
    -- Bluehost
    { 0, 2764, 'bluehost.com' },
    -- OverBlog
    { 0, 2767, 'over-blog.com' },
    -- BBB
    { 0, 2768, 'bbb.org' },
    -- TIME.com
    { 0, 2770, 'time.com' },
    -- phpBB
    { 0, 2772, 'phpbb.com' },
    -- GNU Project
    { 0, 2774, 'emacs.org' },
    -- Lycos
    { 0, 2775, 'lycos.com' },
    -- Creative Commons
    { 0, 2777, 'creativecommons.net' },
    -- NAI
    { 0, 2778, 'web-prod.networkadvertising.org' },
    -- Stanford University
    { 0, 2783, 'stanford.edu' },
    -- bitly
    { 0, 2787, 'bit.ly' },
    { 0, 2787, 'bitly.com' },
    -- Viddler
    { 0, 2788, 'viddler.com' },
    -- Websense
    { 0, 2790, 'websense.com' },
    -- Zbigz
    { 0, 2791, 'zbigz.com' },
    -- Zulily
    { 0, 2792, 'zulily.com' },
    -- Zattoo
    { 0, 2793, 'zattoo.com' },
    -- McAfee
    { 0, 280, 'mcafee.com' },
    -- DuckDuckGo
    { 0, 2805, 'duckduckgo.com' },
    -- Exchange Online
    { 0, 2810, 'outlook.com' },
    { 0, 2810, 'outlook.office.com' },
    -- Office 365
    { 0, 2812, 'activation-v2.sls.microsoft.com' },
    { 0, 2812, 'client.hip.live.com' },
    { 0, 2812, 'mem.gfx.ms' },
    --{ 0, 2812, 'msocdn.com' },
    { 0, 2812, 'o365weve.com' },
    { 0, 2812, 'office365.com' },
    { 0, 2812, 'officeapps.live.com' },
    { 0, 2812, 'officecdn.microsoft.com' },
    { 0, 2812, 'portal.officeppe.com' },
    -- Sharepoint Online
    { 0, 2813, 'cdn.onenote.net' },
    { 0, 2813, 'sharepointonline.com' },
    { 0, 2813, 'svc.ms' },
    -- Tencent
    { 0, 2815, 'tencent.com' },
    -- Fluxiom
    { 0, 2818, 'fluxiom.com' },
    -- LeapFILE
    { 0, 2820, 'leapfile.net' },
    -- Okurin
    { 0, 2822, 'www.bitpark.co.jp' },
    -- Fotki
    { 0, 2824, 'fotki.com' },
    -- eRoom
    { 0, 2826, 'rdgw.opentext.com' },
    -- Hangame
    { 0, 2832, 'hangame.com' },
    -- Megaproxy
    { 0, 2834, 'www.megaproxy.com' },
    -- KProxy
    { 0, 2835, 'kproxy.com' },
    -- Guardster
    { 0, 2836, 'guardster.com' },
    -- Twiddla
    { 0, 2841, 'twiddla.com' },
    -- Quora
    { 0, 2843, 'quora.com' },
    -- Yahoo! Mobage
    { 0, 2844, 'yahoo-mbga.jp' },
    -- Ado Tube
    { 0, 2847, 'adotube.com' },
    -- AdRoll
    { 0, 2848, 'adroll.com' },
    -- mediafire
    { 0, 285, 'mediafire.com' },
    -- AD-X Tracking
    { 0, 2850, 'ad-x.co.uk' },
    -- Allegro.pl
    { 0, 2851, 'allegro.pl' },
    -- iStock
    { 0, 2858, 'www.istockphoto.com' },
    -- Mercado Livre
    { 0, 2860, 'mercadolivre.com' },
    -- Mop.com
    { 0, 2862, 'mop.com' },
    -- Motley Fool
    { 0, 2863, 'fool.com' },
    -- SiteScout
    { 0, 2864, 'sitescout.com' },
    -- Bloglovin
    { 0, 2867, 'bloglovin.com' },
    -- Microsoft CRM Dynamic
    { 0, 2871, 'dynamics.microsoft.com' },
    --{ 0, 2871, 'videobreakdown.com' },
    -- SVN
    { 0, 2887, 'www.visualsvn.com' },
    -- GMX
    --{ 0, 2892, 'gmx.co.uk' },
    --{ 0, 2892, 'gmx.com' },
    --{ 0, 2892, 'gmx.net' },
    -- YiXin
    { 0, 2914, 'yixin.im' },
    -- Shareman
    { 0, 2918, 'shareman.tv' },
    -- DeNA websites
    { 0, 2946, 'dena.com' },
    -- NovaBACKU
    { 0, 336, 'novabackup.com' },
    -- Panda
    { 0, 359, 'pandasecurity.com' },
    -- VPNReactor
    { 0, 3652, 'vpnreactor.com' },
    -- CyberGhost VPN
    { 0, 3653, 'cyberghostvpn.com' },
    -- MelOn
    { 0, 3659, 'melon.com' },
    -- GG
    { 0, 3706, 'gadu-gadu.pl' },
    { 0, 3706, 'gg.pl' },
    -- 1000mercis
    { 0, 3715, '1000mercis.com' },
    -- Piksel
    { 0, 3716, 'carelink.co.uk' },
    -- Surikate
    { 0, 3719, 'preprod.mozoo.com' },
    -- Weborama
    { 0, 3723, 'weborama.com' },
    -- XiTi
    { 0, 3724, 'xiti.com' },
    -- Zanox
    { 0, 3725, 'softgarden.io' },
    { 0, 3725, 'zanox.com' },
    -- QQ Games
    { 0, 3727, 'bns.qq.com' },
    { 0, 3727, 'game.gtimg.cn' },
    { 0, 3727, 'game.qq.com' },
    -- OneDrive
    { 0, 3735, 'onedrive.com' },
    -- LinkedIn Contacts
    { 0, 3736, 'platform.linkedin.com' },
    -- Rackspace
    { 0, 3737, 'my.rackspace.com' },
    -- ServiceNow
    { 0, 3738, 'www.servicenow.com' },
    -- T-Online
    --{ 0, 3739, 'tcmt.t-online.de' },
    { 0, 3739, 'www.t-online.de' },
    -- Web.de
    { 0, 3740, 'web.de' },
    -- Workday
    { 0, 3741, 'workday.com' },
    -- Battle.net site
    { 0, 3749, 'www.battle.net' },
    -- y! box
    { 0, 3757, 'box.yahoo.co.jp' },
    -- LogMeIn Rescue
    --{ 0, 3784, 'secure.logmeinrescue.com' },
    -- Mendeley
    { 0, 3785, 'mendeley.com' },
    -- Onehub
    { 0, 3786, 'onehub.com' },
    -- eFax
    { 0, 3789, 'www.efax.com' },
    -- Amazon Instant Video
    { 0, 3793, 'www.primevideo.com' },
    -- TISTORY
    { 0, 3798, 'www.tistory.com' },
    -- Astraweb
    { 0, 38, 'astraweb.com' },
    -- ezhelp
    { 0, 3803, 'www.ezhelp.co.kr' },
    -- Net2Phone
    { 0, 3806, 'net2phone.com' },
    -- Channel 4
    { 0, 3811, 'channel4.com' },
    -- SBS
    { 0, 3818, 'sbs.co.kr' },
    -- HipChat
    --{ 0, 3858, 'hipchat.com' },
    -- Neobux
    { 0, 3867, 'www.neobux.com' },
    -- Kickass Torrents
    { 0, 3870, 'kat.cr' },
    -- RevenueHits
    { 0, 3873, 'revenuehits.com' },
    { 0, 3873, 'www.myfood.ltd' },
    -- Info.com
    { 0, 3876, 'info.com' },
    -- Tencent Cloud
    { 0, 3880, 'qcloud.com' },
    --{ 0, 3880, 'weixin.qq.com' },
    -- QQ Mail
    { 0, 3882, 'mail.qq.com' },
    -- QQ Pay
    { 0, 3883, 'api.unipay.qq.com' },
    -- Demandbase
    { 0, 3890, 'demandbase.com' },
    -- Intralinks
    { 0, 3891, 'intralinks.com' },
    -- Conviva
    { 0, 3931, 'conviva.com' },
    -- Marketo
    { 0, 3940, 'marketo.com' },
    -- QQ Music
    { 0, 3941, 'wetv.acc.qq.com' },
    -- Tencent Video
    { 0, 3942, 'v.qq.com' },
    -- Siteimprove
    { 0, 3943, 'siteimprove.com' },
    -- espncricinfo
    { 0, 3978, 'espncricinfo.com' },
    -- Microsoft Visual Studio
    { 0, 3979, 'dc.services.visualstudio.com' },
    -- Malwarebytes
    { 0, 3990, 'malwarebytes.com' },
    -- Periscope
    { 1, 3992, 'periscope.tv' },
    { 1, 3992, 'pscp.tv' },
    -- ZenMate
    { 0, 3994, 'zenmate.com' },
    -- ibVPN
--    { 0, 3996, 'ibvpn.com' },
    -- CCP Games
    { 0, 4005, 'ccpgames.com' },
    -- WPS Office
    { 0, 4010, 'wps.com' },
    -- Hola
    { 0, 4041, 'hola.org' },
    -- Slack
    { 0, 4045, 'slack.com' },
    -- Sway
    { 0, 4069, 'sway.office.com' },
    -- Planner
    { 0, 4070, 'tasks.office.com' },
    -- Office Mobile
    { 0, 4072, 'roaming.officeapps.live.com' },
    -- blackbox
    { 0, 4078, 'blackbox.com' },
    -- Webex teams
    { 1, 4080, 'ciscospark.com' },
    { 1, 4080, 'wbx2.com' },
    -- Synology DSM
    { 0, 4089, 'synology.com' },
    -- Browsec
    { 0, 4094, 'browsec.com' },
    -- Zalmos
    { 0, 4106, 'zalmos.com' },
    -- Bomgar
    { 0, 4107, 'bomgar.com' },
    -- Rsupport
    { 0, 4110, 'startsupport.com' },
    -- EdgeCast
    { 0, 4111, 'edgecast.com' },
    -- Telegram
    { 0, 4116, 'tdesktop.com' },
    -- Nintendo
    { 0, 4130, 'nintendo.com' },
    -- Ngrok
    { 0, 4134, 'ngrok.com' },
    -- Paybill
    { 0, 4135, 'paybill.com' },
    -- Elephant Drive
    { 0, 4143, 'elephantdrive.com' },
    -- Open Drive
    { 0, 4144, 'od.lk' },
    { 0, 4144, 'opendrive.com' },
    -- AnyDesk
    { 0, 4145, 'anydesk.com' },
    -- NetSarang
    { 0, 4146, 'netsarang.com' },
    -- Flightradar24
    { 0, 4148, 'flightradar24.com' },
    -- Showbox
    { 0, 4149, 'showboxa.com' },
    -- Hotstar
    --{ 0, 4153, 'hotstar.com' },
    --{ 0, 4153, 'gravityrd-services.com' },
    -- TikTok
    { 0, 4154, 'tiktok.com' },
    -- DingDing
    { 0, 4163, 'dingtalk.com' },
    -- Venmo
    { 0, 4387, 'venmo.com' },
    -- Tus Files
    { 0, 4515, 'tusfiles.com' },
    -- Power BI
    { 0, 4520, 'powerbi.com' },
    -- Azure cloud portal
    { 0, 4533, 'portal.azure.com' },
    -- SuperNews
    { 0, 454, 'supernews.com' },
    -- Office 365 admin portal
    { 0, 4540, 'syncservice.eu.microsoftonline.com' },
    -- Windscribe
    { 0, 4541, 'windscribe.com' },
    -- microsoft Stream
    { 0, 4553, 'microsoftstream.com' },
    -- Helpshift
    { 0, 4568, 'helpshift.com' },
    -- Symantec
    { 0, 459, 'shasta-ars.norton.com' },
    -- Adobe Fonts
    { 0, 4602, 'fonts.adobe.com' },
    -- Amp
    { 0, 4603, 'amp.dev' },
    -- NrData
    { 0, 4607, '1gramstore.com' },
    -- Twinkl
    { 0, 4608, 'www.twinkl.com' },
    -- Zerodha
    { 0, 4609, 'zerodha.com' },
    -- Ballina Beach Village
    { 0, 4610, 'ballinabeachpark.com' },
    -- TAFE NSW
    { 0, 4611, 'marketing.tafensw.edu.au' },
    -- DepartApp
    { 0, 4613, 'tracker.departapp.com' },
    -- Microsoft teams
    { 0, 4616, 'teams.microsoft.com' },
    -- Backblaze
    { 0, 47, 'backblaze.com' },
    -- TOR
    { 0, 473, 'torproject.org' },
    -- Tumblr
    { 0, 475, 'tumblr.com' },
    -- Wikipedia
    { 0, 501, 'wikipedia.org' },
    -- Wordpress
    { 0, 506, 'wordpress.com' },
    -- Xanga
    { 0, 510, 'xanga.com' },
    -- Zynga
    { 0, 533, 'zynga.com' },
    -- AOL Mail
    { 0, 546, 'mail.aol.com' },
    -- Apple Store
    { 0, 551, 'store.apple.com' },
    -- bankofamerica
    { 0, 560, 'bankofamerica.com' },
    -- Barnes and Noble
    { 0, 561, 'nook.com' },
    { 0, 561, 'barnesandnoble.com' },
    -- Basecamp
    { 0, 563, 'basecamp.com' },
    -- blogger
    { 0, 576, 'blogger.com' },
    -- bing
    { 0, 58, 'bing.com' },
    -- capitalone
    { 0, 582, 'capitalone.com' },
    -- chase
    { 0, 587, 'chase.com' },
    -- citi
    { 0, 590, 'citi.com' },
    -- craigslist
    { 0, 594, 'craigslist.org' },
    -- Dailymotion
    { 0, 600, 'dailymotion.com' },
    -- dell
    { 0, 606, 'Dell.com' },
    -- discover
    { 0, 615, 'discover.com' },
    -- E*Trade
    { 0, 621, 'etrade.com' },
    -- fidelity
    { 0, 636, 'fidelity.com' },
    -- Gmail
    { 0, 655, 'gmail.com' },
    { 0, 655, 'mail.google.com' },
    -- google news
    { 0, 663, 'news.google.com' },
    -- hsbc
    { 0, 675, 'hsbc.com' },
    -- ICQ
    { 0, 679, 'icq.com' },
    { 0, 679, 'icq.net' },
    -- ign
    { 0, 680, 'ign.com' },
    -- imageshack
    { 0, 682, 'imageshack.com' },
    -- imgur
    { 0, 684, 'imgur.com' },
    -- imo.im
    { 0, 685, 'imo.im' },
    -- Launchpad
    { 0, 708, 'launchpad.net' },
    -- LinkedIn
    { 0, 713, 'linkedin.com' },
    -- Lokalisten
    { 0, 718, '7tv.de' },
    -- Metacafe
    { 0, 728, 'metacafe.com' },
    -- Microsoft Update
    { 0, 731, 'update.microsoft.com' },
    -- netflix
    { 0, 756, 'netflix.com' },
    -- newegg
    { 0, 759, 'ssl-images.newegg.com' },
    -- Outlook
    { 0, 776, 'diagnostics.outlook.com' },
    -- Pandora
    { 0, 779, 'pandora.com' },
    -- Photobucket
    { 0, 784, 'photobucket.com' },
    -- Picasa
    --{ 0, 785, 'googlebrandlab.com' },
    -- Reddit
    { 0, 804, 'reddit.com' },
    -- Sears
    { 0, 821, 'sears.com' },
    -- HP Home & Home Office Store
    { 0, 827, 'hp.com' },
    -- SHOUTCast Radio
    { 0, 829, 'shoutcast.com' },
    -- Skype
    { 0, 832, 'www.skype.com' },
    -- Stumbleupon
    { 0, 852, 'stumbleupon.com' },
    -- Target
    { 0, 858, 'sites.target.com' },
    -- Twitter
    { 0, 882, 'twitter.com' },
    -- victoriassecret
    { 0, 892 , 'victoriassecret.com' },
    -- walmart
    { 0, 901, 'walmart.com' },
    -- WebEx
    { 0, 905, 'webex.com' },
    -- wellsfargo
    { 0, 907, 'wellsfargo.com' },
    -- Cisco Secure Endpoint
    { 0, 934, 'amp.sourcefire.com' },
    -- 4shared
    { 0, 948, '4shared.com' },
    -- Salesforce.com
    { 0, 950, 'salesforce.com' },
    -- Commvault
    { 0, 96, 'commvault.com' },
    -- GMX Mail
    { 0, 977, 'gmx.com' },                                                                         
    -- habbo
    { 0, 980, 'www.habbo.com' },
    -- hushmail
    { 0, 981, 'www.hushmail.com' },
    -- jango
    { 0, 987, 'airwave.systems' },
    -- kaixin001
    { 0, 989, 'kaixin001.com' },
    -- Pinterest
    { 0, 1135, 'pinterest.com' },
    -- Flipboard
    { 0, 1402, 'flipboard.com' },
    -- Kakao
    { 1, 1405, 'kakao.com' },
    -- Java Update
    { 0, 1569, 'downloads-jau.oracle.com' },
    { 0, 1569, 'java.com' },
    -- 500px
    { 0, 1654, 'j79-prod.500px.net' },
    -- Avaya Live
    { 0, 1661, 'avayalive.com' },
    -- Mention
    { 0, 1798, 'mention.net' },
    -- Glympse
    { 0, 1808, 'glympse.com' },
    -- Game Center
    { 0, 2092, 'gc.apple.com' },
    -- Starbucks
    { 0, 2112, 'starbucks.com' },
    -- Pocket
    { 0, 2431, 'getpocket.com' },
    -- Instapaper
    { 0, 2434, 'instapaper.com' },
    -- Pushover
    { 0, 2438, 'pushover.net' },
    -- Parallels
    { 0, 2802, 'parallels.com' },
    -- Shopkick
    { 0, 2831, 'shopkick.com' },
    -- SoftEther
    { 0, 3809, 'softether.com' },
    -- EA Download Manager
    { 0, 4016, 'darkside.ea.com' },
    -- JoinMe
    { 0, 4019, 'join.me' },
    -- HIKE Messenger
    --{ 0, 4132, 'im.hike.in' },
    { 0, 4132, 'hike.in' },
    -- RealVNC
    { 0, 4142, 'realvnc.com' },
    -- Plex TV
    { 0, 4524, 'plex.tv' },
    -- BitComet
    { 0, 4552, 'bitcomet.com' },
    -- Demio
    {0, 4620, 'demio.com' },
    -- Smartsheet
    { 0, 4621, 'smartsheet.com' },
    -- Marco Polo
    { 0, 4622, 'marcopolo.me' },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end


    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

