--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "1ders"
version: 50
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Open Webmail' => 'Webmail service.',
          'NBA' => 'Official website for the National Basketball League, an American sports organization.',
          'SendSpace' => 'File sharing and hosting.',
          'Hideman Login' => 'Logging into Hideman internet anonymizer.',
          'Imgur' => 'Image hosting website.',
          'Motrixi' => 'Advertisement site.',
          'OpenX' => 'Closed advertising platform.',
          'Neustar Information Services' => 'Advertisement site.',
          'Rubicon Project' => 'Online advertising infrastructure company.',
          'ICQ' => 'Internet chat client.',
          'TowerData' => 'Formerly RapLeaf, an advertisement site.',
          'Alipay' => 'Online payment service.',
          'Google Hangouts' => 'Google cross-platform messenger application.',
          'Apple Store' => 'Official online retailer of Apple products.',
          'Telly' => 'Video sharing and streaming site.',
          'Mercado Livre' => 'Brazil online auction and shopping website.',
          'IKEA.com' => 'Online storefront for international furniture retailer.',
          'DeNA websites' => 'Traffic generated by browsing DeNA Comm website and some other sites that belong to DeNA.',
          'TechInline' => 'Website that offers remote desktop control.',
          'TechCrunch' => 'IT related news and research site.',
          'Pandora' => 'Audio streaming.',
          'Match.com' => 'Dating website.',
          'SoundCloud' => 'Music platform for artists to upload and promote their music.',
          'Leboncoin' => 'Auction and classified seller website.',
          'SVN' => 'Managing Subversion servers.',
          'Mozilla' => 'Website for many open source software projects, including the Firefox browser.',
          'Last.fm' => 'A social networking music streaming site.',
          'LA Times' => 'News site for the west coast newspaper.',
          'LogMeIn' => 'Remote access and PC desktop control.',
          'Microsoft Store' => 'Online retailer for Microsoft products.',
          'Nielsen' => 'Global information and measurement company.',
          'Improve Digital' => 'European sell side online ad service.',
          'Sourceforge' => 'Site for sharing open source software projects.',
          'SBS' => 'Korean Online TV shows and Movies.',
          'Samsung' => 'Electronics retail site.',
          'IGN' => 'News/reviews website focused primarily on video games.',
          'Engage BDR' => 'Advertisement site.',
          'PDBox' => 'Korean file-sharing site.',
          'Meetup' => 'Social networking website.',
          'Hushmail' => 'Web mail service providing encrypted and virus scanned e-mail.',
          'Netease' => 'Chinese web portal.',
          'Naverisk' => 'Cloud-based remote monitoring and management software.',
          'Target' => 'Discount retailer.',
          'MelOn' => 'Korean music site.',
          'SiteScout' => 'Company targetting powerful and easy-to-use tech for real-time ads.',
          'Kooora.com' => 'Webportal for Sports related news.',
          'CBS' => 'CBS news website.',
          'SpotXchange' => 'Advertisement site.',
          'Adenin' => 'A web portal.',
          'Optimizely' => 'Advertisement site.',
          'DomainTools' => 'A domain name registrar.',
          'Rocket Fuel' => 'Advertisement site.',
          'eBay' => 'An online auction and shopping website.',
          'Kaixin001' => 'Chinese based social networking service.',
          'SlideShare' => 'A web-based slide show service.',
          'LINE' => 'Mobile and Desktop App for Instant Messaging.',
          'contnet' => 'Advertisement site.',
          'Monetate' => 'Advertisement site.',
          'MediaV' => 'Advertisement site.',
          'Quake Live' => 'Online video game by id Software.',
          'HP Home & Home Office Store' => 'HP\'s online store for computers and related products.',
          'ShowMyPC' => 'Cloud-based remote support and desktop sharing.',
          'TeacherTube' => 'Educational video streaming.',
          'Lotame' => 'Online advertising and marketing research platform.',
          'Polldaddy' => 'Advertisement site.',
          'SPC Media' => 'New media production company.',
          'MaxPoint Interactive' => 'Advertisement site.',
          'Motley Fool' => 'Financial and Investment community.',
          'RichRelevance' => 'Targeted advertising platform.',
          'Mixpanel' => 'Advertisement site.',
          'SuperNews' => 'A Usenet/newsgroup service provider.',
          'iStock' => 'Online royalty-free stock images.',
          'StatCounter' => 'Web traffic analyser.',
          'Scorecard Research' => 'Online marketing research community.',
          'Limelight' => 'Content delivery network.',
          'Tagged' => 'Social networking site based in California.',
          'Reddit' => 'Social news link site.',
          'Infonline' => 'Malware-generated online advertisements.',
          'NetSeer' => 'Advertisement site.',
          'comScore' => 'Digital business analytics.',
          'SurveyMonkey' => 'A site for distributing surveys.',
          'LeadBolt' => 'Advertisement site.',
          'Skimlinks' => 'Advertisement site.',
          'Sears' => 'Department store retailer.',
          'Luminate' => 'Advertisement site.',
          'Delicious' => 'Social bookmarking website for storing, sharing, and finding web bookmarks.',
          'NovaBACKUP' => 'NovaStor develops and markets data protection and availability software. NovaBACKUP offers support for multi-OS environments and is capable of handling thousands of servers and petabytes of information.',
          'Tango' => 'Mobile social networking app that provides voice, chat, and gaming services.',
          'Adtech' => 'Advertisement site.',
          'HubPages' => 'Social blogging site.',
          'Drawbridge' => 'Advertisement site.',
          'Six Apart' => 'Advertisement site.',
          'Rambler' => 'Russian search engine.',
          'Jango' => 'Internet radio and social networking service.',
          'Mop.com' => 'Chinese webportal acting as bulletin board for pop culture, games and other entertainments.',
          'DepositFiles' => 'International file hosting and sharing service.',
          'Metacafe' => 'Online video entertainment website.',
          'Sogou' => 'Chinese web portal.',
          'Marca' => 'Primarily Spanish video streaming site.',
          'Softonic' => 'Software download site.',
          'Silverpop' => 'Email marketing service.',
          'RhythmOne' => 'Advertisement site.',
          'Smart AdServer' => 'Advertisement site.',
          'iCloud' => 'Apple cloud storage service.',
          'SLI Systems' => 'Advertisement site.',
          'Hotspot Shield' => 'Anonymizer and tunnel that encrypts communications.',
          'Salesforce.com' => 'Enterprise cloud computing company.',
          'Newegg' => 'Computer hardware and software retailer.',
          'SHOUTCast Radio' => 'Streaming media software.',
          'imo.im' => 'Instant messenger service for various instant messaging protocols.',
          'MediaFire' => 'File and image hosting site.',
          'Envato' => 'Combined software education and marketplace site.',
          'Krux' => 'Cloud-based online marketing and monetization service.',
          'LinkedIn' => 'Career oriented social networking.',
          'Photobucket' => 'An image hosting, video hosting, slideshow creation and photo sharing website.',
          'Microsoft Ads' => 'Web advertisement services.',
          'Brilig' => 'Advertisement site.',
          'Ado Tube' => 'Video advertising solution.',
          'Doof' => 'Online gaming site.',
          'Line2' => 'Mobile VoIP application with support for text messaging.',
          'Dell' => 'Computer and related technologies retailer.',
          'MediaMath' => 'Advertising and business analytics.',
          'Online File Folder' => 'Cloud-based file storage.',
          'Quantcast' => 'Site for buying and selling target audiences.',
          'iPerceptions' => 'Online marketing analysis provider.',
          'Resonate Networks' => 'Advertisement site.',
          'Narratiive' => 'Advertisement site.',
          'ImageShack' => 'Image hosting website.',
          'StumbleUpon' => 'A web browser plugin that allows users to discover and rate webpages, photos, videos and news articles.',
          'IBM' => 'Website for IBM.',
          'Pinger' => 'Allows SMS text messaging via a data connection.',
          'Lokalisten' => 'German social network site focused on local events.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "ssl_host_group_1ders",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gSSLHostPatternList = {
	--SoundCloud
	{ 0, 1007, 'soundcloud.com' },
	--DepositFiles
	{ 0, 1054, 'depositfiles.com' },
	--Tagged
	{ 0, 1065, 'tagged.com' },
	--Hotspot Shield
	{ 0, 1140, 'hotspotshield.com' },
	--Pinger
	{ 0, 1148, 'pinger.com' },
	--Line2
	{ 0, 1149, 'line2.com' },
	--DomainTools
	{ 0, 1172, 'domaintools.com' },
	--IBM
	{ 0, 1173, 'ibm.com' },
	--Open Webmail
	{ 0, 1175, 'openwebmail.org' },
	--SlideShare
	{ 0, 1176, 'slideshare.com' },
	--Sourceforge
	{ 0, 1177, 'sourceforge.net' },
	--SurveyMonkey
	{ 0, 1178, 'surveymonkey.com' },
	--iCloud
	{ 0, 1187, 'icloud.com' },
	--Envato
	{ 0, 1213, 'envato.com' },
	--Leboncoin
	{ 0, 1219, 'leboncoin.fr' },
	--Netease
	{ 0, 1222, '163.com' },
	--Online File Folder
	{ 0, 1223, 'onlinefilefolder.com' },
	--Mozilla
	{ 0, 1261, 'mozilla.org' },
	--eBay
	{ 0, 132, 'ebay.com' },
	--CBS
	{ 0, 1332, 'cbslocal.com' },
	--Microsoft Ads
	{ 0, 1336, 'adcenter.microsoft.com' },
	--Samsung
	{ 0, 1357, 'samsung.com' },
	--StatCounter
	{ 0, 1521, 'statcounter.com' },
	--ShowMyPC
	{ 0, 1630, 'showmypc.com' },
	--LINE
	{ 1, 1667, 'line.me' },
	--NBA
	{ 0, 1939, 'nba.com' },
	--IKEA.com
	{ 0, 2349, 'ikea.com' },
	--TechInline
	{ 0, 2351, 'techinline.com' },
	--Doof
	{ 0, 2359, 'doof.com' },
	--Adenin
	{ 0, 2360, 'adenin.com' },
	--Match.com
	{ 0, 2363, 'match.com' },
	--Meetup
	{ 0, 2364, 'meetup.com' },
	--Tango
	{ 0, 2379, 'tango.me' },
	--SendSpace
	{ 0, 2382, 'sendspace.com' },
	--Sogou
	{ 0, 2383, 'sogou.com' },
	--Naverisk
	{ 0, 2390, 'naverisk.com' },
	--RichRelevance
	{ 0, 2404, 'richrelevance.com' },
	--Quantcast
	{ 0, 2405, 'quantcast.com' },
	--Scorecard Research
	{ 0, 2408, 'scorecardresearch.com' },
	--SPC Media
	{ 0, 2411, 'spcmedia.co.uk' },
	--OpenX
	{ 0, 2415, 'openx.com' },
	--MediaMath
	{ 0, 2416, 'mediamath.com' },
	--Rubicon Project
	{ 0, 2417, 'rubiconproject.com' },
	--Improve Digital
	{ 0, 2451, 'improvedigital.com' },
	--iPerceptions
	{ 0, 2455, 'iperceptions.com' },
	--Silverpop
	{ 0, 2460, 'silverpop.com' },
	--Infonline
	{ 0, 2461, 'infonline.de' },
	--comScore
	{ 0, 2462, 'comscore.com' },
	--Lotame
	{ 0, 2465, 'lotame.com' },
	--Krux
	{ 0, 2466, 'krux.com' },
	--Nielsen
	{ 0, 2468, 'nielsen.com' },
	--PDBox
	{ 0, 2471, 'pdbox.co.kr' },
	--HubPages
	{ 0, 2485, 'hubpages.com' },
	--Marca
	{ 0, 2486, 'marca.com' },
	--Telly
	{ 0, 2487, 'telly.com' },
	--SLI Systems
	{ 0, 2494, 'sli-systems.com' },
	--Monetate
	{ 0, 2496, 'monetate.net' },
	--MediaV
	{ 0, 2501, 'mediav.com' },
	--Adtech
	{ 0, 2503, 'ad-tech.com' },
	--LeadBolt
	{ 0, 2505, 'leadbolt.com' },
	--Drawbridge
	{ 0, 2509, 'drawbrid.ge' },
	--Brilig
	{ 0, 2511, 'brilig.com' },
	--Narratiive
	{ 0, 2516, 'narratiive.com' },
	--Luminate
	{ 0, 2521, 'luminate.com' },
	--Motrixi
	{ 0, 2525, 'motrixi.com' },
	--Optimizely
	{ 0, 2530, 'optimizely.com' },
	--Neustar Information Services
	{ 0, 2537, 'neustar.com' },
	--TowerData
	{ 0, 2540, 'rapleaf.com' },
	--SpotXchange
	{ 0, 2548, 'spotxchange.com' },
	--NetSeer
	{ 0, 2551, 'netseer.com' },
	--Resonate Networks
	{ 0, 2553, 'resonateinsights.com' },
	--Engage BDR
	{ 0, 2554, 'engagebdr.com' },
	--Six Apart
	{ 0, 2560, 'sixapart.com' },
	--MaxPoint Interactive
	{ 0, 2561, 'maxpoint.com' },
	--Rocket Fuel
	{ 0, 2563, 'rocketfuel.com' },
	--RhythmOne
	{ 0, 2564, 'rhythmone.com' },
	--contnet
	{ 0, 2566, 'contnet.com' },
	--Smart AdServer
	{ 0, 2568, 'smartadserver.com' },
	--Polldaddy
	{ 0, 2582, 'polldaddy.com' },
	--Skimlinks
	{ 0, 2590, 'skimlinks.com' },
	--Mixpanel
	{ 0, 2593, 'mixpanel.com' },
	--Softonic
	{ 0, 2599, 'softonic.com' },
	--TeacherTube
	{ 0, 2602, 'teachertube.com' },
	--Rambler
	{ 0, 2603, 'rambler.ru' },
	--TechCrunch
	{ 0, 2607, 'techcrunch.com' },
	--LA Times
	{ 0, 2609, 'latimes.com' },
	--Last.fm
	{ 0, 261, 'last.fm' },
	--Hideman Login
	{ 0, 2681, 'hideman.com' },
	--LogMeIn
	{ 0, 270, 'logmein.com' },
	--Ado Tube
	{ 0, 2847, 'adotube.com' },
	--MediaFire
	{ 0, 285, 'mediafire.com' },
	--iStock
	{ 0, 2858, 'istockphoto.com' },
	--Kooora.com
	{ 0, 2859, 'kooora.com' },
	--Mercado Livre
	{ 0, 2860, 'mercadolivre.com' },
	--Mop.com
	{ 0, 2862, 'mop.com' },
	--Motley Fool
	{ 0, 2863, 'fool.com' },
	--SiteScout
	{ 0, 2864, 'sitescout.com' },
	--SVN
	{ 0, 2887, 'visualsvn.com' },
	--Quake Live
	{ 0, 2888, 'quakelive.com' },
	--DeNA websites
	{ 0, 2946, 'dena.com' },
	--Google Hangouts
	{ 0, 2960, 'hangouts.google.com' },
	--NovaBACKUP
	{ 0, 336, 'novastor.com' },
	--Alipay
	{ 0, 3655, 'alipay.com' },
	--MelOn
	{ 0, 3659, 'melon.com' },
	--Microsoft Store
	{ 0, 3670, 'microsoftstore.com' },
	--SBS
	{ 0, 3818, 'sbs.co.kr' },
	--SuperNews
	{ 0, 454, 'supernews.com' },
	--Apple Store
	{ 0, 551, 'store.apple.com' },
	--Delicious
	{ 0, 605, 'delicious.com' },
	--Dell
	{ 0, 606, 'dell.com' },
	--ICQ
	{ 0, 679, 'icq.com' },
	--IGN
	{ 0, 680, 'ign.com' },
	--ImageShack
	{ 0, 682, 'imageshack.com' },
	--Imgur
	{ 0, 684, 'imgur.com' },
	--imo.im
	{ 0, 685, 'imo.im' },
	--Limelight
	{ 0, 711, 'llnw.com' },
	{ 0, 711, 'limelight.com' },
	--LinkedIn
	{ 0, 713, 'linkedin.com' },
	--Lokalisten
	{ 0, 718, 'lokalisten.de' },
	--Metacafe
	{ 0, 728, 'metacafe.com' },
	--Newegg
	{ 0, 759, 'newegg.com' },
	--Pandora
	{ 0, 779, 'pandora.com' },
	--Photobucket
	{ 0, 784, 'photobucket.com' },
	--Reddit
	{ 0, 804, 'reddit.com' },
	--Sears
	{ 0, 821, 'sears.com' },
	--HP Home & Home Office Store
	{ 0, 827, 'store.hp.com' },
	--SHOUTCast Radio
	{ 0, 829, 'shoutcast.com' },
	--StumbleUpon
	{ 0, 852, 'stumbleupon.com' },
	--Target
	{ 0, 858, 'target.com' },
	--Salesforce.com
	{ 0, 950, 'salesforce.com' },
	--Hushmail
	{ 0, 981, 'hushmail.com' },
	--Jango
	{ 0, 987, 'jango.com' },
	--Kaixin001
	{ 0, 989, 'kaixin001.com' },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3])
        end
    end

    return gDetector
end

function DetectorClean()
end
