--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: XWindows
version: 7
description: Remote graphical user interface.
bundle_description: $VAR1 = {
          'XWindows' => 'Remote graphical user interface.'
        };

--]]

require "DetectorCommon"



local DC = DetectorCommon
local FT = flowTrackerModule

gServiceId = 20098
gServiceName = 'XWindows'
gDetector = nil

DetectorPackageInfo = {
    name =  "XWindows",
    proto =  DC.ipproto.tcp,
    server = {
        init =  'DetectorInit',
        validate =  'DetectorValidator',
    }
}

gSfAppIdXWindows = 925

gPatterns = {
	initPattern1 = { "\000\011\000\000", 2, gSfAppIdXWindows},
	initPattern2 = { "\011\000\000\000", 2, gSfAppIdXWindows},
}

gFastPatterns = {
    {DC.ipproto.tcp, gPatterns.initPattern1},
    {DC.ipproto.tcp, gPatterns.initPattern2},
}

gPorts = {
	{DC.ipproto.tcp, 6000},
	{DC.ipproto.tcp, 6001},
	{DC.ipproto.tcp, 6002},
}


gAppRegistry = {
	--AppIdValue          Extracts Info
	---------------------------------------
	{gSfAppIdXWindows,		         0}
}

function serviceInProcess(context)

    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:inProcessService()
    end

    DC.printf('%s: Inprocess, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.inProcess
end

function serviceSuccess(context)
    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:addService(gServiceId, "", "", gSfAppIdXWindows)
    end

    DC.printf('%s: Detected, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.success
end

function serviceFail(context)
    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:failService()
    end

    context.detectorFlow:clearFlowFlag(DC.flowFlags.continue)
    DC.printf('%s: Failed, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.nomatch
end

function registerPortsPatterns()

    --register port based detection
    for i,v in ipairs(gPorts) do
        gDetector:addPort(v[1], v[2])
    end

    --register pattern based detection
    for i,v in ipairs(gFastPatterns) do
        if ( gDetector:registerPattern(v[1], v[2][1], #v[2][1], v[2][2], v[2][3]) ~= 0) then
            DC.printf ('%s: register pattern failed for %s\n', gServiceName,v[2][1])
        else
            DC.printf ('%s: register pattern successful for %s\n', gServiceName,v[2][1])
        end
    end

	for i,v in ipairs(gAppRegistry) do
		pcall(function () gDetector:registerAppId(v[1],v[2]) end)
	end

end

--[[ Core engine calls DetectorInit() to initialize a detector.
--]]
function DetectorInit( detectorInstance)

    gDetector = detectorInstance
    DC.printf ('%s:DetectorInit()\n', gServiceName);
    gDetector:init(gServiceName, 'DetectorValidator', 'DetectorFini')
    registerPortsPatterns()

    return gDetector
end

local function validate_pixmap(size, vendorLength, vendorLength2)
    if (size >= 43 + vendorLength2 and gDetector:memcmp('\001\001\032', 3, 40 + vendorLength2) == 0)
        or (size >= 43 + vendorLength and
            gDetector:memcmp('\001\001\032', 3, 40 + vendorLength) == 0) then
        return true
    else
        return false
    end
end

--[[Validator function registered in DetectorInit()
--]]
function DetectorValidator()
    local context = {}
    context.detectorFlow = gDetector:getFlow()
    context.packetDataLen = gDetector:getPacketSize()
    context.packetDir = gDetector:getPacketDir()
    context.srcIp = gDetector:getPktSrcAddr()
    context.dstIp = gDetector:getPktDstAddr()
    context.srcPort = gDetector:getPktSrcPort()
    context.dstPort = gDetector:getPktDstPort()
    context.flowKey = context.detectorFlow:getFlowKey()
    context.packetCount = gDetector:getPktCount()
    local size = context.packetDataLen
    local dir = context.packetDir
    local srcPort = context.srcPort
    local dstPort = context.dstPort
    local flowKey = context.flowKey

    DC.printf ('%s:DetectorValidator(): packetCount %d, dir %d, size %d\n', gServiceName,
               context.packetCount, dir, size);
    if (size == 0 or dir == 0) then
        return serviceInProcess(context)
    end


    if ((dir == 1) and
        ((gDetector:memcmp(gPatterns.initPattern1[1], #gPatterns.initPattern1[1], gPatterns.initPattern1[2]) == 0) or
         (gDetector:memcmp(gPatterns.initPattern2[1], #gPatterns.initPattern2[1], gPatterns.initPattern2[2]) == 0)))
	then
        matched, initialByte = gDetector:getPcreGroups('(.)', 0)
		if (initialByte == '\001' and size >= 43) then
			matched2, vendorLengthRaw = gDetector:getPcreGroups('(..)', 24)
			vendorLength = DC.binaryStringToNumber(vendorLengthRaw, 2)
			vendorLength2 = DC.reverseBinaryStringToNumber(vendorLengthRaw, 2)
			if not validate_pixmap(size, vendorLength, vendorLength2) then
			    return serviceFail(context)
			end
		    return serviceSuccess(context)
		elseif (initialByte == '\000') then
			return serviceSuccess(context)
		end
   end

    return serviceFail(context)
end

--[[Required DetectorFini function
--]]
function DetectorFini()
    --print (gServiceName .. ': DetectorFini()')
end

