--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group "Menudo"
version: 20
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Linux Mint' => 'Linux based Operating System.',
          'Vine' => 'Mobile App for sharing photos and videos clips.',
          'OsiriX' => 'Image processing tool for DICOM images.',
          'Gravatar' => 'Profile picture management for comments and discussion forum.',
          'Google' => 'Traffic generated by the Google search engine or one of the other many Internet services provided by Google Inc.',
          'MyLife' => 'Social Networking.',
          'GitHub' => 'Code management portal for open Source projects.',
          'Flexera Software' => 'Software tools for creating packages with compatible to cross platforms.',
          'GoToMyPC' => 'PC remote control software.',
          'The Washington Post' => 'American daily newspaper.',
          'Trend Micro' => 'Security software company.',
          'Ning' => 'Social Networking.',
          'Fancy' => 'Social media to share and buy items.',
          'SOUNDROP' => 'Listen to music online.',
          'QualysGuard' => 'Cloud security and compliance solutions.',
          'Kickstarter' => 'Platform for creative projects with funding goal and deadline.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "payload_group_menudo",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--serviceId, clientId, ClientType, PayloadId, PayloadType, hostPattern, pathPattern, schemePattern, queryPattern
gUrlPatternList = {

   --Fancy
    { 0, 0, 0, 854,22, "thefancy.s3.amazonaws.com", "/", "http:", "", 1668},
    { 0, 0, 0, 854,22, "thefancy.com", "/", "http:", "", 1668},
    { 0, 0, 0, 854,22, "fancyimgs.com", "/", "http:", "", 1668},
   --GitHub
    { 0, 0, 0, 855,22, "github.com", "/", "http:", "", 1670},
    { 0, 0, 0, 855,22, "githubusercontent.com", "/", "http:", "", 1670},
    { 0, 0, 0, 855,22, "githubapp.com", "/", "http:", "", 1670},
    { 0, 0, 0, 855,22, "githubassets.com", "/", "http:", "", 1670},
   --Trend Micro
    { 0, 0, 0, 856,22, "trendmicro.com", "/", "http:", "", 1671},
   --QualysGuard
    { 0, 0, 0, 858,22, "qualys.com", "/", "http:", "", 1675},
   --Flexera Software
    { 0, 0, 0, 859,22, "flexerasoftware.com", "/", "http:", "", 1676},
    { 0, 0, 0, 859,22, "installshield.com", "/", "http:", "", 1676},
   --OsiriX
    { 0, 0, 0, 860,22, "osirix-viewer.com", "/", "http:", "", 1677},
   --SOUNDROP
    { 0, 0, 0, 861,22, "soundrop.fm", "/", "http:", "", 1695},
   --MyLife
    { 0, 0, 0, 863,22, "mylife.com", "/", "http:", "", 1702},
   --Ning
    { 0, 0, 0, 864,22, "ning.com", "/", "http:", "", 1703},
   --Gravatr
    { 0, 0, 0, 865,22, "gravatar.com", "/", "http:", "", 1704},
   --Kickstarter
    { 0, 0, 0, 866,22, "kickstarter.com", "/", "http:", "", 1705},
   --Vine
    { 0, 0, 0, 867,22, "vines.s3.amazonaws.com", "/", "http:", "", 1700},
    --{ 0, 0, 0, 867,22, "ver.se", "/", "http:", "", 1700},
    { 0, 0, 0, 867,22, "vine.co", "/", "http:", "", 1700},
    { 0, 0, 0, 867,22, "vineapp.com", "/", "http:", "", 1700},
   --Linux Mint
    { 0, 0, 0, 869,22, "linuxmint.com", "/", "http:", "", 1707},
    { 0, 0, 0, 869,22, "linuxmint.net", "/", "http:", "", 1707},
    { 0, 0, 0, 869,22, "linuxmint.org", "/", "http:", "", 1707},
   --Medibuntut
--    { 0, 0, 0, 870,22, "medibuntu.org", "/", "http:", "", 1708},
   --The Washington Post
    { 0, 0, 0, 871,22, "washingtonpost.com", "/", "http:", "", 1709},
   --Google 
    { 0, 0, 0, 872,22, "googletagservices.com", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "google.com", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "about.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "blog.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "registry.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "nic.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "ai.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "design.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "environment.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "pride.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "health.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "research.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "crisisresponse.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "grow.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "diversity.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "safety.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "chromeenterprise.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "domains.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "opensource.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "wellbeing.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "sustainability.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "teachfromhome.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "teachfromanywhere.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "covid19.google", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "ggpht.com", "/", "http:", "", 184},
    { 0, 0, 0, 872,22, "googleusercontent.com", "/", "http:", "", 184},
   --GoToMyPC
    { 0, 0, 0, 873,22, "gotomypc.com", "/", "http:", "", 1598},

}


function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

