--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group Full "Zappp"
version: 23
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Casale' => 'Advertisement site.',
          'Commvault' => 'Enterprise data backup and storage management software.',
          'Bloomberg' => 'Financial news and research.',
          'Blokus' => 'Online spatial strategy board game.',
          'AppNexus' => 'Real-time advertising services.',
          'Bizo' => 'Advertisement site.',
          'contnet' => 'Advertisement site.',
          '2345.com' => 'Web portal.',
          'CBS Interactive' => 'Division of CBS Corporation which coordinates ad sales and television programs together.',
          'DeNA websites' => 'Traffic generated by browsing DeNA Comm website and some other sites that belong to DeNA.',
          'MapleStory' => 'Online game portal.',
          'Connextra' => 'Advertisement site.',
          'Admeld' => 'Ad delivery company servicing online publishers.',
          'Verizon Media' => 'Advertisement site.',
          'Alibaba' => 'International trade site.',
          'Adtech' => 'Advertisement site.',
          'Admin5' => 'Chinese directory of web admins.',
          '4399.com' => 'Chinese gaming website.',
          'adSage' => 'Advertisement site.',
          'Caraytech' => 'Advertisement site.',
          'Booking.com' => 'Online travel reservation site.',
          'DioDeo' => 'Korean Entertainment news.',
          'Concur' => 'Business travel site.',
          'China News' => 'Chinese news site.',
          'Crowd Science' => 'Advertisement site.',
          '33Across' => 'Social ad delivery service.',
          'Lineage' => 'Online game for multiplayer.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "payload_group_full_zappa",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gUrlPatternList = {
	--4399.com
	{ 0, 0, 0, 1407, 20, "4399.cn", "/", "http:", "", 1256 },
	--Admin5
	{ 0, 0, 0, 1417, 22, "admin5.net", "/", "http:", "", 1258 },
	{ 0, 0, 0, 1417, 22, "admin5.cn", "/", "http:", "", 1258 },
	--Bloomberg
	{ 0, 0, 0, 1392, 33, "bloombergview.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberg.net", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "businessweek.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloombergtradebook.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloombergbriefs.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloombergindexes.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloombergsef.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bna.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bgov.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberglaw.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberglink.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloombergsports.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "newenergyfinance.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberg.tv", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberg.fm", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bnef.com", "/", "http:", "", 1259 },
	{ 0, 0, 0, 1392, 33, "bloomberglive.com", "/", "http:", "", 1259 },
	--2345.com
	{ 0, 0, 0, 1402, 22, "2345.cn", "/", "http:", "", 2346 },
	--CBS Interactive
	{ 0, 0, 0, 1460, 33, "cbspressexpress.com", "/", "http:", "", 2354 },
	--Alibaba
	{ 0, 0, 0, 1429, 15, "alibabagroup.com", "/", "http:", "", 2386 },
	--AppNexus
	{ 0, 0, 0, 1443, 22, "appnexus.net", "/", "http:", "", 2413 },
	{ 0, 0, 0, 1443, 22, "alenty.com", "/", "http:", "", 2413 },
	--33Across
	{ 0, 0, 0, 1405, 15, "tynt.com", "/", "http:", "", 2419 },
	--Admeld
	{ 0, 0, 0, 1415, 22, "google.com", "/doubleclick", "http:", "", 2454 },
	--Blokus
	{ 0, 0, 0, 1391, 20, "blokus.refreshed.be", "/", "http:", "", 2482 },
	--adSage
	{ 0, 0, 0, 1423, 22, "adsage.cn", "/", "http:", "", 2491 },
	--Adtech
	{ 0, 0, 0, 1425, 22, "adtechchina.com", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "adtechaustralia.com", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "adtech-kyushu.com", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "ad-techlondon.co.uk", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "ad-tech.sg", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "ad-tech.co.nz", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "adtech-tokyo.com", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "adtech-kansai.com", "/", "http:", "", 2503 },
	{ 0, 0, 0, 1425, 22, "adtechasean.com", "/", "http:", "", 2503 },
	--{ 0, 0, 0, 1425, 22, "adtech-korea.com", "/", "http:", "", 2503 },
	--Casale
	{ 0, 0, 0, 1459, 22, "indexexchange.com", "/", "http:", "", 2512 },
	{ 0, 0, 0, 1459, 22, "medianet.com", "/", "http:", "", 2512 },
	--Connextra
	{ 0, 0, 0, 1478, 22, "connextra.net", "/", "http:", "", 2529 },
	{ 0, 0, 0, 1478, 22, "betgenius.com", "/", "http:", "", 2529 },
	--Bizo
	{ 0, 0, 0, 1436, 22, "bizographics.com", "/", "http:", "", 2557 },
	--Verizon Media
	{ 0, 0, 0, 1454, 22, "brightroll.com", "/", "http:", "", 2558 },
	--contnet
	{ 0, 0, 0, 1479, 22, "contnet.de", "/", "http:", "", 2566 },
	--Caraytech
	{ 0, 0, 0, 1458, 22, "caraytech.com.ar", "/", "http:", "", 2573 },
	--Crowd Science
	{ 0, 0, 0, 1481, 22, "yume.com", "/", "http:", "", 2591 },
	--Booking.com
	{ 0, 0, 0, 1394, 37, "workingatbooking.com", "/", "http:", "", 2600 },
	--Concur
	{ 0, 0, 0, 1476, 15, "concur.ca", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.de", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.nl", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.fr", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.co.uk", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.co.in", "/", "http:", "", 2601 },
	{ 0, 0, 0, 1476, 15, "concur.co.jp", "/", "http:", "", 2601 },
	--China News
	{ 0, 0, 0, 1462, 33, "ecns.cn", "/", "http:", "", 2610 },
	{ 0, 0, 0, 1462, 33, "chinanews.com.cn", "/", "http:", "", 2610 },
	--DeNA websites
	{ 0, 0, 0, 1396, 22, "mbga.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "gr-oo-vy.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "dena-ec.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "aumall.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mbok.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "netsea.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "paygent.co.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "estar.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "smcb.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "skygate.co.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "arukikata.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "sougouhoken.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mobage.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mobage.cn", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mobage.kr", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "dena.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "daum-mobage.kr", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mangabox.me", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "showroom-live.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "applizemi.com", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "chirashiru.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "gbooks.jp", "/", "http:", "", 2946 },
	{ 0, 0, 0, 1396, 22, "mycode.jp", "/", "http:", "", 2946 },
	--{ 0, 0, 0, 1396, 22, "ssl.co-mm.com", "/", "http:", "", 2946 },
	--Sparrow (Deprecated)
	--{ 0, 0, 0, 1438, 12, "sparrowmailapp.com", "/", "http:", "", 3788 },
	--100ye.com (Deprecated)
	--{ 0, 0, 0, 1441, 12, "100ye.com", "/", "http:", "", 3791 },
	--DioDeo
	{ 0, 0, 0, 1486, 22, "diodeo.com", "/", "http:", "", 3799 },
	--Lineage
	{ 0, 0, 0, 1488, 22, "lineage2.com", "/", "http:", "", 3801 },
	{ 0, 0, 0, 1488, 22, "lineage.plaync.com", "/", "http:", "", 3801 },
	--MapleStory
	{ 0, 0, 0, 1489, 22, "maplestory.nexoneu.com", "/", "http:", "", 3802 },
	--Commvault
	{ 0, 0, 0, 1474, 9, "commvault.cl", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.fr", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.de", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.in", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.it", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.jp", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.nl", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.ru", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.co.za", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.se", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.ch", "/", "http:", "", 96 },
	{ 0, 0, 0, 1474, 9, "commvault.co.uk", "/", "http:", "", 96 },
	--{ 0, 0, 0, 1474, 9, "commvault.be", "/", "http:", "", 96 },
	--{ 0, 0, 0, 1474, 9, "commvault.ca", "/", "http:", "", 96 },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10])
        end
    end

    return gDetector
end

function DetectorClean()
end
