--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group Full "coldplay"
version: 20
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Hola' => 'An open source VPN.',
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Aliwangwang' => 'Instant messaging.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'Blizzard' => 'The website for Blizzard Software, a popular PC and console game company.',
          'wetpaint entertainment' => 'Television related news and media.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'Marketo' => 'Ad site.',
          'Blizzard Downloader' => 'A tool used to download clients and other software for Blizzard games.',
          'NFL.com' => 'American football news.',
          'Funshion' => 'Chinese site for online games, videos, and shopping.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'GoToTraining' => 'Citrix GoToMeeting service focused on online training.',
          'Wondershare' => 'Offers Video Software, PDF Tools, PC Utilities for Mac and Win users.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "payload_group_full_coldplay",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gUrlPatternList = {
	--F-Prot
	{ 0, 0, 0, 1812, 13, "f-prot.net", "/", "http:", "", 162 },
	--NFL.com
	{ 0, 0, 0, 1811, 22, "nflcdn.com", "/", "http:", "", 2376 },
	--wetpaint entertainment
	{ 0, 0, 0, 1809, 22, "wetpaint.me", "/", "http:", "", 2378 },
	--Funshion
	{ 0, 0, 0, 1810, 22, "fun.tv", "/", "http:", "", 2391 },
	--Aliwangwang
	{ 0, 0, 0, 1802, 5, "wangwang.taobao.com", "/", "http:", "", 2617 },
	{ 0, 0, 0, 1802, 5, "taobao.com", "/wangwang", "http:", "", 2617 },
	--WeChat
	{ 0, 0, 0, 1823, 5, "weixin.qq.com", "/", "http:", "", 2618 },
	{ 0, 0, 0, 1823, 5, "qbwup.imtt.qq.com", "/", "http:", "", 2618 },
	--GoToTraining
	{ 0, 0, 0, 1821, 8, "jointraining.com", "/", "http:", "", 2642 },
	--Livemeeting (Deprecated)
	--{ 0, 0, 0, 1825, 22, "livemeeting.com", "/", "http:", "", 265 },
	--Sharepoint Online
	{ 0, 0, 0, 1795, 8, "sharepoint.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "sharepoint.microsoft.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "sharepointonline.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "cdn.sharepointonline.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "static.sharepointonline.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "ajax.aspnetcdn.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "spoprod-a.akamaihd.net", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "onenote.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "cdn.onenote.net", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "wns.windows.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "officeclient.microsoft.com", "/", "http:", "", 2813 },
	{ 0, 0, 0, 1795, 8, "oneclient.sfx.ms", "/", "http:", "", 2813 },
	--{ 0, 0, 0, 1795, 8, "sharepointmktgv6.microsoft.com", "/", "http:", "", 2813 },
	--YiXin
	{ 0, 0, 0, 1808, 5, "netease.com", "/yixinpublic", "http:", "", 2914 },
	--DeNA Comm (Deprecated)
	--{ 0, 0, 0, 1831, 22, "ssl.co-mm.com", "/", "http:", "", 2945 },
	--GG
	{ 0, 0, 0, 1807, 5, "gg.pl", "/", "http:", "", 3706 },
	--Blizzard Downloader
	{ 0, 0, 0, 1828, 20, "dist.blizzard.com.edgesuite.net", "/", "http:", "", 3744 },
	{ 0, 0, 0, 1828, 20, "dist.blizzard.com", "/downloads", "http:", "", 3744 },
	--Blizzard
	{ 0, 0, 0, 1832, 22, "blzstatic.cn", "/", "http:", "", 3745 },
	{ 0, 0, 0, 1832, 22, "blznews.akamaized.net", "/", "http:", "", 3745 },
	{ 0, 0, 0, 1832, 22, "blzmedia-a.akamaihd.net", "/", "http:", "", 3745 },
	{ 0, 0, 0, 1832, 22, "blzprofile.akamaized.net", "/", "http:", "", 3745 },
	--Marketo
	{ 0, 0, 0, 1816, 22, "marketo.net", "/", "http:", "", 3940 },
	--Wondershare
	{ 0, 0, 0, 1833, 22, "wondershare.net", "/", "http:", "", 4038 },
	--Hola
	{ 0, 0, 0, 1836, 46, "h-cdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "h-infra.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "h-local.org", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "h-vpn.org", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "hola-vpn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "holacdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "holaspark.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "holavpn.net", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "hypernet.net", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "l-cdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-api.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-bext.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-cn.co", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-cn.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-ext.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-infra.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-int.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-lpm.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-sdk.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lum-superproxy.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-china-mail.co", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-china.biz", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-china.co", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-china.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-cn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-gsuit.org", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-io-china.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminati-io-cn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "luminatinet.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "lumtest.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "scd-cdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "smv-cdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "sparkweb.co", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "sparkweb.org", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "svd-cdn.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "testmyproxy.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "thecodeil.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "topvpn.io", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "whatismyippro.com", "/", "http:", "", 4041 },
	{ 0, 0, 0, 1836, 46, "zon-networks.com", "/", "http:", "", 4041 },
	--Citrix Online
	{ 0, 0, 0, 1822, 8, "citrixonline.com", "/", "http:", "", 87 },
	{ 0, 0, 0, 1822, 8, "citrixonlinecdn.com", "/", "http:", "", 87 },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10])
        end
    end

    return gDetector
end

function DetectorClean()
end
