--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group Full "366"
version: 1
description: Group of Payload Detectors.
bundle_description: $VAR1 = {
          'iCloud Mail' => 'iCloud Mail is an online email service included in Apple iCloud product.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "payload_group_full_366",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gUrlPatternList = {
    -- iCloud Mail
    {0, 0, 0, 4630, 1, "p02-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p03-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p04-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p05-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p06-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p07-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p08-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p09-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p10-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p11-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p12-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p13-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p14-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p15-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p16-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p17-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p18-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p19-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p20-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p21-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p22-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p23-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p24-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p25-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p26-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p27-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p28-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p29-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p30-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p31-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p32-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p33-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p34-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p35-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p36-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p37-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p38-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p39-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p40-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p41-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p42-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p43-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p44-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p45-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p46-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p47-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p48-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p49-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p50-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p51-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p52-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p53-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p54-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p55-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p56-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p57-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p58-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p59-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p60-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p61-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p62-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p63-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p64-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p65-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p66-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p67-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p68-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p69-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p70-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p71-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p72-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p73-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p74-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p75-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p76-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p77-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p78-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p79-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p80-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p81-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p82-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p83-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p84-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p85-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p86-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p87-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p88-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p89-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p90-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p91-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p92-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p93-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p94-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p95-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p96-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p97-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p98-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p99-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p100-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p101-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p102-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p103-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p104-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p105-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p106-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p107-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p108-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p109-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p110-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p111-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p112-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p113-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p114-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p115-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p116-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p117-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p118-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p119-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p120-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p121-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p122-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p123-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p124-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p125-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p126-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p127-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p128-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p129-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p130-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p131-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p132-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p133-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p134-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p135-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p136-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p137-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p138-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p139-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p140-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p141-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p142-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p143-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p144-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p145-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p146-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p147-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p148-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p149-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p150-mccgateway.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p01-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p02-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p03-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p04-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p05-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p06-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p07-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p08-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p09-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p10-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p11-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p12-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p13-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p14-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p15-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p16-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p17-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p18-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p19-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p20-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p21-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p22-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p23-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p24-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p25-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p26-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p27-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p28-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p29-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p30-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p31-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p32-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p33-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p34-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p35-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p36-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p37-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p38-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p39-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p40-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p41-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p42-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p43-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p44-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p45-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p46-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p47-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p48-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p49-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p50-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p51-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p52-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p53-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p54-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p55-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p56-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p57-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p58-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p59-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p60-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p61-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p62-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p63-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p64-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p65-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p66-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p67-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p68-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p69-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p70-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p71-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p72-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p73-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p74-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p75-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p76-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p77-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p78-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p79-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p80-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p81-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p82-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p83-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p84-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p85-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p86-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p87-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p88-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p89-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p90-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p91-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p92-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p93-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p94-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p95-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p96-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p97-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p98-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p99-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p100-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p101-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p102-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p103-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p104-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p105-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p106-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p107-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p108-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p109-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p110-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p111-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p112-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p113-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p114-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p115-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p116-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p117-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p118-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p119-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p120-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p121-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p122-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p123-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p124-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p125-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p126-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p127-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p128-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p129-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p130-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p131-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p132-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p133-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p134-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p135-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p136-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p137-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p138-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p139-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p140-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p141-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p142-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p143-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p144-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p145-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p146-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p147-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p148-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p149-mcc.icloud.com", "/", "http:", "", 7363},
    {0, 0, 0, 4630, 1, "p150-mcc.icloud.com", "/", "http:", "", 7363},
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10])
        end
    end
    gUrlPatternList = nil

    return gDetector;
end

function DetectorClean()
end
