--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group "coldplay"
version: 19
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Wondershare' => 'Offers Video Software, PDF Tools, PC Utilities for Mac and Win users.',
          'Blizzard' => 'The website for Blizzard Software, a popular PC and console game company.',
          'Hola' => 'An open source VPN.',
          'SCCM' => 'System Center Configuration Manager. Microsoft software for controlling and managing large groups of Windows computers.',
          'Battle.net site' => 'Website for Battle.net.',
          'WD softwares Download/Update' => 'Update/Download software provided by western digital.',
          'NFL.com' => 'American football news.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'Aliwangwang' => 'Instant messaging.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'Western Digital' => 'Data storage company and hard disk drive manufacturers.',
          'Marketo' => 'Ad site.',
          '050plus' => 'VoIP smartphone app.',
          'Playstation Games' => 'Playstation game traffic.',
          'Funshion' => 'Chinese site for online games, videos, and shopping.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'CCP Games' => 'Video game developer and publisher.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Demandbase' => 'Advertising and marketing site.',
          'BBC iPlayer' => 'Web and mobile app to watch BBC TV live.',
          'Net2Phone' => 'A VoIP service.',
          'Siteimprove' => 'Ad site.',
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'USAIP' => 'VPN software.',
          'Plista' => 'Marketing analytics site.',
          'GOMTV Remote Control' => 'Mobile app that allows for remote control of GOM streaming to a television set or media player.',
          'Autodesk' => 'A CAD and 3D printing software company.',
          'BaiduHi' => 'Baidu instant messaging.',
          'Blizzard Downloader' => 'A tool used to download clients and other software for Blizzard games.',
          'Munin' => 'Munin networked resource monitoring tool.',
          'wetpaint entertainment' => 'Television related news and media.',
          'Conviva' => 'Ad site.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.',
          'Intralinks' => 'A secure collaboration site.',
          'GoToTraining' => 'Citrix GoToMeeting service focused on online training.',
          'Tmall' => 'Chinese web portal and online retailer.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "payload_group_coldplay",
    proto =  DC.ipproto.tcp,
    client = {
        init = 'DetectorInit',
        clean = 'DetectorClean',
        minimum_matches = 1
    }
}

gUrlPatternList = {
	--Munin
	{ 0, 504, 5, 1830, 22, "munin-monitoring.org", "/", "http:", "", 1144 },
	--SCCM
	{ 0, 0, 0, 1799, 3, "sccmsrv-s01.vt.local", "/", "http:", "", 1150 },
	--F-Prot
	{ 0, 0, 0, 1812, 13, "f-prot.com", "/", "http:", "", 162 },
	--050plus
	{ 0, 0, 0, 1804, 5, "050plus.com", "/", "http:", "", 2325 },
	--NFL.com
	{ 0, 0, 0, 1811, 22, "nfl.com", "/", "http:", "", 2376 },
	--wetpaint entertainment
	{ 0, 0, 0, 1809, 22, "wetpaint.com", "/", "http:", "", 2378 },
	--Tmall
	{ 0, 0, 0, 1783, 22, "tmall.com", "/", "http:", "", 2387 },
	--Funshion
	{ 0, 0, 0, 1810, 22, "funshion.com", "/", "http:", "", 2391 },
	--Aliwangwang
	{ 0, 0, 0, 1802, 5, "wangxin.taobao.com", "/", "http:", "", 2617 },
	--WeChat
	{ 0, 0, 0, 1823, 5, "wechat.com", "/", "http:", "", 2618 },
	--GOMTV Remote Control
	{ 0, 0, 0, 1805, 8, "remoteapi.gomlab.com", "/", "http:", "", 2638 },
	--GoToTraining
	{ 0, 0, 0, 1821, 8, "gototraining.com", "/", "http:", "", 2642 },
	--Sharepoint Online
	{ 0, 0, 0, 1795, 8, "sharepoint.microsoftonline.com", "/", "http:", "", 2813 },
	--BBC iPlayer
	{ 0, 0, 0, 1829, 22, "bbc.co.uk", "/iplayer", "http:", "", 2857 },
	--YiXin
	{ 0, 0, 0, 1808, 5, "yixin.im", "/", "http:", "", 2914 },
	--GG
	{ 0, 0, 0, 1807, 5, "gadu-gadu.pl", "/", "http:", "", 3706 },
	--Blizzard Downloader
	{ 0, 0, 0, 1828, 20, "dist.blizzard.com.edgesuite.com", "/", "http:", "", 3744 },
	--Blizzard
	{ 0, 0, 0, 1832, 22, "blizzard.com", "/", "http:", "", 3745 },
	--Battle.net site
	{ 0, 0, 0, 1820, 22, "battle.net", "/", "http:", "", 3749 },
	--USAIP
	{ 0, 0, 0, 1796, 46, "usaip.eu", "/", "http:", "", 3755 },
	--Playstation Games
	{ 0, 0, 0, 1798, 20, "playstation.net", "/", "http:", "", 3795 },
	--Net2Phone
	{ 0, 0, 0, 1797, 5, "net2phone.com", "/", "http:", "", 3806 },
	--BaiduHi
	{ 0, 0, 0, 1824, 5, "im.baidu.com", "/", "http:", "", 3838 },
	--Autodesk
	{ 0, 0, 0, 1793, 22, "autodesk.com", "/", "http:", "", 3888 },
	--Demandbase
	{ 0, 0, 0, 1814, 22, "demandbase.com", "/", "http:", "", 3890 },
	--Intralinks
	{ 0, 0, 0, 1815, 22, "intralinks.com", "/", "http:", "", 3891 },
	--Plista
	{ 0, 0, 0, 1819, 22, "plista.com", "/", "http:", "", 3897 },
	--Conviva
	{ 0, 0, 0, 1817, 22, "conviva.com", "/", "http:", "", 3931 },
	--Marketo
	{ 0, 0, 0, 1816, 22, "marketo.com", "/", "http:", "", 3940 },
	--Siteimprove
	{ 0, 0, 0, 1818, 22, "siteimprove.com", "/", "http:", "", 3943 },
	--CCP Games
	{ 0, 0, 0, 1826, 22, "ccpgames.com", "/", "http:", "", 4005 },
	--Wondershare
	{ 0, 0, 0, 1833, 22, "wondershare.com", "/", "http:", "", 4038 },
	--Western Digital
	{ 0, 0, 0, 1834, 22, "wdc.com", "/", "http:", "", 4039 },
	--WD softwares Download/Update
	{ 0, 0, 0, 1835, 6, "download.wdc.com", "/", "http:", "", 4040 },
	--Hola
	{ 0, 0, 0, 1836, 46, "hola.org", "/", "http:", "", 4041 },
	--Citrix Online
	{ 0, 0, 0, 1822, 8, "citrix.com", "/", "http:", "", 87 },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance

    --GG
    gDetector:addHttpPattern(2, 5, 0, 501, 16, 0, 0, 'GG-Android', 3706, 1)
    gDetector:addHttpPattern(2, 5, 0, 501, 16, 0, 0, 'GG-iOS', 3706, 1)
    --YiXin
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'NETEASE-YIXIN', 2914, 1)
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'yixin_android', 2914, 1)
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'yixin_httputils', 2914, 1)
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'MWYKGVPTJP.com.yixin.yixin', 2914, 1)
    --BaiduHi
    gDetector:addHttpPattern(2, 5, 0, 503, 16, 0, 0, 'baiduHi', 3838, 1)
    --Aliwangwang
    gDetector:addHttpPattern(2, 5, 0, 504, 16, 0, 0, 'ANDROID_WW', 2617, 1)

   if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10])
        end
    end
    return gDetector
end

function DetectorClean()
end
